/*
 * Decompiled with CFR 0.152.
 */
package zathrox.explorercraft.world;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;
import zathrox.explorercraft.init.BiomesRegistry;
import zathrox.explorercraft.init.BlockReg;
import zathrox.explorercraft.util.ConfigHandler;
import zathrox.explorercraft.world.generation.WorldGenNoctiluca;
import zathrox.explorercraft.world.generation.WorldGenRicePaddy;
import zathrox.explorercraft.world.generation.WorldGenSlateDungeon;
import zathrox.explorercraft.world.generation.WorldGenWaterGrass;

public class WorldGenExplorer
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() == 0) {
            this.generateOverworld(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
            this.generateCaves(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
            this.generateOceans(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
        }
    }

    public static BlockPos getHeight(World world, BlockPos pos) {
        return world.func_175645_m(pos);
    }

    private void generateCaves(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int newY;
        BlockPos pos;
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        BlockPos height = WorldGenExplorer.getHeight(world, new BlockPos(x, 0, z));
        if (world.func_180494_b(height) == BiomesRegistry.SNOWDONIA && random.nextInt(ConfigHandler.largeDungeonChance) == 0 && !world.func_175710_j(pos = new BlockPos(x, newY = 15 + random.nextInt(30), z))) {
            WorldGenSlateDungeon SLATE_DUNGEON_TUNNEL2;
            WorldGenSlateDungeon SLATE_DUNGEON_CRYPT;
            WorldGenSlateDungeon SLATE_DUNGEON_TREASURE;
            WorldGenSlateDungeon SLATE_DUNGEON_TUNNEL;
            WorldGenSlateDungeon SLATE_DUNGEON = new WorldGenSlateDungeon("slate_dungeon_base", 9, 9, 6, false);
            SLATE_DUNGEON.func_180709_b(world, random, pos);
            if (random.nextInt(5) == 0) {
                SLATE_DUNGEON_TUNNEL = new WorldGenSlateDungeon("slate_dungeon_tunnel", 9, 7, 6, false);
                SLATE_DUNGEON_TUNNEL.func_180709_b(world, random, pos.func_177964_d(7));
                switch (random.nextInt(2)) {
                    case 0: {
                        SLATE_DUNGEON_TREASURE = new WorldGenSlateDungeon("slate_dungeon_treasure", 9, 9, 6, false);
                        SLATE_DUNGEON_TREASURE.func_180709_b(world, random, pos.func_177964_d(16));
                        break;
                    }
                    case 1: {
                        SLATE_DUNGEON_CRYPT = new WorldGenSlateDungeon("slate_dungeon_crypt", 9, 9, 6, false);
                        SLATE_DUNGEON_CRYPT.func_180709_b(world, random, pos.func_177964_d(16));
                    }
                }
            }
            if (random.nextInt(5) == 0) {
                SLATE_DUNGEON_TUNNEL = new WorldGenSlateDungeon("slate_dungeon_tunnel", 9, 7, 6, false);
                SLATE_DUNGEON_TUNNEL.func_180709_b(world, random, pos.func_177970_e(9));
                switch (random.nextInt(2)) {
                    case 0: {
                        SLATE_DUNGEON_TREASURE = new WorldGenSlateDungeon("slate_dungeon_treasure", 9, 9, 6, false);
                        SLATE_DUNGEON_TREASURE.func_180709_b(world, random, pos.func_177970_e(16));
                        break;
                    }
                    case 1: {
                        SLATE_DUNGEON_CRYPT = new WorldGenSlateDungeon("slate_dungeon_crypt", 9, 9, 6, false);
                        SLATE_DUNGEON_CRYPT.func_180709_b(world, random, pos.func_177970_e(16));
                    }
                }
            }
            if (random.nextInt(5) == 0) {
                SLATE_DUNGEON_TUNNEL2 = new WorldGenSlateDungeon("slate_dungeon_tunnel2", 7, 9, 6, false);
                SLATE_DUNGEON_TUNNEL2.func_180709_b(world, random, pos.func_177985_f(7));
                switch (random.nextInt(2)) {
                    case 0: {
                        SLATE_DUNGEON_TREASURE = new WorldGenSlateDungeon("slate_dungeon_treasure", 9, 9, 6, false);
                        SLATE_DUNGEON_TREASURE.func_180709_b(world, random, pos.func_177985_f(16));
                        break;
                    }
                    case 1: {
                        SLATE_DUNGEON_CRYPT = new WorldGenSlateDungeon("slate_dungeon_crypt", 9, 9, 6, false);
                        SLATE_DUNGEON_CRYPT.func_180709_b(world, random, pos.func_177985_f(16));
                    }
                }
            }
            if (random.nextInt(5) == 0) {
                SLATE_DUNGEON_TUNNEL2 = new WorldGenSlateDungeon("slate_dungeon_tunnel2", 7, 9, 6, false);
                SLATE_DUNGEON_TUNNEL2.func_180709_b(world, random, pos.func_177965_g(9));
                switch (random.nextInt(2)) {
                    case 0: {
                        SLATE_DUNGEON_TREASURE = new WorldGenSlateDungeon("slate_dungeon_treasure", 9, 9, 6, false);
                        SLATE_DUNGEON_TREASURE.func_180709_b(world, random, pos.func_177965_g(16));
                        break;
                    }
                    case 1: {
                        SLATE_DUNGEON_CRYPT = new WorldGenSlateDungeon("slate_dungeon_crypt", 9, 9, 6, false);
                        SLATE_DUNGEON_CRYPT.func_180709_b(world, random, pos.func_177965_g(16));
                    }
                }
            }
        }
    }

    private void generateOceans(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        BlockPos topBlock = world.func_175672_r(new BlockPos(x, 0, z));
        ResourceLocation biome = world.getBiomeForCoordsBody(topBlock).getRegistryName();
        if (biome == Biomes.field_76771_b.getRegistryName() || biome == Biomes.field_150575_M.getRegistryName() || biome == Biomes.field_76776_l.getRegistryName()) {
            if (ConfigHandler.spawnWatergrass) {
                WorldGenWaterGrass WATER_GRASS = new WorldGenWaterGrass();
                WATER_GRASS.func_180709_b(world, random, topBlock);
            }
            if (biome == Biomes.field_150575_M.getRegistryName() && ConfigHandler.spawnNoctilucas) {
                WorldGenNoctiluca NOCTILUCA = new WorldGenNoctiluca();
                NOCTILUCA.func_180709_b(world, random, topBlock);
            }
        }
    }

    private void generateOverworld(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int XX = chunkX * 16;
        int ZZ = chunkZ * 16;
        BlockPos pos = new BlockPos(XX, 70, ZZ);
        ResourceLocation biome = world.getBiomeForCoordsBody(pos).getRegistryName();
        if (biome == BiomesRegistry.BAMBOO_FOREST.getRegistryName()) {
            if (ConfigHandler.spawnJade) {
                this.generateOre(BlockReg.JADE_ORE.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 3, 50, random.nextInt(8) + 2, 10);
                this.generateOre(BlockReg.JADE_ORE.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 60, 250, random.nextInt(1) + 1, 8);
            }
            for (int i = 0; i < 5; ++i) {
                int i1 = random.nextInt(16) + 8;
                int j2 = random.nextInt(256);
                int k1 = random.nextInt(16) + 8;
                new WorldGenRicePaddy((Block)Blocks.field_150355_j).func_180709_b(world, random, pos.func_177982_a(i1, j2, k1));
            }
        }
        if (biome == BiomesRegistry.SNOWDONIA.getRegistryName()) {
            this.generateOre(BlockReg.SLATE.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 80, 255, 33, 20);
            this.generateOre(BlockReg.SLATE.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 5, 60, 33, 30);
        }
        if (biome == BiomesRegistry.FORESTED_MOUNTAIN.getRegistryName() && ConfigHandler.spawnRuby) {
            this.generateOre(BlockReg.RUBY_ORE.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 3, 80, random.nextInt(8) + 2, 10);
            this.generateOre(BlockReg.RUBY_ORE.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 80, 250, random.nextInt(1) + 1, 8);
        }
        if (ConfigHandler.spawnAmethyst) {
            this.generateOre(BlockReg.AMETHYST_ORE.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 5, 40, random.nextInt(8) + 1, 5);
        }
        if (ConfigHandler.spawnMarble) {
            this.generateOre(BlockReg.MARBLE.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 3, 40, ConfigHandler.marbleVeinSize, ConfigHandler.marbleChance);
            this.generateOre(BlockReg.MARBLE.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 40, 80, random.nextInt(5) + 5, 1);
        }
        if (ConfigHandler.spawnBasalt) {
            this.generateOre(BlockReg.BASALT.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 30, 80, ConfigHandler.basaltVeinSize, ConfigHandler.basaltChance);
            this.generateOre(BlockReg.BASALT.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 3, 30, random.nextInt(10) + 5, 2);
        }
    }

    private void generateOre(IBlockState ore, World world, Random random, int x, int z, int minY, int maxY, int size, int chances) {
        int deltaY = maxY - minY;
        for (int i = 0; i < chances; ++i) {
            BlockPos pos = new BlockPos(x + random.nextInt(16), minY + random.nextInt(deltaY), z + random.nextInt(16));
            WorldGenMinable generator = new WorldGenMinable(ore, size);
            generator.func_180709_b(world, random, pos);
        }
    }
}

