/*
 * Decompiled with CFR 0.152.
 */
package zathrox.explorercraft.world.biome;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenLiquids;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BiomeExplorerDecorator
extends BiomeDecorator {
    public int dirtSize = 33;
    public int gravelSize = 33;
    public int graniteSize = 33;
    public int dioriteSize = 33;
    public int andesiteSize = 33;
    public int coalSize = 17;
    public int ironSize = 9;
    public int goldSize = 9;
    public int redstoneSize = 9;
    public int diamondSize = 8;
    public int lapisSize = 8;
    public int dirtCount = 10;
    public int gravelCount = 8;
    public int dioriteCount = 10;
    public int graniteCount = 10;
    public int andesiteCount = 10;
    public int coalCount = 20;
    public int ironCount = 20;
    public int goldCount = 2;
    public int redstoneCount = 8;
    public int diamondCount = 1;
    public int lapisCount = 1;
    public int lapisCenterHeight = 6;
    public int lapisSpread = 16;
    public int oreGenMinHeight = 0;
    public int dirtMaxHeight = 255;
    public int gravelMaxHeight = 255;
    public int dioriteMaxHeight = 80;
    public int graniteMaxHeight = 80;
    public int andesiteMaxHeight = 80;
    public int coalMaxHeight = 126;
    public int ironMaxHeight = 64;
    public int goldMaxHeight = 32;
    public int redstoneMaxHeight = 16;
    public int diamondMaxHeight = 16;

    public BiomeExplorerDecorator() {
        this.field_76823_i = new WorldGenMinable(Blocks.field_150346_d.func_176223_P(), this.dirtSize);
        this.field_76820_j = new WorldGenMinable(Blocks.field_150351_n.func_176223_P(), this.gravelSize);
        this.field_180296_j = new WorldGenMinable(Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.GRANITE), this.graniteSize);
        this.field_180297_k = new WorldGenMinable(Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.DIORITE), this.dioriteSize);
        this.field_180295_l = new WorldGenMinable(Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE), this.andesiteSize);
        this.field_76821_k = new WorldGenMinable(Blocks.field_150365_q.func_176223_P(), this.coalSize);
        this.field_76818_l = new WorldGenMinable(Blocks.field_150366_p.func_176223_P(), this.ironSize);
        this.field_76819_m = new WorldGenMinable(Blocks.field_150352_o.func_176223_P(), this.goldSize);
        this.field_180299_p = new WorldGenMinable(Blocks.field_150450_ax.func_176223_P(), this.redstoneSize);
        this.field_180298_q = new WorldGenMinable(Blocks.field_150482_ag.func_176223_P(), this.diamondSize);
        this.field_76831_p = new WorldGenMinable(Blocks.field_150369_x.func_176223_P(), this.lapisSize);
    }

    public void func_180292_a(World worldIn, Random random, Biome biome, BlockPos pos) {
        if (this.field_185425_a) {
            throw new RuntimeException("Already decorating");
        }
        this.field_180294_c = pos;
        this.func_150513_a(biome, worldIn, random);
        this.field_185425_a = false;
    }

    protected void func_150513_a(Biome biomeIn, World worldIn, Random random) {
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(worldIn, random, this.field_180294_c));
        this.func_76797_b(worldIn, random);
        this.generate(worldIn, random, this.field_180294_c, DecorateBiomeEvent.Decorate.EventType.SAND, this.field_76810_g, this.field_76805_H);
        this.generate(worldIn, random, this.field_180294_c, DecorateBiomeEvent.Decorate.EventType.CLAY, this.field_76809_f, this.field_76806_I);
        this.generate(worldIn, random, this.field_180294_c, DecorateBiomeEvent.Decorate.EventType.SAND_PASS2, this.field_76822_h, this.field_76801_G);
        this.generate(worldIn, random, this.field_180294_c, DecorateBiomeEvent.Decorate.EventType.SAND_PASS2, this.field_76822_h, this.field_76801_G);
        this.generateTrees(worldIn, biomeIn, random, this.field_180294_c);
        this.generateFlowers(worldIn, biomeIn, random, this.field_180294_c);
        this.generateGrass(worldIn, biomeIn, random, this.field_180294_c);
        if (this.field_76808_K) {
            this.generateFalls(worldIn, random, this.field_180294_c);
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(worldIn, random, this.field_180294_c));
    }

    private void generateTrees(World worldIn, Biome biomeIn, Random random, BlockPos chunkPos) {
        int treesToGen = this.field_76832_z;
        if (random.nextFloat() < this.field_189870_A) {
            ++treesToGen;
        }
        if (TerrainGen.decorate((World)worldIn, (Random)random, (BlockPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE)) {
            for (int numTreesGenerated = 0; numTreesGenerated < treesToGen; ++numTreesGenerated) {
                int treeX = random.nextInt(16) + 8;
                int treeZ = random.nextInt(16) + 8;
                WorldGenAbstractTree treeGen = biomeIn.func_150567_a(random);
                treeGen.func_175904_e();
                BlockPos blockpos = worldIn.func_175645_m(chunkPos.func_177982_a(treeX, 0, treeZ));
                if (!treeGen.func_180709_b(worldIn, random, blockpos)) continue;
                treeGen.func_180711_a(worldIn, random, blockpos);
            }
        }
    }

    private void generateFlowers(World worldIn, Biome biomeIn, Random random, BlockPos chunkPos) {
        if (TerrainGen.decorate((World)worldIn, (Random)random, (BlockPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FLOWERS)) {
            for (int numFlowersGenerated = 0; numFlowersGenerated < this.field_76802_A; ++numFlowersGenerated) {
                int flowerZ;
                int flowerX = random.nextInt(16) + 8;
                int yRange = worldIn.func_175645_m(chunkPos.func_177982_a(flowerX, 0, flowerZ = random.nextInt(16) + 8)).func_177956_o() + 32;
                if (yRange <= 0) continue;
                int flowerY = random.nextInt(yRange);
                BlockPos flowerBlockPos = chunkPos.func_177982_a(flowerX, flowerY, flowerZ);
                this.field_150514_p.func_180709_b(worldIn, random, flowerBlockPos);
            }
        }
    }

    private void generateGrass(World worldIn, Biome biomeIn, Random random, BlockPos chunkPos) {
        if (TerrainGen.decorate((World)worldIn, (Random)random, (BlockPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.GRASS)) {
            for (int numGrassPerChunk = 0; numGrassPerChunk < this.field_76803_B; ++numGrassPerChunk) {
                int grassZ;
                int grassX = random.nextInt(16) + 8;
                int yRange = worldIn.func_175645_m(chunkPos.func_177982_a(grassX, 0, grassZ = random.nextInt(16) + 8)).func_177956_o() * 2;
                if (yRange <= 0) continue;
                int grassY = random.nextInt(yRange);
                biomeIn.func_76730_b(random).func_180709_b(worldIn, random, chunkPos.func_177982_a(grassX, grassY, grassZ));
            }
        }
    }

    private void generateFalls(World worldIn, Random random, BlockPos chunkPos) {
        if (TerrainGen.decorate((World)worldIn, (Random)random, (BlockPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_WATER)) {
            for (int k5 = 0; k5 < 50; ++k5) {
                int i10 = random.nextInt(16) + 8;
                int l13 = random.nextInt(16) + 8;
                int i17 = random.nextInt(248) + 8;
                if (i17 <= 0) continue;
                int k19 = random.nextInt(i17);
                BlockPos blockpos6 = chunkPos.func_177982_a(i10, k19, l13);
                new WorldGenLiquids((Block)Blocks.field_150358_i).func_180709_b(worldIn, random, blockpos6);
            }
        }
        if (TerrainGen.decorate((World)worldIn, (Random)random, (BlockPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_LAVA)) {
            for (int l5 = 0; l5 < 20; ++l5) {
                int j10 = random.nextInt(16) + 8;
                int i14 = random.nextInt(16) + 8;
                int j17 = random.nextInt(random.nextInt(random.nextInt(240) + 8) + 8);
                BlockPos blockpos3 = chunkPos.func_177982_a(j10, j17, i14);
                new WorldGenLiquids((Block)Blocks.field_150356_k).func_180709_b(worldIn, random, blockpos3);
            }
        }
    }

    private void generate(World worldIn, Random random, BlockPos chunkPos, DecorateBiomeEvent.Decorate.EventType eventType, WorldGenerator generator, int countPerChunk) {
        if (TerrainGen.decorate((World)worldIn, (Random)random, (BlockPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)eventType)) {
            for (int count = 0; count < countPerChunk; ++count) {
                int randX = random.nextInt(16) + 8;
                int randZ = random.nextInt(16) + 8;
                generator.func_180709_b(worldIn, random, worldIn.func_175672_r(chunkPos.func_177982_a(randX, 0, randZ)));
            }
        }
    }

    protected void func_76797_b(World worldIn, Random random) {
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Pre(worldIn, random, this.field_180294_c));
        if (TerrainGen.generateOre((World)worldIn, (Random)random, (WorldGenerator)this.field_76823_i, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.DIRT)) {
            this.func_76795_a(worldIn, random, this.dirtCount, this.field_76823_i, this.oreGenMinHeight, this.dirtMaxHeight);
        }
        if (TerrainGen.generateOre((World)worldIn, (Random)random, (WorldGenerator)this.field_76820_j, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.GRAVEL)) {
            this.func_76795_a(worldIn, random, this.gravelCount, this.field_76820_j, this.oreGenMinHeight, this.gravelMaxHeight);
        }
        if (TerrainGen.generateOre((World)worldIn, (Random)random, (WorldGenerator)this.field_180297_k, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.DIORITE)) {
            this.func_76795_a(worldIn, random, this.dioriteCount, this.field_180297_k, this.oreGenMinHeight, this.dioriteMaxHeight);
        }
        if (TerrainGen.generateOre((World)worldIn, (Random)random, (WorldGenerator)this.field_180296_j, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.GRANITE)) {
            this.func_76795_a(worldIn, random, this.graniteCount, this.field_180296_j, this.oreGenMinHeight, this.graniteMaxHeight);
        }
        if (TerrainGen.generateOre((World)worldIn, (Random)random, (WorldGenerator)this.field_180295_l, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.ANDESITE)) {
            this.func_76795_a(worldIn, random, this.andesiteCount, this.field_180295_l, this.oreGenMinHeight, this.andesiteMaxHeight);
        }
        if (TerrainGen.generateOre((World)worldIn, (Random)random, (WorldGenerator)this.field_76821_k, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.COAL)) {
            this.func_76795_a(worldIn, random, this.coalCount, this.field_76821_k, this.oreGenMinHeight, this.coalMaxHeight);
        }
        if (TerrainGen.generateOre((World)worldIn, (Random)random, (WorldGenerator)this.field_76818_l, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.IRON)) {
            this.func_76795_a(worldIn, random, this.ironCount, this.field_76818_l, this.oreGenMinHeight, this.ironMaxHeight);
        }
        if (TerrainGen.generateOre((World)worldIn, (Random)random, (WorldGenerator)this.field_76819_m, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.GOLD)) {
            this.func_76795_a(worldIn, random, this.goldCount, this.field_76819_m, this.oreGenMinHeight, this.goldMaxHeight);
        }
        if (TerrainGen.generateOre((World)worldIn, (Random)random, (WorldGenerator)this.field_180299_p, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.REDSTONE)) {
            this.func_76795_a(worldIn, random, this.redstoneCount, this.field_180299_p, this.oreGenMinHeight, this.redstoneMaxHeight);
        }
        if (TerrainGen.generateOre((World)worldIn, (Random)random, (WorldGenerator)this.field_180298_q, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.DIAMOND)) {
            this.func_76795_a(worldIn, random, this.diamondCount, this.field_180298_q, this.oreGenMinHeight, this.diamondMaxHeight);
        }
        if (TerrainGen.generateOre((World)worldIn, (Random)random, (WorldGenerator)this.field_76831_p, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.LAPIS)) {
            this.func_76793_b(worldIn, random, this.lapisCount, this.field_76831_p, this.lapisCenterHeight, this.lapisSpread);
        }
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Post(worldIn, random, this.field_180294_c));
    }
}

