/*
 * Decompiled with CFR 0.152.
 */
package zathrox.explorercraft.world.test;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class WorldGenAbstract {
    protected World world;
    protected Random rand;

    public WorldGenAbstract(World world, Random rand) {
        this.world = world;
        this.rand = rand;
    }

    public abstract void generateChunk(int var1, int var2);

    protected int findValidLog(int x, int z) {
        BlockPos midPos = new BlockPos(x, 256, z);
        BlockPos southPos = midPos.func_177968_d();
        IBlockState southState = this.world.func_180495_p(southPos);
        Block southBlock = southState.func_177230_c();
        BlockPos northPos = midPos.func_177978_c();
        IBlockState northState = this.world.func_180495_p(northPos);
        Block northBlock = northState.func_177230_c();
        BlockPos westPos = midPos.func_177976_e();
        IBlockState westState = this.world.func_180495_p(westPos);
        Block westBlock = westState.func_177230_c();
        BlockPos eastPos = midPos.func_177974_f();
        IBlockState eastState = this.world.func_180495_p(eastPos);
        Block eastBlock = eastState.func_177230_c();
        while (!(this.world.func_175623_d(midPos) && (southBlock instanceof BlockLog || northBlock instanceof BlockLog || westBlock instanceof BlockLog || eastBlock instanceof BlockLog) || midPos.func_177956_o() <= 0)) {
            midPos = midPos.func_177977_b();
            southPos = southPos.func_177977_b();
            southState = this.world.func_180495_p(southPos);
            southBlock = southState.func_177230_c();
            northPos = northPos.func_177977_b();
            northState = this.world.func_180495_p(northPos);
            northBlock = northState.func_177230_c();
            westPos = westPos.func_177977_b();
            westState = this.world.func_180495_p(westPos);
            westBlock = westState.func_177230_c();
            eastPos = eastPos.func_177977_b();
            eastState = this.world.func_180495_p(eastPos);
            eastBlock = eastState.func_177230_c();
        }
        if (midPos.func_177956_o() <= 0) {
            return -1;
        }
        return midPos.func_177956_o();
    }

    protected int findValidSurface(int x, int z) {
        BlockPos checkPos = new BlockPos(x, 256, z);
        IBlockState checkState = this.world.func_180495_p(checkPos);
        Block checkBlock = checkState.func_177230_c();
        while (checkState.func_193401_d((IBlockAccess)this.world, checkPos, EnumFacing.UP) != BlockFaceShape.SOLID && checkPos.func_177956_o() > 0) {
            checkPos = checkPos.func_177977_b();
            checkState = this.world.func_180495_p(checkPos);
            checkBlock = checkState.func_177230_c();
        }
        BlockPos spacePos = checkPos.func_177984_a();
        boolean validSpace = this.world.func_175623_d(spacePos);
        if (checkState.func_193401_d((IBlockAccess)this.world, checkPos, EnumFacing.UP) == BlockFaceShape.SOLID && validSpace) {
            return checkPos.func_177956_o() + 1;
        }
        return -1;
    }

    public int findValidDirt(int x, int z) {
        int surface = this.findValidSurface(x, z);
        BlockPos surfacePos = new BlockPos(x, surface - 1, z);
        Block surfaceBlock = this.world.func_180495_p(surfacePos).func_177230_c();
        if (surfaceBlock == Blocks.field_150349_c || surfaceBlock == Blocks.field_150346_d) {
            return surface;
        }
        return -1;
    }

    protected int findValidGrass(int x, int z) {
        int surface = this.findValidSurface(x, z);
        BlockPos surfacePos = new BlockPos(x, surface - 1, z);
        Block surfaceBlock = this.world.func_180495_p(surfacePos).func_177230_c();
        if (surfaceBlock == Blocks.field_150349_c) {
            return surface;
        }
        return -1;
    }
}

