/*
 * Decompiled with CFR 0.152.
 */
package zathrox.explorercraft.world.test;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import zathrox.explorercraft.init.BlockReg;

public abstract class WorldGenStructureBase
extends WorldGenerator {
    World world;
    Random random;
    protected EntityPlayer player;
    protected IBlockState log;
    protected IBlockState plank;
    protected IBlockState planks;
    protected IBlockState fence;
    protected IBlockState leaves;
    protected IBlockState grass;
    protected IBlockState dirt;
    protected IBlockState water;
    protected IBlockState halfSlab;
    protected IBlockState woodStair;
    protected IBlockState cobble;
    protected IBlockState stone;
    protected IBlockState stoneBrick;
    protected IBlockState glowstone;
    protected IBlockState furnace;
    protected IBlockState workbench;
    protected IBlockState chest;
    protected IBlockState glass;
    protected IBlockState marble;
    protected IBlockState marble_mossy;
    protected IBlockState marble_cracked;
    protected IBlockState marble_chiseled;
    protected IBlockState basalt;
    protected IBlockState basalt_mossy;
    protected IBlockState basalt_cracked;
    protected IBlockState basalt_chiseled;
    protected IBlockState lantern;
    protected IBlockState sandstone;
    protected IBlockState sand;
    protected IBlockState pillarSandstone;
    protected IBlockState pillarStone;
    protected IBlockState stoneBrickStair;
    protected IBlockState netherBrick;
    protected IBlockState netherBrickStair;
    protected IBlockState mossyCobble;
    protected IBlockState chair;
    protected IBlockState woodenTable;

    public WorldGenStructureBase(World w, Random r) {
        this.world = w;
        this.random = r;
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.init();
    }

    public abstract boolean func_180709_b(World var1, Random var2, BlockPos var3);

    protected void genXWall(int x, int y, int z, int width, int height, IBlockState block, int meta) {
        for (int i = 0; i <= width; ++i) {
            for (int j = 0; j <= height; ++j) {
                BlockPos genXwall = new BlockPos(x + i, y + j, z);
                this.world.func_180501_a(genXwall, block, meta);
            }
        }
    }

    protected void genXWall(int x, int y, int z, int width, int height, IBlockState block) {
        this.genXWall(x, y, z, width, height, block, 0);
    }

    protected void genZWall(int x, int y, int z, int width, int height, IBlockState block, int meta) {
        for (int i = 0; i <= width; ++i) {
            for (int j = 0; j <= height; ++j) {
                BlockPos genZwall = new BlockPos(x, y + j, z + i);
                this.world.func_180501_a(genZwall, block, meta);
            }
        }
    }

    protected void genZWall(int x, int y, int z, int width, int height, IBlockState block) {
        this.genZWall(x, y, z, width, height, block, 0);
    }

    protected void genPillar(int x, int y, int z, int height, IBlockState block, int meta) {
        for (int i = 0; i <= height; ++i) {
            BlockPos genPillar = new BlockPos(x, y + i, z);
            this.world.func_175656_a(genPillar, block);
        }
    }

    protected void genPillar(int x, int y, int z, int height, IBlockState block) {
        this.genPillar(x, y, z, height, block, 0);
    }

    protected void genPillar(int x, int y, int z, int height, IBlockState block, boolean stoneBrick) {
        for (int i = 0; i <= height; ++i) {
            BlockPos genPillar = new BlockPos(x, y + i, z);
            this.world.func_180501_a(genPillar, block, this.getRandomStoneBrickMeta());
        }
    }

    protected void genPillarWithBase(int x, int y, int z, int height, IBlockState block, int meta, IBlockState baseBlock, int baseBlockMeta) {
        this.genPillar(x, y, z, height, block, meta);
        BlockPos genPillarWithBase = new BlockPos(x, y - 1, z);
        this.world.func_180501_a(genPillarWithBase, baseBlock, baseBlockMeta);
    }

    protected void genPillarWithBase(int x, int y, int z, int height, IBlockState block, IBlockState baseBlock) {
        this.genPillarWithBase(x, y, z, height, block, 0, baseBlock, 0);
    }

    protected void genFlat(int x, int y, int z, int width, int height, IBlockState block, int meta) {
        for (int i = 0; i <= width; ++i) {
            for (int j = 0; j <= height; ++j) {
                BlockPos genPillarWithBase = new BlockPos(x + i, y, z + j);
                this.world.func_180501_a(genPillarWithBase, block, meta);
            }
        }
    }

    protected void genFlat(int x, int y, int z, int width, int height, IBlockState block) {
        this.genFlat(x, y, z, width, height, block, 0);
    }

    protected void genXWall(int x, int y, int z, int width, int height, IBlockState block, boolean stoneBrick) {
        for (int i = 0; i <= width; ++i) {
            for (int j = 0; j <= height; ++j) {
                BlockPos genXWall = new BlockPos(x + i, y + j, z);
                this.world.func_180501_a(genXWall, block, this.getRandomStoneBrickMeta());
            }
        }
    }

    protected void genXWall(int x, int y, int z, int width, int height, IBlockState block, String stoneBrick) {
        for (int i = 0; i <= width; ++i) {
            for (int j = 0; j <= height; ++j) {
                BlockPos genXWall = new BlockPos(x + i, y + j, z);
                this.world.func_180501_a(genXWall, block, this.getRandomStoneBrickMetaPrison());
            }
        }
    }

    protected void genZWall(int x, int y, int z, int width, int height, IBlockState block, boolean stoneBrick) {
        for (int i = 0; i <= width; ++i) {
            for (int j = 0; j <= height; ++j) {
                BlockPos genZWall = new BlockPos(x, y + j, z + i);
                this.world.func_180501_a(genZWall, block, this.getRandomStoneBrickMeta());
            }
        }
    }

    protected void genZWall(int x, int y, int z, int width, int height, IBlockState block, String stoneBrick) {
        for (int i = 0; i <= width; ++i) {
            for (int j = 0; j <= height; ++j) {
                BlockPos genZWall = new BlockPos(x, y + j, z + i);
                this.world.func_180501_a(genZWall, block, this.getRandomStoneBrickMetaPrison());
            }
        }
    }

    protected void genFlat(int x, int y, int z, int width, int height, IBlockState block, boolean stoneBrick) {
        for (int i = 0; i <= width; ++i) {
            for (int j = 0; j <= height; ++j) {
                BlockPos genFlat = new BlockPos(x + i, y, z + j);
                this.world.func_180501_a(genFlat, block, this.getRandomStoneBrickMeta());
            }
        }
    }

    protected void genFlat(int x, int y, int z, int width, int height, IBlockState block, String stoneBrick) {
        for (int i = 0; i <= width; ++i) {
            for (int j = 0; j <= height; ++j) {
                BlockPos genFlat = new BlockPos(x + i, y, z + j);
                this.world.func_180501_a(genFlat, block, this.getRandomStoneBrickMetaPrison());
            }
        }
    }

    protected void genWallUntilFloor(int x, int y, int z, IBlockState block, int meta) {
        int i = 0;
        while (!this.world.func_175665_u(new BlockPos(x, y - i, z))) {
            BlockPos genWallUntilFloor = new BlockPos(x, y - i, z);
            this.world.func_180501_a(genWallUntilFloor, block, meta);
            ++i;
        }
    }

    protected void genWallUntilFloor(int x, int y, int z, IBlockState block) {
        this.genWallUntilFloor(x, y, z, block, 0);
    }

    protected void genStructureFloor(int x, int y, int z, int width, int height, IBlockState block, int meta) {
        int j;
        int i;
        for (i = 0; i <= width; ++i) {
            for (j = 0; j <= height; ++j) {
                this.genWallUntilFloor(x + i, y, z + j, block, meta);
            }
        }
        for (i = -1; i <= width + 1; ++i) {
            for (j = -1; j <= height + 1; ++j) {
                this.genWallUntilFloor(x + i, y - 1, z + j, block, meta);
            }
        }
        for (i = -2; i <= width + 2; ++i) {
            for (j = -2; j <= height + 2; ++j) {
                this.genWallUntilFloor(x + i, y - 2, z + j, block, meta);
            }
        }
        for (i = -3; i <= width + 3; ++i) {
            for (j = -3; j <= height + 3; ++j) {
                this.genWallUntilFloor(x + i, y - 3, z + j, block, meta);
            }
        }
        for (i = -4; i <= width + 4; ++i) {
            for (j = -4; j <= height + 4; ++j) {
                this.genWallUntilFloor(x + i, y - 4, z + j, block, meta);
            }
        }
        for (i = -5; i <= width + 5; ++i) {
            for (j = -5; j <= height + 5; ++j) {
                this.genWallUntilFloor(x + i, y - 5, z + j, block, meta);
            }
        }
        for (i = -6; i <= width + 6; ++i) {
            for (j = -6; j <= height + 6; ++j) {
                this.genWallUntilFloor(x + i, y - 6, z + j, block, meta);
            }
        }
        for (i = -7; i <= width + 7; ++i) {
            for (j = -7; j <= height + 7; ++j) {
                this.genWallUntilFloor(x + i, y - 7, z + j, block, meta);
            }
        }
        for (i = -8; i <= width + 8; ++i) {
            for (j = -8; j <= height + 8; ++j) {
                this.genWallUntilFloor(x + i, y - 8, z + j, block, meta);
            }
        }
    }

    protected void genStructureFloor(int x, int y, int z, int width, int height, IBlockState block) {
        this.genStructureFloor(x, y, z, width, height, block, 0);
    }

    protected void genStructureFloor(int x, int y, int z, int width, int height) {
        this.genStructureFloor(x, y, z, width, height, this.grass, 0);
    }

    protected void genStructureSpace(int x, int y, int z, int width, int length, int height) {
        for (int i = 0; i <= width; ++i) {
            for (int j = 0; j <= length; ++j) {
                for (int k = 0; k <= height; ++k) {
                    BlockPos genStructureSpace = new BlockPos(x + i, y + k, z + j);
                    this.world.func_175698_g(genStructureSpace);
                }
            }
        }
    }

    protected void genStructureSpace(int x, int y, int z, int width, int length, int height, IBlockState block) {
        for (int i = 0; i <= width; ++i) {
            for (int j = 0; j <= length; ++j) {
                for (int k = 0; k <= height; ++k) {
                    if (this.world.func_180495_p(new BlockPos(x + i, y + k, z + j)) != block) continue;
                    this.world.func_175698_g(new BlockPos(x + i, y + k, z + j));
                }
            }
        }
    }

    protected boolean nextTo(int x, int y, int z, IBlockState block) {
        IBlockState i = this.world.func_180495_p(new BlockPos(x + 1, y, z));
        IBlockState j = this.world.func_180495_p(new BlockPos(x - 1, y, z));
        IBlockState k = this.world.func_180495_p(new BlockPos(x, y, z + 1));
        IBlockState l = this.world.func_180495_p(new BlockPos(x, y, z - 1));
        return i == block || j == block || k == block || l == block;
    }

    protected boolean canGenerateHere(int x, int y, int z, int width, int height) {
        return this.world.func_175623_d(new BlockPos(x, y + 3, z)) && this.world.func_175623_d(new BlockPos(x + width, y + 3, z)) && this.world.func_175623_d(new BlockPos(x + width, y + 3, z + height));
    }

    protected void spawnEntityAt(int x, int y, int z, Entity entity) {
        entity.func_70012_b((double)x + 0.5, (double)y, (double)z + 0.5, 0.0f, 0.0f);
        this.world.func_72838_d(entity);
    }

    protected int getRandomStoneBrickMeta() {
        if (this.random.nextInt(10) == 0) {
            return 1;
        }
        if (this.random.nextInt(10) == 0) {
            return 2;
        }
        return 0;
    }

    protected int getRandomStoneBrickMetaPrison() {
        if (this.random.nextInt(10) == 0) {
            return 1;
        }
        if (this.random.nextInt(10) == 0) {
            return 2;
        }
        if (this.random.nextInt(25) == 0) {
            return 4;
        }
        return 0;
    }

    protected void init() {
        this.log = Blocks.field_150364_r.func_176223_P();
        this.plank = this.planks = Blocks.field_150344_f.func_176223_P();
        this.fence = Blocks.field_180407_aO.func_176223_P();
        this.leaves = Blocks.field_150362_t.func_176223_P();
        this.grass = Blocks.field_150349_c.func_176223_P();
        this.dirt = Blocks.field_150346_d.func_176223_P();
        this.water = Blocks.field_150355_j.func_176223_P();
        this.halfSlab = Blocks.field_150333_U.func_176223_P();
        this.woodStair = Blocks.field_150476_ad.func_176223_P();
        this.cobble = Blocks.field_150347_e.func_176223_P();
        this.stone = Blocks.field_150348_b.func_176223_P();
        this.stoneBrick = Blocks.field_150417_aV.func_176223_P();
        this.glowstone = Blocks.field_150426_aN.func_176223_P();
        this.furnace = Blocks.field_150460_al.func_176223_P();
        this.workbench = Blocks.field_150462_ai.func_176223_P();
        this.chest = Blocks.field_150486_ae.func_176223_P();
        this.glass = Blocks.field_150359_w.func_176223_P();
        this.lantern = Blocks.field_150478_aa.func_176223_P();
        this.sandstone = Blocks.field_150322_A.func_176223_P();
        this.sand = Blocks.field_150354_m.func_176223_P();
        this.stoneBrickStair = Blocks.field_150389_bf.func_176223_P();
        this.netherBrick = Blocks.field_150385_bj.func_176223_P();
        this.netherBrickStair = Blocks.field_150387_bl.func_176223_P();
        this.mossyCobble = Blocks.field_150341_Y.func_176223_P();
        this.marble = BlockReg.MARBLE_BRICKS.func_176223_P();
        this.marble_mossy = BlockReg.MARBLE_MOSSY.func_176223_P();
        this.marble_cracked = BlockReg.MARBLE_CRACKED.func_176223_P();
        this.marble_chiseled = BlockReg.MARBLE_CHISELED.func_176223_P();
        this.basalt = BlockReg.BASALT_BRICKS.func_176223_P();
        this.basalt_mossy = BlockReg.BASALT_MOSSY.func_176223_P();
        this.basalt_cracked = BlockReg.BASALT_CRACKED.func_176223_P();
        this.basalt_chiseled = BlockReg.BASALT_CHISELED.func_176223_P();
    }
}

