/*
 * Decompiled with CFR 0.152.
 */
package com.zathrox.explorercraft.common.entity;

import com.zathrox.explorercraft.core.registry.ExplorerBannerPattern;
import com.zathrox.explorercraft.core.registry.ExplorerBlocks;
import com.zathrox.explorercraft.core.registry.ExplorerItems;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtCustomerGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookAtWithoutMovingGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.merchant.IMerchant;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.SmallFireballEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WizardEntity
extends AbstractVillagerEntity
implements IMerchant {
    private static final DataParameter<Boolean> SWINGING_ARMS = EntityDataManager.func_187226_a(WizardEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(WizardEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public int spellTime;

    public WizardEntity(EntityType<? extends WizardEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new TradeWithPlayerGoal((AbstractVillagerEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new LookAtCustomerGoal((AbstractVillagerEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new FireballAttackGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.35));
        this.field_70714_bg.func_75776_a(8, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, VillagerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtWithoutMovingGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(10, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, true));
    }

    @Nullable
    public AgeableEntity func_90011_a(AgeableEntity ageableEntity) {
        return null;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SWINGING_ARMS, (Object)false);
        this.field_70180_af.func_187214_a(ATTACKING, (Object)false);
    }

    public boolean func_184645_a(PlayerEntity p_184645_1_, Hand held) {
        boolean lvt_4_1_;
        ItemStack itemStack = p_184645_1_.func_184586_b(held);
        boolean bl = lvt_4_1_ = itemStack.func_77973_b() == Items.field_151057_cb;
        if (lvt_4_1_) {
            itemStack.func_111282_a(p_184645_1_, (LivingEntity)this, held);
            return true;
        }
        if (itemStack.func_77973_b() != Items.field_196172_da && this.func_70089_S() && !this.func_213716_dX() && !this.func_70631_g_()) {
            if (held == Hand.MAIN_HAND) {
                p_184645_1_.func_195066_a(Stats.field_188074_H);
            }
            if (this.func_213706_dY().isEmpty()) {
                this.shakeHead();
                return super.func_184645_a(p_184645_1_, held);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_70932_a_(p_184645_1_);
                this.func_213707_a(p_184645_1_, this.func_145748_c_(), 1);
            }
            return true;
        }
        this.shakeHead();
        return super.func_184645_a(p_184645_1_, held);
    }

    private void shakeHead() {
        this.func_213720_r(40);
        if (!this.field_70170_p.func_201670_d()) {
            this.func_184185_a(SoundEvents.field_187913_gm, this.func_70599_aP(), this.func_70647_i());
        }
    }

    public static ItemStack createWelshFlagBanner() {
        ItemStack banner = new ItemStack((IItemProvider)Items.field_196191_eg);
        CompoundNBT tag = banner.func_190925_c("BlockEntityTag");
        ListNBT lvt_2_1_ = new BannerPattern.Builder().func_222477_a(BannerPattern.HALF_VERTICAL, DyeColor.GREEN).func_222477_a(ExplorerBannerPattern.WELSH_FLAG, DyeColor.RED).func_222476_a();
        tag.func_218657_a("Patterns", (INBT)lvt_2_1_);
        banner.func_200302_a(new TranslationTextComponent("block.explorercraf.welsh_flag", new Object[0]).func_211708_a(TextFormatting.DARK_RED));
        return banner;
    }

    protected void func_213713_b(MerchantOffer merchantOffer) {
        if (merchantOffer.func_222221_q()) {
            int exp = 3 + this.field_70146_Z.nextInt(4);
            this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, exp));
        }
    }

    public boolean func_213705_dZ() {
        return false;
    }

    public MerchantOffers func_213706_dY() {
        if (this.field_213724_bz == null) {
            this.field_213724_bz = new MerchantOffers();
            this.func_213712_ef();
        } else if (this.field_70146_Z.nextInt(5) == 0) {
            this.field_213724_bz.clear();
            this.func_213712_ef();
        }
        return this.field_213724_bz;
    }

    protected void func_213712_ef() {
        if (this.getRareLoot() != null && WizardEntity.getCommonLoot() != null) {
            MerchantOffers offers = this.func_213706_dY();
            offers.clear();
            int maxTrades = this.field_70146_Z.nextInt(5) + 5;
            this.func_213717_a(offers, WizardEntity.getCommonLoot(), maxTrades);
            int i = this.field_70146_Z.nextInt(this.getRareLoot().size());
            MerchantOffer rareOffer = this.getRareLoot().get(i);
            if (rareOffer != null) {
                offers.add((Object)rareOffer);
            }
        }
    }

    public List<MerchantOffer> getRareLoot() {
        ArrayList<MerchantOffer> tradeList = new ArrayList<MerchantOffer>();
        tradeList.add(new MerchantOffer(new ItemStack((IItemProvider)ExplorerBlocks.DRAGON_HEART), new ItemStack((IItemProvider)Items.field_151042_j, 64), new ItemStack((IItemProvider)ExplorerItems.WELSH_SHIELD), 1, 5, 5.0f));
        tradeList.add(new MerchantOffer(new ItemStack((IItemProvider)ExplorerBlocks.DRAGON_HEART), new ItemStack((IItemProvider)Blocks.field_196563_aS, 64), new ItemStack((IItemProvider)ExplorerItems.WIZARD_HAT), 1, 5, 1.0f));
        tradeList.add(new MerchantOffer(new ItemStack((IItemProvider)ExplorerBlocks.DRAGON_HEART), new ItemStack((IItemProvider)ExplorerBlocks.ASH_LOG, 64), new ItemStack((IItemProvider)ExplorerItems.WIZARD_STAFF), 1, 5, 1.0f));
        tradeList.add(new MerchantOffer(new ItemStack((IItemProvider)ExplorerBlocks.DRAGON_HEART), new ItemStack((IItemProvider)Items.field_196191_eg, 1), WizardEntity.createWelshFlagBanner(), 8, 5, 1.0f));
        tradeList.add(new MerchantOffer(new ItemStack((IItemProvider)ExplorerBlocks.DRAGON_HEART), new ItemStack((IItemProvider)ExplorerBlocks.SLATE_CHISELED, 64), new ItemStack((IItemProvider)ExplorerBlocks.SLATE_WELSH, 64), 1, 5, 5.0f));
        return tradeList;
    }

    public static VillagerTrades.ITrade[] getCommonLoot() {
        VillagerTrades.ITrade[] tradeListCommon = new VillagerTrades.ITrade[]{new ItemsForGemTrade(Items.field_221601_aC, 2, 1, 5, 1), new ItemsForGemTrade(Items.field_151123_aH, 4, 1, 5, 1), new ItemsForGemTrade(Items.field_221695_cJ, 2, 1, 5, 1), new ItemsForGemTrade(Items.field_205157_eZ, 5, 1, 5, 1), new ItemsForGemTrade(Items.field_221676_az, 1, 1, 12, 1), new ItemsForGemTrade(Items.field_222065_kN, 1, 1, 8, 1), new ItemsForGemTrade(Items.field_221687_cF, 1, 1, 4, 1), new ItemsForGemTrade(Items.field_222066_kO, 3, 1, 12, 1), new ItemsForGemTrade(Items.field_221774_cw, 3, 1, 8, 1), new ItemsForGemTrade(Items.field_221620_aV, 1, 1, 12, 1), new ItemsForGemTrade(Items.field_221621_aW, 1, 1, 8, 1), new ItemsForGemTrade(Items.field_221622_aX, 1, 1, 12, 1), new ItemsForGemTrade(Items.field_221623_aY, 1, 1, 12, 1), new ItemsForGemTrade(Items.field_221624_aZ, 1, 1, 12, 1), new ItemsForGemTrade(Items.field_221678_ba, 1, 1, 12, 1), new ItemsForGemTrade(Items.field_221680_bb, 1, 1, 12, 1), new ItemsForGemTrade(Items.field_221682_bc, 1, 1, 12, 1), new ItemsForGemTrade(Items.field_221684_bd, 1, 1, 12, 1), new ItemsForGemTrade(Items.field_221684_bd, 1, 1, 12, 1), new ItemsForGemTrade(Items.field_221686_be, 1, 1, 12, 1), new ItemsForGemTrade(Items.field_221688_bf, 1, 1, 7, 1), new ItemsForGemTrade(Items.field_151014_N, 1, 1, 12, 1), new ItemsForGemTrade(Items.field_185163_cU, 1, 1, 12, 1), new ItemsForGemTrade(Items.field_151080_bb, 1, 1, 12, 1), new ItemsForGemTrade(Items.field_151081_bc, 1, 1, 12, 1), new ItemsForGemTrade(Items.field_221596_x, 5, 1, 8, 1), new ItemsForGemTrade(Items.field_221594_v, 5, 1, 8, 1), new ItemsForGemTrade(Items.field_221597_y, 5, 1, 8, 1), new ItemsForGemTrade(Items.field_221595_w, 5, 1, 8, 1), new ItemsForGemTrade(Items.field_221592_t, 5, 1, 8, 1), new ItemsForGemTrade(Items.field_221593_u, 5, 1, 8, 1), new ItemsForGemTrade(Items.field_221796_dh, 1, 1, 12, 1), new ItemsForGemTrade(Items.field_221692_bh, 1, 1, 12, 1), new ItemsForGemTrade(Items.field_221694_bi, 1, 1, 12, 1), new ItemsForGemTrade(Items.field_221816_dr, 1, 2, 5, 1), new ItemsForGemTrade(Items.field_151016_H, 1, 1, 8, 1), new ItemsForGemTrade(Items.field_151073_bk, 2, 1, 3, 1), new ItemsForGemTrade(Items.field_151071_bq, 1, 1, 3, 1), new ItemsForGemTrade(Items.field_222068_kQ, 3, 1, 12, 1), new ItemsForGemTrade(ExplorerItems.RICE, 2, 1, 5, 1), new ItemsForGemTrade(ExplorerItems.LEEK, 1, 1, 12, 1), new ItemsForGemTrade(ExplorerItems.CHEESE, 1, 1, 12, 1), new ItemsForGemTrade(ExplorerItems.DRIED_FRUITS, 1, 1, 12, 1), new ItemsForGemTrade(ExplorerBlocks.TATAMI, 5, 1, 1, 1), new ItemsForGemTrade(ExplorerItems.WELSHFLAG_BANNER_PATTERN, 5, 1, 1, 1), new ItemsForGemTrade(ExplorerBlocks.DAFFODIL, 1, 1, 8, 1), new ItemsForGemTrade(ExplorerBlocks.ASH_SAPLING, 10, 1, 8, 1), new ItemsForGemTrade(ExplorerBlocks.BAMBOO_SAPLING, 5, 1, 8, 1), new ItemsForGemTrade(ExplorerBlocks.CHERRY_SAPLING, 5, 1, 8, 1), new ItemsForGemTrade(ExplorerBlocks.MAPLE_SAPLING, 5, 1, 8, 1), new ItemsForGemTrade(ExplorerBlocks.WILLOW_SAPLING, 5, 1, 8, 1), new ItemsForGemTrade(ExplorerBlocks.LUPINE, 5, 1, 8, 1), new ItemsForGemTrade(ExplorerBlocks.GREEN_MUSHROOM, 5, 1, 8, 1), new ItemsForGemTrade(ExplorerBlocks.PINK_MUSHROOM, 5, 1, 8, 1), new ItemsForGemTrade(ExplorerBlocks.NOCTILUCAS, 5, 1, 8, 1), new ItemsForGemTrade(ExplorerItems.WELSHFLAG_BANNER_PATTERN, 20, 1, 1, 1)};
        return tradeListCommon;
    }

    public static List<Item> getGems() {
        ArrayList<Item> gemList = new ArrayList<Item>();
        gemList.add(Items.field_151045_i);
        gemList.add(Items.field_151166_bC);
        gemList.add(ExplorerItems.AMETHYST);
        gemList.add(ExplorerItems.JADE);
        gemList.add(ExplorerItems.RUBY);
        return gemList;
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            int x = MathHelper.func_76128_c((double)this.field_70165_t);
            int y = MathHelper.func_76128_c((double)this.field_70163_u) + 1;
            int z = MathHelper.func_76128_c((double)this.field_70161_v);
            if (this.func_110143_aJ() > 0.0f && this.func_110143_aJ() < 10.0f) {
                ++this.spellTime;
                if (this.spellTime > 31 && this.func_110143_aJ() <= 10.0f) {
                    this.func_195064_c(new EffectInstance(Effects.field_76428_l, 100));
                    this.spellTime = 1;
                }
            }
        }
        super.func_70636_d();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(48.0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_213719_ec() > 0) {
            this.func_213720_r(this.func_213719_ec() - 1);
        }
        if (this.field_70170_p.field_72995_K && this.isAttacking()) {
            double d0 = 0.7;
            double d1 = 0.5;
            double d2 = 0.2;
            float f = this.field_70761_aq * ((float)Math.PI / 180) + MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.6662f)) * 0.25f;
            float f1 = MathHelper.func_76134_b((float)f);
            float f2 = MathHelper.func_76126_a((float)f);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.field_70165_t + (double)f1 * 0.6, this.field_70163_u + 1.8, this.field_70161_v + (double)f2 * 0.6, d0, d1, d2);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.field_70165_t - (double)f1 * 0.6, this.field_70163_u + 1.8, this.field_70161_v - (double)f2 * 0.6, d0, d1, d2);
        }
    }

    public boolean func_213397_c(double p_213397_1_) {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return this.func_213716_dX() ? SoundEvents.field_219723_nb : SoundEvents.field_219708_mT;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_219713_mY;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_219709_mU;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.74f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.field_70180_af.func_187227_b(ATTACKING, (Object)attacking);
    }

    static class FireballAttackGoal
    extends Goal {
        private final WizardEntity wizardEntity;
        private int attackStep;
        private int attackTime;
        private int field_223527_d;

        public FireballAttackGoal(WizardEntity wizardIn) {
            this.wizardEntity = wizardIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity livingEntity = this.wizardEntity.func_70638_az();
            if (livingEntity instanceof WizardEntity) {
                return false;
            }
            return livingEntity != null && livingEntity.func_70089_S() && this.wizardEntity.func_213336_c(livingEntity);
        }

        public void func_75249_e() {
            this.attackStep = 0;
        }

        public void func_75251_c() {
            this.wizardEntity.setAttacking(false);
            this.field_223527_d = 0;
        }

        public void func_75246_d() {
            --this.attackTime;
            LivingEntity livingEntity = this.wizardEntity.func_70638_az();
            if (livingEntity != null) {
                boolean canSee = this.wizardEntity.func_70635_at().func_75522_a((Entity)livingEntity);
                this.field_223527_d = canSee ? 0 : ++this.field_223527_d;
                double d0 = this.wizardEntity.func_70068_e((Entity)livingEntity);
                if (d0 < 4.0) {
                    if (!canSee) {
                        return;
                    }
                    if (this.attackTime <= 0) {
                        this.attackTime = 20;
                        livingEntity.func_70097_a(DamageSource.field_76376_m, 6.0f);
                    }
                    this.wizardEntity.func_70605_aq().func_75642_a(livingEntity.field_70165_t, livingEntity.field_70163_u, livingEntity.field_70161_v, 1.0);
                } else if (d0 < this.getFollowDistance() * this.getFollowDistance() && canSee) {
                    double d1 = livingEntity.field_70165_t - this.wizardEntity.field_70165_t;
                    double d2 = livingEntity.func_174813_aQ().field_72338_b + (double)(livingEntity.func_213302_cg() / 2.0f) - (this.wizardEntity.field_70163_u + (double)(this.wizardEntity.func_213302_cg() / 2.0f));
                    double d3 = livingEntity.field_70161_v - this.wizardEntity.field_70161_v;
                    if (this.attackTime <= 0) {
                        ++this.attackStep;
                        if (this.attackStep == 1) {
                            this.attackTime = 60;
                        } else if (this.attackStep <= 10) {
                            this.attackTime = 6;
                        } else {
                            this.attackTime = 100;
                            this.attackStep = 0;
                        }
                        if (this.attackStep > 1) {
                            float f = MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)d0)) * 0.5f;
                            this.wizardEntity.field_70170_p.func_217378_a((PlayerEntity)null, 1018, new BlockPos((Entity)this.wizardEntity), 0);
                            SmallFireballEntity fireballEntity = new SmallFireballEntity(this.wizardEntity.field_70170_p, (LivingEntity)this.wizardEntity, d1, d2, d3);
                            fireballEntity.field_70163_u = this.wizardEntity.field_70163_u + (double)(this.wizardEntity.func_213302_cg() / 2.0f) + 0.5;
                            this.wizardEntity.field_70170_p.func_217376_c((Entity)fireballEntity);
                        }
                    }
                    this.wizardEntity.func_70671_ap().func_75651_a((Entity)livingEntity, 10.0f, 10.0f);
                } else if (this.field_223527_d < 5) {
                    this.wizardEntity.func_70605_aq().func_75642_a(livingEntity.field_70165_t, livingEntity.field_70163_u, livingEntity.field_70161_v, 1.0);
                }
                this.wizardEntity.setAttacking(this.attackStep > 1);
                super.func_75246_d();
            }
        }

        private double getFollowDistance() {
            return this.wizardEntity.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
        }
    }

    public static class ItemsForGemTrade
    implements VillagerTrades.ITrade {
        private final ItemStack field_221208_a;
        private final int amount;
        private final int field_221210_c;
        private final int field_221211_d;
        private final int field_221212_e;
        private final float field_221213_f;

        public ItemsForGemTrade(Block p_i50528_1_, int p_i50528_2_, int p_i50528_3_, int p_i50528_4_, int p_i50528_5_) {
            this(new ItemStack((IItemProvider)p_i50528_1_), p_i50528_2_, p_i50528_3_, p_i50528_4_, p_i50528_5_);
        }

        public ItemsForGemTrade(Item p_i50529_1_, int p_i50529_2_, int p_i50529_3_, int p_i50529_4_) {
            this(new ItemStack((IItemProvider)p_i50529_1_), p_i50529_2_, p_i50529_3_, 12, p_i50529_4_);
        }

        public ItemsForGemTrade(Item p_i50530_1_, int p_i50530_2_, int p_i50530_3_, int p_i50530_4_, int p_i50530_5_) {
            this(new ItemStack((IItemProvider)p_i50530_1_), p_i50530_2_, p_i50530_3_, p_i50530_4_, p_i50530_5_);
        }

        public ItemsForGemTrade(ItemStack p_i50531_1_, int p_i50531_2_, int p_i50531_3_, int p_i50531_4_, int p_i50531_5_) {
            this(p_i50531_1_, p_i50531_2_, p_i50531_3_, p_i50531_4_, p_i50531_5_, 0.05f);
        }

        public ItemsForGemTrade(ItemStack p_i50532_1_, int amount, int p_i50532_3_, int p_i50532_4_, int p_i50532_5_, float p_i50532_6_) {
            this.field_221208_a = p_i50532_1_;
            this.amount = amount;
            this.field_221210_c = p_i50532_3_;
            this.field_221211_d = p_i50532_4_;
            this.field_221212_e = p_i50532_5_;
            this.field_221213_f = p_i50532_6_;
        }

        public MerchantOffer func_221182_a(Entity p_221182_1_, Random random) {
            int j = random.nextInt(WizardEntity.getGems().size());
            return new MerchantOffer(new ItemStack((IItemProvider)WizardEntity.getGems().get(j), this.amount), new ItemStack((IItemProvider)this.field_221208_a.func_77973_b(), this.field_221210_c), this.field_221211_d, this.field_221212_e, this.field_221213_f);
        }
    }
}

