/*
 * Decompiled with CFR 0.152.
 */
package com.zathrox.explorercraft.core.util;

import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.TableLootEntry;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="explorercraft")
public final class LootHandler {
    @SubscribeEvent
    public static void lootLoad(LootTableLoadEvent evt) {
        String file;
        String prefix = "minecraft:chests/";
        String mob = "minecraft:entities/";
        String village = "minecraft:chests/village/";
        String name = evt.getName().toString();
        if (name.startsWith(prefix)) {
            switch (file = name.substring(name.indexOf(prefix) + prefix.length())) {
                case "abandoned_mineshaft": 
                case "desert_pyramid": 
                case "end_city_treasure": 
                case "jungle_temple": 
                case "simple_dungeon": 
                case "nether_bridge": 
                case "shipwreck_supply": 
                case "shipwreck_treasure": 
                case "spawn_bonus_chest": 
                case "stronghold_corridor": 
                case "stronghold_crossing": 
                case "underwater_ruin_big": 
                case "underwater_ruin_small": 
                case "woodland_mansion": {
                    evt.getTable().addPool(LootHandler.getInjectPool(file));
                    break;
                }
            }
        }
        if (name.startsWith(mob)) {
            switch (file = name.substring(name.indexOf(mob) + mob.length())) {
                case "sheep": {
                    evt.getTable().addPool(LootHandler.getInjectPool(file));
                    break;
                }
            }
        }
        if (name.startsWith(village)) {
            switch (file = name.substring(name.indexOf(mob) + mob.length())) {
                case "village_armorer": 
                case "village_butcher": 
                case "village_cartographer": 
                case "village_desert_house": 
                case "village_fisher": 
                case "village_fletcher": 
                case "village_mason": 
                case "village_plains_house": 
                case "village_savanna_house": 
                case "village_shepherd": 
                case "village_snowy_house": 
                case "village_taiga_house": 
                case "village_tannery": 
                case "village_temple": 
                case "village_toolsmith": 
                case "village_weaponsmith": {
                    evt.getTable().addPool(LootHandler.getInjectPool(file));
                    break;
                }
            }
        }
    }

    private static LootPool getInjectPool(String entryName) {
        return LootPool.func_216096_a().name("explorercraft_loot").func_216045_a(LootHandler.getInjectEntry(entryName, 10)).bonusRolls(0.0f, 1.0f).func_216044_b();
    }

    private static LootEntry.Builder getInjectEntry(String name, int weight) {
        ResourceLocation table = new ResourceLocation("explorercraft", "inject/" + name);
        return TableLootEntry.func_216171_a((ResourceLocation)table).func_216086_a(weight);
    }
}

