/*
 * Decompiled with CFR 0.152.
 */
package com.zathrox.explorercraft.common.blocks.trees;

import com.zathrox.explorercraft.common.blocks.trees.ExplorerTree;
import com.zathrox.explorercraft.common.world.feature.AbstractTreeFeature2;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.server.ServerWorld;

public abstract class ExplorerSuperBigTree
extends ExplorerTree {
    @Override
    public boolean spawn(ServerWorld worldIn, BlockPos pos, BlockState blockUnder, Random random) {
        for (int i = 0; i >= -2; --i) {
            for (int j = 0; j >= -2; --j) {
                if (!ExplorerSuperBigTree.canBigTreeSpawnAt(blockUnder, (IBlockReader)worldIn, pos, i, j)) continue;
                return this.spawnBigTree(worldIn, pos, blockUnder, random, i, j);
            }
        }
        return super.spawn(worldIn, pos, blockUnder, random);
    }

    @Nullable
    public abstract AbstractTreeFeature2<NoFeatureConfig> getBigTreeFeature(Random var1);

    public boolean spawnBigTree(ServerWorld worldIn, BlockPos pos, BlockState blockUnder, Random random, int xOffset, int zOffset) {
        AbstractTreeFeature2<NoFeatureConfig> abstracttreefeature = this.getBigTreeFeature(random);
        if (abstracttreefeature == null) {
            return false;
        }
        BlockState blockstate = Blocks.field_150350_a.func_176223_P();
        worldIn.func_180501_a(pos.func_177982_a(xOffset, 0, zOffset), blockstate, 4);
        worldIn.func_180501_a(pos.func_177982_a(xOffset + 1, 0, zOffset), blockstate, 4);
        worldIn.func_180501_a(pos.func_177982_a(xOffset + 2, 0, zOffset), blockstate, 4);
        worldIn.func_180501_a(pos.func_177982_a(xOffset + 2, 0, zOffset + 1), blockstate, 4);
        worldIn.func_180501_a(pos.func_177982_a(xOffset, 0, zOffset + 1), blockstate, 4);
        worldIn.func_180501_a(pos.func_177982_a(xOffset, 0, zOffset + 2), blockstate, 4);
        worldIn.func_180501_a(pos.func_177982_a(xOffset + 1, 0, zOffset + 2), blockstate, 4);
        worldIn.func_180501_a(pos.func_177982_a(xOffset + 1, 0, zOffset + 1), blockstate, 4);
        worldIn.func_180501_a(pos.func_177982_a(xOffset + 2, 0, zOffset + 2), blockstate, 4);
        if (abstracttreefeature.func_212245_a((IWorld)worldIn, (ChunkGenerator<GenerationSettings>)worldIn.func_72863_F().func_201711_g(), random, pos.func_177982_a(xOffset, 0, zOffset), IFeatureConfig.field_202429_e)) {
            return true;
        }
        worldIn.func_180501_a(pos.func_177982_a(xOffset, 0, zOffset), blockUnder, 4);
        worldIn.func_180501_a(pos.func_177982_a(xOffset + 1, 0, zOffset), blockUnder, 4);
        worldIn.func_180501_a(pos.func_177982_a(xOffset + 2, 0, zOffset), blockUnder, 4);
        worldIn.func_180501_a(pos.func_177982_a(xOffset, 0, zOffset + 1), blockUnder, 4);
        worldIn.func_180501_a(pos.func_177982_a(xOffset, 0, zOffset + 2), blockUnder, 4);
        worldIn.func_180501_a(pos.func_177982_a(xOffset + 1, 0, zOffset + 1), blockUnder, 4);
        worldIn.func_180501_a(pos.func_177982_a(xOffset + 2, 0, zOffset + 2), blockUnder, 4);
        return false;
    }

    public static boolean canBigTreeSpawnAt(BlockState blockUnder, IBlockReader worldIn, BlockPos pos, int xOffset, int zOffset) {
        Block block = blockUnder.func_177230_c();
        return block == worldIn.func_180495_p(pos.func_177982_a(xOffset, 0, zOffset)).func_177230_c() && block == worldIn.func_180495_p(pos.func_177982_a(xOffset + 1, 0, zOffset)).func_177230_c() && block == worldIn.func_180495_p(pos.func_177982_a(xOffset + 2, 0, zOffset)).func_177230_c() && block == worldIn.func_180495_p(pos.func_177982_a(xOffset + 2, 0, zOffset + 1)).func_177230_c() && block == worldIn.func_180495_p(pos.func_177982_a(xOffset, 0, zOffset + 1)).func_177230_c() && block == worldIn.func_180495_p(pos.func_177982_a(xOffset, 0, zOffset + 2)).func_177230_c() && block == worldIn.func_180495_p(pos.func_177982_a(xOffset + 1, 0, zOffset + 2)).func_177230_c() && block == worldIn.func_180495_p(pos.func_177982_a(xOffset + 1, 0, zOffset + 1)).func_177230_c() && block == worldIn.func_180495_p(pos.func_177982_a(xOffset + 2, 0, zOffset + 2)).func_177230_c();
    }
}

