/*
 * Decompiled with CFR 0.152.
 */
package com.zathrox.explorercraft.common.enchantments;

import com.zathrox.explorercraft.core.registry.ExplorerCreatureAttributes;
import net.minecraft.enchantment.DamageEnchantment;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.AxeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;

public class ExplorerDamageEnchantment
extends Enchantment {
    private static final String[] DAMAGE_NAMES = new String[]{"nether", "ender", "illager"};
    private static final int[] MIN_COST = new int[]{1, 5, 5};
    private static final int[] LEVEL_COST = new int[]{11, 8, 8};
    private static final int[] LEVEL_COST_SPAN = new int[]{20, 20, 20};
    public final int damageType;

    public ExplorerDamageEnchantment(Enchantment.Rarity rarityIn, int damageTypeIn, EquipmentSlotType ... slots) {
        super(rarityIn, EnchantmentType.WEAPON, slots);
        this.damageType = damageTypeIn;
    }

    public boolean func_185261_e() {
        return true;
    }

    public int func_77321_a(int enchantmentLevel) {
        return MIN_COST[this.damageType] + (enchantmentLevel - 1) * LEVEL_COST[this.damageType];
    }

    public int func_223551_b(int enchantmentLevel) {
        return this.func_77321_a(enchantmentLevel) + LEVEL_COST_SPAN[this.damageType];
    }

    public int func_77325_b() {
        return 5;
    }

    public float func_152376_a(int level, CreatureAttribute creatureType) {
        if (this.damageType == 0 && creatureType == ExplorerCreatureAttributes.NETHER) {
            return 1.0f + (float)Math.max(0, level - 1) * 0.5f;
        }
        if (this.damageType == 1 && creatureType == ExplorerCreatureAttributes.ENDER) {
            return (float)level * 2.5f;
        }
        return this.damageType == 2 && creatureType == CreatureAttribute.field_223225_d_ ? (float)level * 2.5f : 0.0f;
    }

    public boolean func_77326_a(Enchantment ench) {
        return !(ench instanceof DamageEnchantment) && !(ench instanceof ExplorerDamageEnchantment);
    }

    public boolean func_92089_a(ItemStack stack) {
        return stack.func_77973_b() instanceof AxeItem ? true : super.func_92089_a(stack);
    }

    public void func_151368_a(LivingEntity user, Entity target, int level) {
        if (target instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)target;
            if (this.damageType == 2 && livingentity.func_70668_bt() == CreatureAttribute.field_223225_d_) {
                int i = 20 + user.func_70681_au().nextInt(10 * level);
                livingentity.func_195064_c(new EffectInstance(Effects.field_76421_d, i, 3));
            }
        }
    }
}

