/*
 * Decompiled with CFR 0.152.
 */
package com.zathrox.explorercraft.common.entity;

import com.zathrox.explorercraft.core.registry.ExplorerBannerPattern;
import com.zathrox.explorercraft.core.util.ExplorerTrades;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtCustomerGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookAtWithoutMovingGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.merchant.IMerchant;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.SmallFireballEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WizardEntity
extends AbstractVillagerEntity
implements IMerchant {
    private static final DataParameter<Boolean> SWINGING_ARMS = EntityDataManager.func_187226_a(WizardEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(WizardEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public int spellTime;
    protected static final int BASE_TRADES = 0;
    protected static final int RARE_TRADES = 1;
    protected static final int WELSH_TRADES = 2;

    public WizardEntity(EntityType<? extends WizardEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new TradeWithPlayerGoal((AbstractVillagerEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new LookAtCustomerGoal((AbstractVillagerEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new FireballAttackGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.35));
        this.field_70714_bg.func_75776_a(8, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, VillagerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtWithoutMovingGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(10, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, true));
    }

    @Nullable
    public AgeableEntity func_90011_a(AgeableEntity ageableEntity) {
        return null;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SWINGING_ARMS, (Object)false);
        this.field_70180_af.func_187214_a(ATTACKING, (Object)false);
    }

    public MerchantOffers func_213706_dY() {
        if (this.field_213724_bz == null) {
            this.field_213724_bz = new MerchantOffers();
            this.func_213712_ef();
        }
        return this.field_213724_bz;
    }

    public void func_213704_a(MerchantOffer offer) {
        offer.func_222219_j();
        this.field_70757_a = -this.func_70627_aG();
        this.func_213713_b(offer);
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.field_213724_bz.clear();
            this.func_213706_dY();
            this.func_213712_ef();
            this.func_213718_a((IParticleData)ParticleTypes.field_197632_y);
        }
    }

    protected void func_213713_b(MerchantOffer merchantOffer) {
        if (merchantOffer.func_222221_q()) {
            int exp = 3 + this.field_70146_Z.nextInt(4);
            this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), exp));
        }
    }

    public boolean func_213705_dZ() {
        return false;
    }

    protected void func_213712_ef() {
        MerchantOffers offers = this.func_213706_dY();
        this.func_213717_a(offers, (VillagerTrades.ITrade[])ExplorerTrades.WIZARD_TRADER.get(0), Math.max(4, this.field_70146_Z.nextInt(6) + 1));
        this.func_213717_a(offers, (VillagerTrades.ITrade[])ExplorerTrades.WIZARD_TRADER.get(1), Math.max(1, this.field_70146_Z.nextInt(1) + 1));
        this.func_213717_a(offers, (VillagerTrades.ITrade[])ExplorerTrades.WIZARD_TRADER.get(2), Math.max(1, this.field_70146_Z.nextInt(2) + 1));
    }

    protected void func_213717_a(MerchantOffers offers, @Nullable VillagerTrades.ITrade[] trades, int max) {
        if (trades == null) {
            return;
        }
        List randomIndexes = IntStream.range(0, trades.length).boxed().collect(Collectors.toList());
        Collections.shuffle(randomIndexes);
        randomIndexes = randomIndexes.subList(0, Math.min(trades.length, max));
        for (Integer index : randomIndexes) {
            VillagerTrades.ITrade trade = trades[index];
            MerchantOffer offer = trade.func_221182_a((Entity)this, this.field_70146_Z);
            if (offer == null) continue;
            offers.add((Object)offer);
        }
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_77973_b() == Items.field_151057_cb) {
            heldItem.func_111282_a(player, (LivingEntity)this, hand);
            return true;
        }
        if (this.func_70089_S() && !this.func_213716_dX() && !this.func_70631_g_()) {
            if (this.func_213706_dY().isEmpty()) {
                this.shakeHead();
                return super.func_184645_a(player, hand);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_70932_a_(player);
                this.func_213707_a(player, this.func_145748_c_(), 1);
            }
            return true;
        }
        this.shakeHead();
        return super.func_184645_a(player, hand);
    }

    private void shakeHead() {
        this.func_213720_r(40);
        if (!this.field_70170_p.func_201670_d()) {
            this.func_184185_a(SoundEvents.field_187913_gm, this.func_70599_aP(), this.func_70647_i());
        }
    }

    public static ItemStack createWelshFlagBanner() {
        ItemStack banner = new ItemStack((IItemProvider)Items.field_196191_eg);
        CompoundNBT tag = banner.func_190925_c("BlockEntityTag");
        ListNBT lvt_2_1_ = new BannerPattern.Builder().func_222477_a(BannerPattern.HALF_VERTICAL, DyeColor.GREEN).func_222477_a(ExplorerBannerPattern.WELSH_FLAG, DyeColor.RED).func_222476_a();
        tag.func_218657_a("Patterns", (INBT)lvt_2_1_);
        banner.func_200302_a(new TranslationTextComponent("block.explorercraf.welsh_flag", new Object[0]).func_211708_a(TextFormatting.DARK_RED));
        return banner;
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            int x = MathHelper.func_76128_c((double)this.func_226277_ct_());
            int y = MathHelper.func_76128_c((double)this.func_226278_cu_()) + 1;
            int z = MathHelper.func_76128_c((double)this.func_226281_cx_());
            if (this.func_110143_aJ() > 0.0f && this.func_110143_aJ() < 10.0f) {
                ++this.spellTime;
                if (this.spellTime > 31 && this.func_110143_aJ() <= 10.0f) {
                    this.func_195064_c(new EffectInstance(Effects.field_76428_l, 100));
                    this.spellTime = 1;
                }
            }
        }
        super.func_70636_d();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(48.0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_213719_ec() > 0) {
            this.func_213720_r(this.func_213719_ec() - 1);
        }
        if (this.field_70170_p.field_72995_K && this.isAttacking()) {
            double d0 = 0.7;
            double d1 = 0.5;
            double d2 = 0.2;
            float f = this.field_70761_aq * ((float)Math.PI / 180) + MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.6662f)) * 0.25f;
            float f1 = MathHelper.func_76134_b((float)f);
            float f2 = MathHelper.func_76126_a((float)f);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.func_226277_ct_() + (double)f1 * 0.6, this.func_226278_cu_() + 1.8, this.func_226281_cx_() + (double)f2 * 0.6, d0, d1, d2);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.func_226277_ct_() - (double)f1 * 0.6, this.func_226278_cu_() + 1.8, this.func_226281_cx_() - (double)f2 * 0.6, d0, d1, d2);
        }
    }

    public boolean func_213397_c(double p_213397_1_) {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return this.func_213716_dX() ? SoundEvents.field_219723_nb : SoundEvents.field_219708_mT;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_219713_mY;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_219709_mU;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.74f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.field_70180_af.func_187227_b(ATTACKING, (Object)attacking);
    }

    static class FireballAttackGoal
    extends Goal {
        private final WizardEntity wizardEntity;
        private int attackStep;
        private int attackTime;
        private int field_223527_d;

        public FireballAttackGoal(WizardEntity wizardIn) {
            this.wizardEntity = wizardIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity livingEntity = this.wizardEntity.func_70638_az();
            if (livingEntity instanceof WizardEntity) {
                return false;
            }
            return livingEntity != null && livingEntity.func_70089_S() && this.wizardEntity.func_213336_c(livingEntity);
        }

        public void func_75249_e() {
            this.attackStep = 0;
        }

        public void func_75251_c() {
            this.wizardEntity.setAttacking(false);
            this.field_223527_d = 0;
        }

        public void func_75246_d() {
            --this.attackTime;
            LivingEntity livingEntity = this.wizardEntity.func_70638_az();
            if (livingEntity != null) {
                boolean canSee = this.wizardEntity.func_70635_at().func_75522_a((Entity)livingEntity);
                this.field_223527_d = canSee ? 0 : ++this.field_223527_d;
                double d0 = this.wizardEntity.func_70068_e((Entity)livingEntity);
                if (d0 < 4.0) {
                    if (!canSee) {
                        return;
                    }
                    if (this.attackTime <= 0) {
                        this.attackTime = 20;
                        livingEntity.func_70097_a(DamageSource.field_76376_m, 6.0f);
                    }
                    this.wizardEntity.func_70605_aq().func_75642_a(livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_(), 1.0);
                } else if (d0 < this.getFollowDistance() * this.getFollowDistance() && canSee) {
                    double d1 = livingEntity.func_226277_ct_() - this.wizardEntity.func_226277_ct_();
                    double d2 = livingEntity.func_174813_aQ().field_72338_b + (double)(livingEntity.func_213302_cg() / 2.0f) - (this.wizardEntity.func_226278_cu_() + (double)(this.wizardEntity.func_213302_cg() / 2.0f));
                    double d3 = livingEntity.func_226281_cx_() - this.wizardEntity.func_226281_cx_();
                    if (this.attackTime <= 0) {
                        ++this.attackStep;
                        if (this.attackStep == 1) {
                            this.attackTime = 60;
                        } else if (this.attackStep <= 10) {
                            this.attackTime = 6;
                        } else {
                            this.attackTime = 100;
                            this.attackStep = 0;
                        }
                        if (this.attackStep > 1) {
                            float f = MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)d0)) * 0.5f;
                            this.wizardEntity.field_70170_p.func_217378_a(null, 1018, new BlockPos((Entity)this.wizardEntity), 0);
                            SmallFireballEntity fireballEntity = new SmallFireballEntity(this.wizardEntity.field_70170_p, (LivingEntity)this.wizardEntity, d1, d2, d3);
                            fireballEntity.func_70107_b(fireballEntity.func_226277_ct_(), this.wizardEntity.func_226283_e_(0.5) + 0.5, fireballEntity.func_226281_cx_());
                            this.wizardEntity.field_70170_p.func_217376_c((Entity)fireballEntity);
                        }
                    }
                    this.wizardEntity.func_70671_ap().func_75651_a((Entity)livingEntity, 10.0f, 10.0f);
                } else if (this.field_223527_d < 5) {
                    this.wizardEntity.func_70605_aq().func_75642_a(livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_(), 1.0);
                }
                this.wizardEntity.setAttacking(this.attackStep > 1);
                super.func_75246_d();
            }
        }

        private double getFollowDistance() {
            return this.wizardEntity.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
        }
    }
}

