/*
 * Decompiled with CFR 0.152.
 */
package com.zathrox.explorercraft.common.world;

import com.zathrox.explorercraft.common.world.ExplorerFeature;
import com.zathrox.explorercraft.common.world.ExplorerStructures;
import com.zathrox.explorercraft.core.config.GeneralConfig;
import com.zathrox.explorercraft.core.config.OreGenConfig;
import com.zathrox.explorercraft.core.registry.ExplorerBiomes;
import com.zathrox.explorercraft.core.registry.ExplorerBlocks;
import java.util.Random;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.CountConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.registries.ForgeRegistries;

public class WorldGeneration {
    public static void setup() {
        Random rand = new Random();
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (((Boolean)OreGenConfig.spawnAmethyst.get()).booleanValue()) {
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, ExplorerBlocks.AMETHYST_ORE.func_176223_P(), 5)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(3, 5, 0, 40))));
            }
            if (((Boolean)OreGenConfig.spawnBasalt.get()).booleanValue()) {
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, ExplorerBlocks.BASALT.func_176223_P(), ((Integer)OreGenConfig.basaltVeinSize.get()).intValue())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)OreGenConfig.basaltChance.get()).intValue(), 30, 0, 60))));
            }
            if (((Boolean)OreGenConfig.spawnMarble.get()).booleanValue()) {
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, ExplorerBlocks.MARBLE.func_176223_P(), ((Integer)OreGenConfig.marbleVeinSize.get()).intValue())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)OreGenConfig.marbleChance.get()).intValue(), 5, 0, 40))));
            }
            if (biome == Biomes.field_150575_M || biome == Biomes.field_203619_Y || biome == Biomes.field_203620_Z || biome == Biomes.field_203618_X || biome == Biomes.field_203617_W && ((Boolean)GeneralConfig.spawnNoctilucas.get()).booleanValue()) {
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ExplorerFeature.NOCTILUCA.func_225566_b_((IFeatureConfig)new CountConfig(20)).func_227228_a_(Placement.field_215026_l.func_227446_a_((IPlacementConfig)new ChanceConfig(16))));
            }
            if (((Boolean)OreGenConfig.spawnJade.get()).booleanValue() && biome == ExplorerBiomes.BAMBOO_GROVE.get()) {
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, ExplorerBlocks.JADE_ORE.func_176223_P(), 8)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(3, 0, 0, 40))));
            }
            if (((Boolean)OreGenConfig.spawnRuby.get()).booleanValue() && biome == ExplorerBiomes.FORESTED_MOUNTAIN.get()) {
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, ExplorerBlocks.RUBY_ORE.func_176223_P(), 4)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(2, 5, 0, 50))));
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, ExplorerBlocks.RUBY_ORE.func_176223_P(), 8)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(10, 70, 0, 200))));
            }
            if (((Boolean)OreGenConfig.spawnSpawnChunkCaves.get()).booleanValue() && biome == Biomes.field_76780_h || biome == Biomes.field_150599_m) {
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, ExplorerFeature.SLIME_BLOCK.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(33, 5, 0, 40))));
            } else if (((Boolean)OreGenConfig.spawnSpawnChunkCaves.get()).booleanValue() && rand.nextInt(20) == 0) {
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, ExplorerFeature.SLIME_BLOCK.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(20, 5, 0, 40))));
            }
            if (biome == ExplorerBiomes.SNOWDONIA.get() || biome == Biomes.field_185435_ag || biome == Biomes.field_76770_e || biome == Biomes.field_150580_W || biome == ExplorerBiomes.FORESTED_MOUNTAIN.get()) {
                WorldGeneration.addSurfaceStructure(biome, ExplorerStructures.WIZARD_TOWER_STRUCTURE);
            }
            biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, ExplorerStructures.WIZARD_TOWER_STRUCTURE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        }
    }

    private static void addSurfaceStructure(Biome biome, Structure<NoFeatureConfig> structure) {
        biome.func_226711_a_(structure.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
    }
}

