/*
 * Decompiled with CFR 0.152.
 */
package com.zathrox.explorercraft.common.world.feature;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.BitSetVoxelShapePart;
import net.minecraft.util.math.shapes.VoxelShapePart;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.Tags;

public abstract class AbstractTreeFeature2<T extends IFeatureConfig>
extends Feature<T> {
    protected IPlantable sapling = (IPlantable)Blocks.field_196674_t;

    public AbstractTreeFeature2(Function<Dynamic<?>, ? extends T> p_i49920_1_) {
        super(p_i49920_1_);
    }

    protected static boolean func_214587_a(IWorldGenerationBaseReader p_214587_0_, BlockPos p_214587_1_) {
        if (!(p_214587_0_ instanceof IWorldReader)) {
            return p_214587_0_.func_217375_a(p_214587_1_, p_214573_0_ -> {
                Block block = p_214573_0_.func_177230_c();
                return p_214573_0_.func_196958_f() || p_214573_0_.func_203425_a(BlockTags.field_206952_E) || block == Blocks.field_196658_i || AbstractTreeFeature2.isDirt(block) || block.func_203417_a(BlockTags.field_200031_h) || block.func_203417_a(BlockTags.field_200030_g) || block == Blocks.field_150395_bd;
            });
        }
        return p_214587_0_.func_217375_a(p_214587_1_, state -> state.canBeReplacedByLogs((IWorldReader)p_214587_0_, p_214587_1_));
    }

    protected static boolean isAir(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        if (!(worldIn instanceof IBlockReader)) {
            return worldIn.func_217375_a(pos, BlockState::func_196958_f);
        }
        return worldIn.func_217375_a(pos, state -> state.isAir((IBlockReader)worldIn, pos));
    }

    protected static boolean isDirt(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, p_214590_0_ -> AbstractTreeFeature2.isDirt(p_214590_0_.func_177230_c()));
    }

    protected static boolean isWater(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, p_214583_0_ -> p_214583_0_.func_177230_c() == Blocks.field_150355_j);
    }

    protected static boolean isLeaves(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, p_214579_0_ -> p_214579_0_.func_203425_a(BlockTags.field_206952_E));
    }

    protected static boolean isAirOrLeaves(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        if (!(worldIn instanceof IWorldReader)) {
            return worldIn.func_217375_a(pos, p_214581_0_ -> p_214581_0_.func_196958_f() || p_214581_0_.func_203425_a(BlockTags.field_206952_E));
        }
        return worldIn.func_217375_a(pos, state -> state.canBeReplacedByLeaves((IWorldReader)worldIn, pos));
    }

    @Deprecated
    protected static boolean isDirtOrGrassBlock(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, p_214582_0_ -> {
            Block block = p_214582_0_.func_177230_c();
            return AbstractTreeFeature2.isDirt(block) || block == Blocks.field_196658_i;
        });
    }

    protected static boolean isSoil(IWorldGenerationBaseReader reader, BlockPos pos, IPlantable sapling) {
        if (!(reader instanceof IBlockReader) || sapling == null) {
            return AbstractTreeFeature2.isDirtOrGrassBlock(reader, pos);
        }
        return reader.func_217375_a(pos, state -> state.canSustainPlant((IBlockReader)reader, pos, Direction.UP, sapling));
    }

    @Deprecated
    protected static boolean isDirtOrGrassBlockOrFarmland(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, p_214586_0_ -> {
            Block block = p_214586_0_.func_177230_c();
            return AbstractTreeFeature2.isDirt(block) || block == Blocks.field_196658_i || block == Blocks.field_150458_ak;
        });
    }

    protected static boolean isSoilOrFarm(IWorldGenerationBaseReader reader, BlockPos pos, IPlantable sapling) {
        if (!(reader instanceof IBlockReader) || sapling == null) {
            return AbstractTreeFeature2.isDirtOrGrassBlockOrFarmland(reader, pos);
        }
        return reader.func_217375_a(pos, state -> state.canSustainPlant((IBlockReader)reader, pos, Direction.UP, sapling));
    }

    protected static boolean isTallPlants(IWorldGenerationBaseReader p_214576_0_, BlockPos p_214576_1_) {
        return p_214576_0_.func_217375_a(p_214576_1_, p_214588_0_ -> {
            Material material = p_214588_0_.func_185904_a();
            return material == Material.field_151582_l;
        });
    }

    @Deprecated
    protected void func_214584_a(IWorldGenerationReader p_214584_1_, BlockPos p_214584_2_) {
        if (!AbstractTreeFeature2.isDirt((IWorldGenerationBaseReader)p_214584_1_, p_214584_2_)) {
            this.func_202278_a((IWorldWriter)p_214584_1_, p_214584_2_, Blocks.field_150346_d.func_176223_P());
        }
    }

    protected void setDirtAt(IWorldGenerationReader reader, BlockPos pos, BlockPos origin) {
        if (!(reader instanceof IWorld)) {
            this.func_214584_a(reader, pos);
            return;
        }
        ((IWorld)reader).func_180495_p(pos).onPlantGrow((IWorld)reader, pos, origin);
    }

    protected void func_202278_a(IWorldWriter worldIn, BlockPos pos, BlockState state) {
        this.func_208521_b(worldIn, pos, state);
    }

    protected final void setLogState(Set<BlockPos> changedBlocks, IWorldWriter worldIn, BlockPos pos, BlockState p_208520_4_, MutableBoundingBox p_208520_5_) {
        this.func_208521_b(worldIn, pos, p_208520_4_);
        p_208520_5_.func_78888_b(new MutableBoundingBox((Vec3i)pos, (Vec3i)pos));
        if (BlockTags.field_200031_h.func_199685_a_((Object)p_208520_4_.func_177230_c())) {
            changedBlocks.add(pos.func_185334_h());
        }
    }

    private void func_208521_b(IWorldWriter p_208521_1_, BlockPos p_208521_2_, BlockState p_208521_3_) {
        p_208521_1_.func_180501_a(p_208521_2_, p_208521_3_, 19);
    }

    public final boolean func_212245_a(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, T config) {
        HashSet set = Sets.newHashSet();
        MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_78887_a();
        boolean flag = this.place(set, (IWorldGenerationReader)worldIn, rand, pos, mutableboundingbox);
        if (mutableboundingbox.field_78897_a > mutableboundingbox.field_78893_d) {
            return false;
        }
        ArrayList list = Lists.newArrayList();
        int i = 6;
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        BitSetVoxelShapePart voxelshapepart = new BitSetVoxelShapePart(mutableboundingbox.func_78883_b(), mutableboundingbox.func_78882_c(), mutableboundingbox.func_78880_d());
        try (BlockPos.PooledMutable blockpos$pooledmutableblockpos = BlockPos.PooledMutable.func_185346_s();){
            if (flag && !set.isEmpty()) {
                for (BlockPos blockpos : Lists.newArrayList((Iterable)set)) {
                    if (mutableboundingbox.func_175898_b((Vec3i)blockpos)) {
                        voxelshapepart.func_199625_a(blockpos.func_177958_n() - mutableboundingbox.field_78897_a, blockpos.func_177956_o() - mutableboundingbox.field_78895_b, blockpos.func_177952_p() - mutableboundingbox.field_78896_c, true, true);
                    }
                    for (Direction direction : Direction.values()) {
                        BlockState blockstate;
                        blockpos$pooledmutableblockpos.func_189533_g((Vec3i)blockpos).func_189536_c(direction);
                        if (set.contains(blockpos$pooledmutableblockpos) || !(blockstate = worldIn.func_180495_p((BlockPos)blockpos$pooledmutableblockpos)).func_196959_b((IProperty)BlockStateProperties.field_208514_aa)) continue;
                        ((Set)list.get(0)).add(blockpos$pooledmutableblockpos.func_185334_h());
                        this.func_208521_b((IWorldWriter)worldIn, (BlockPos)blockpos$pooledmutableblockpos, (BlockState)blockstate.func_206870_a((IProperty)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf(1)));
                        if (!mutableboundingbox.func_175898_b((Vec3i)blockpos$pooledmutableblockpos)) continue;
                        voxelshapepart.func_199625_a(blockpos$pooledmutableblockpos.func_177958_n() - mutableboundingbox.field_78897_a, blockpos$pooledmutableblockpos.func_177956_o() - mutableboundingbox.field_78895_b, blockpos$pooledmutableblockpos.func_177952_p() - mutableboundingbox.field_78896_c, true, true);
                    }
                }
            }
            for (int l = 1; l < 6; ++l) {
                Set set1 = (Set)list.get(l - 1);
                Set set2 = (Set)list.get(l);
                for (BlockPos blockpos1 : set1) {
                    if (mutableboundingbox.func_175898_b((Vec3i)blockpos1)) {
                        voxelshapepart.func_199625_a(blockpos1.func_177958_n() - mutableboundingbox.field_78897_a, blockpos1.func_177956_o() - mutableboundingbox.field_78895_b, blockpos1.func_177952_p() - mutableboundingbox.field_78896_c, true, true);
                    }
                    for (Direction direction1 : Direction.values()) {
                        int k;
                        BlockState blockstate1;
                        blockpos$pooledmutableblockpos.func_189533_g((Vec3i)blockpos1).func_189536_c(direction1);
                        if (set1.contains(blockpos$pooledmutableblockpos) || set2.contains(blockpos$pooledmutableblockpos) || !(blockstate1 = worldIn.func_180495_p((BlockPos)blockpos$pooledmutableblockpos)).func_196959_b((IProperty)BlockStateProperties.field_208514_aa) || (k = ((Integer)blockstate1.func_177229_b((IProperty)BlockStateProperties.field_208514_aa)).intValue()) <= l + 1) continue;
                        BlockState blockstate2 = (BlockState)blockstate1.func_206870_a((IProperty)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf(l + 1));
                        this.func_208521_b((IWorldWriter)worldIn, (BlockPos)blockpos$pooledmutableblockpos, blockstate2);
                        if (mutableboundingbox.func_175898_b((Vec3i)blockpos$pooledmutableblockpos)) {
                            voxelshapepart.func_199625_a(blockpos$pooledmutableblockpos.func_177958_n() - mutableboundingbox.field_78897_a, blockpos$pooledmutableblockpos.func_177956_o() - mutableboundingbox.field_78895_b, blockpos$pooledmutableblockpos.func_177952_p() - mutableboundingbox.field_78896_c, true, true);
                        }
                        set2.add(blockpos$pooledmutableblockpos.func_185334_h());
                    }
                }
            }
        }
        Template.func_222857_a((IWorld)worldIn, (int)3, (VoxelShapePart)voxelshapepart, (int)mutableboundingbox.field_78897_a, (int)mutableboundingbox.field_78895_b, (int)mutableboundingbox.field_78896_c);
        return flag;
    }

    protected abstract boolean place(Set<BlockPos> var1, IWorldGenerationReader var2, Random var3, BlockPos var4, MutableBoundingBox var5);

    protected IPlantable getSapling() {
        return this.sapling;
    }

    public AbstractTreeFeature2<T> setSapling(IPlantable sapling) {
        this.sapling = sapling;
        return this;
    }

    protected static boolean isDirt(Block blockIn) {
        return Tags.Blocks.DIRT.func_199685_a_((Object)blockIn);
    }
}

