/*
 * Decompiled with CFR 0.152.
 */
package com.zathrox.explorercraft.common.world.feature.structure;

import com.zathrox.explorercraft.common.entity.WizardEntity;
import com.zathrox.explorercraft.common.world.ExplorerStructurePieces;
import com.zathrox.explorercraft.core.registry.ExplorerEntities;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class WizardTowerPieces {
    public static void createPieces(TemplateManager templateManager, BlockPos blockPos, Rotation rotation, List<StructurePiece> components, Random random) {
        ResourceLocation wizardTowerRL = new ResourceLocation("explorercraft", "wizard_tower_v3");
        Template template = templateManager.func_200219_b(wizardTowerRL);
        if (template == null) {
            System.out.println("Could not find structure at " + new ResourceLocation("explorercraft", "structures/wizard_tower_v3"));
            return;
        }
        components.add((StructurePiece)new Piece(templateManager, wizardTowerRL, blockPos, rotation));
    }

    public static class Piece
    extends TemplateStructurePiece {
        private final ResourceLocation resourceLocation;
        private final Rotation rotation;

        public Piece(TemplateManager templateManager, ResourceLocation resourceLocation, BlockPos position, Rotation rotation) {
            super(ExplorerStructurePieces.WIZARD_TOWER_PIECE, 0);
            this.rotation = rotation;
            this.field_186178_c = position;
            this.resourceLocation = resourceLocation;
            this.func_207614_a(templateManager);
        }

        public Piece(TemplateManager templateManager, CompoundNBT data) {
            super(ExplorerStructurePieces.WIZARD_TOWER_PIECE, data);
            this.resourceLocation = new ResourceLocation(data.func_74779_i("Template"));
            this.rotation = Rotation.valueOf((String)data.func_74779_i("Rot"));
            this.func_207614_a(templateManager);
        }

        private void func_207614_a(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.resourceLocation);
            PlacementSettings placementSettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(this.rotation).func_186222_a(false).func_186218_a(null);
            this.func_186173_a(template, this.field_186178_c, placementSettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.resourceLocation.toString());
            tagCompound.func_74778_a("Rot", this.rotation.name());
        }

        protected void func_186175_a(String function, BlockPos pos, IWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if ("wizard".equals(function)) {
                WizardEntity wizardEntity = (WizardEntity)ExplorerEntities.WIZARD.func_200721_a(worldIn.func_201672_e());
                wizardEntity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                worldIn.func_217376_c((Entity)wizardEntity);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
            }
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> chunkGenerator, Random random, MutableBoundingBox boundingBox, ChunkPos chunkPos) {
            BlockPos finalBlockpos;
            BlockPos blockposOffset = new BlockPos(3, -4, 2);
            PlacementSettings placementSettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(this.rotation).func_186222_a(false).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.field_186178_c = finalBlockpos = this.field_186178_c.func_177971_a((Vec3i)Template.func_186266_a((PlacementSettings)placementSettings, (BlockPos)blockposOffset));
            boolean validConstruction = super.func_225577_a_(world, chunkGenerator, random, boundingBox, chunkPos);
            return validConstruction;
        }
    }
}

