/*
 * Decompiled with CFR 0.152.
 */
package com.zathrox.explorercraft.common.world.feature.structure;

import com.mojang.datafixers.Dynamic;
import com.zathrox.explorercraft.common.world.feature.structure.WizardTowerPieces;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class WizardTowerStructure
extends Structure<NoFeatureConfig> {
    public WizardTowerStructure(Function<Dynamic<?>, ? extends NoFeatureConfig> config) {
        super(config);
    }

    protected ChunkPos func_211744_a(ChunkGenerator<?> chunkGenerator, Random random, int x, int z, int spacingOffsetsX, int spacingOffsetsZ) {
        int maxDistance = 10;
        int minDistance = 4;
        if (minDistance == 0) {
            minDistance = 1;
        }
        int k = x + maxDistance * spacingOffsetsX;
        int l = z + maxDistance * spacingOffsetsZ;
        int i1 = k < 0 ? k - maxDistance + 1 : k;
        int j1 = l < 0 ? l - maxDistance + 1 : l;
        int targetChunkX = i1 / maxDistance;
        int targetChunkZ = j1 / maxDistance;
        ((SharedSeedRandom)random).func_202427_a(chunkGenerator.func_202089_c(), targetChunkX, targetChunkZ, 54354657);
        targetChunkX *= maxDistance;
        targetChunkZ *= maxDistance;
        return new ChunkPos(targetChunkX += random.nextInt(maxDistance - minDistance), targetChunkZ += random.nextInt(maxDistance - minDistance));
    }

    public boolean func_225558_a_(BiomeManager biomeManager, ChunkGenerator<?> chunkGenerator, Random random, int chunkPosX, int chunkPosZ, Biome biome) {
        ChunkPos chunkpos = this.func_211744_a(chunkGenerator, random, chunkPosX, chunkPosZ, 0, 0);
        if (chunkPosX == chunkpos.field_77276_a && chunkPosZ == chunkpos.field_77275_b) {
            int landHeight = chunkGenerator.func_222529_a(chunkPosX * 16, chunkPosZ * 16, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
            Random random1 = new Random(chunkPosX + chunkPosZ * 10387313);
            Rotation rotation = Rotation.values()[random1.nextInt(Rotation.values().length)];
            int i = 8;
            int j = 7;
            if (rotation == Rotation.CLOCKWISE_90) {
                i = -i;
            } else if (rotation == Rotation.CLOCKWISE_180) {
                i = -i;
                j = -j;
            } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                j = -j;
            }
            int k = (chunkPosX << 4) + 7;
            int l = (chunkPosZ << 4) + 7;
            int i1 = chunkGenerator.func_222531_c(k, l, Heightmap.Type.WORLD_SURFACE);
            int j1 = chunkGenerator.func_222531_c(k, l + j, Heightmap.Type.WORLD_SURFACE);
            int k1 = chunkGenerator.func_222531_c(k + i, l, Heightmap.Type.WORLD_SURFACE);
            int l1 = chunkGenerator.func_222531_c(k + i, l + j, Heightmap.Type.WORLD_SURFACE);
            int minHeight = Math.min(Math.min(i1, j1), Math.min(k1, l1));
            int maxHeight = Math.max(Math.max(i1, j1), Math.max(k1, l1));
            if (maxHeight - minHeight < 4 && maxHeight - minHeight > -4 && chunkGenerator.func_202094_a(biome, (Structure)this) && minHeight >= 100) {
                return true;
            }
        }
        return false;
    }

    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    public String func_143025_a() {
        return "explorercraft:wizard_tower";
    }

    public int func_202367_b() {
        return 3;
    }

    public static class Start
    extends StructureStart {
        public Start(Structure<?> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void func_214625_a(ChunkGenerator<?> chunkGenerator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn) {
            int x = chunkX * 16;
            int z = chunkZ * 16;
            Rotation rotation = Rotation.values()[this.field_214631_d.nextInt(Rotation.values().length)];
            int xOffset = 8;
            int zOffset = 7;
            if (rotation == Rotation.CLOCKWISE_90) {
                xOffset = -xOffset;
            } else if (rotation == Rotation.CLOCKWISE_180) {
                xOffset = -xOffset;
                zOffset = -zOffset;
            } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                zOffset = -zOffset;
            }
            int landHeight = chunkGenerator.func_222529_a(x + xOffset, z + zOffset, Heightmap.Type.WORLD_SURFACE);
            int i1 = chunkGenerator.func_222529_a(x, z, Heightmap.Type.WORLD_SURFACE);
            int j1 = chunkGenerator.func_222529_a(x, z + zOffset, Heightmap.Type.WORLD_SURFACE);
            int k1 = chunkGenerator.func_222529_a(x + xOffset, z, Heightmap.Type.WORLD_SURFACE);
            int l1 = chunkGenerator.func_222529_a(x + xOffset, z + zOffset, Heightmap.Type.WORLD_SURFACE);
            int minHeight = Math.min(Math.min(i1, j1), Math.min(k1, l1));
            int maxHeight = Math.max(Math.max(i1, j1), Math.max(k1, l1));
            if (maxHeight - minHeight < 2 && maxHeight - minHeight > -2) {
                BlockPos blockpos = new BlockPos(x, minHeight, z);
                System.out.println(x + ", " + z);
                WizardTowerPieces.createPieces(templateManagerIn, blockpos, rotation, this.field_75075_a, (Random)this.field_214631_d);
                this.func_202500_a();
            }
        }
    }
}

