/*
 * Decompiled with CFR 0.152.
 */
package com.zathrox.explorercraft.core.data.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.zathrox.explorercraft.core.registry.ExplorerBlocks;
import com.zathrox.explorercraft.core.registry.ExplorerItems;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.SlabBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.ConstantRange;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.StandaloneLootEntry;
import net.minecraft.world.storage.loot.conditions.BlockStateProperty;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.conditions.MatchTool;
import net.minecraft.world.storage.loot.conditions.SurvivesExplosion;
import net.minecraft.world.storage.loot.functions.ApplyBonus;
import net.minecraft.world.storage.loot.functions.ExplosionDecay;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExplorercraftLootTableProvider
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DataGenerator generator;

    public ExplorercraftLootTableProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.registerLootTables((id, lootTable) -> {
            Path path = this.getPath((ResourceLocation)id);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)lootTable), (Path)path);
            }
            catch (IOException ex) {
                LOGGER.error("Couldn't save loot table {}", (Object)path, (Object)ex);
            }
        });
    }

    private Path getPath(ResourceLocation id) {
        return this.generator.func_200391_b().resolve("data/" + id.func_110624_b() + "/loot_tables/" + id.func_110623_a() + ".json");
    }

    public String func_200397_b() {
        return "LootTables";
    }

    protected void registerLootTables(BiConsumer<ResourceLocation, LootTable> consumer) {
        ExplorercraftLootTableProvider.registerBlock(ExplorerBlocks.AMETHYST_ORE, ExplorercraftLootTableProvider.addFortuneBlockLootTable(ExplorerBlocks.AMETHYST_ORE, (IItemProvider)ExplorerItems.AMETHYST), consumer);
        ExplorercraftLootTableProvider.registerBlock(ExplorerBlocks.JADE_ORE, ExplorercraftLootTableProvider.addFortuneBlockLootTable(ExplorerBlocks.JADE_ORE, (IItemProvider)ExplorerItems.JADE), consumer);
        ExplorercraftLootTableProvider.registerBlock(ExplorerBlocks.RUBY_ORE, ExplorercraftLootTableProvider.addFortuneBlockLootTable(ExplorerBlocks.RUBY_ORE, (IItemProvider)ExplorerItems.RUBY), consumer);
        ExplorercraftLootTableProvider.registerBlock(ExplorerBlocks.AMETHYST_BLOCK, ExplorercraftLootTableProvider.addBasicBlockLootTable((IItemProvider)ExplorerBlocks.AMETHYST_BLOCK), consumer);
        ExplorercraftLootTableProvider.registerBlock(ExplorerBlocks.JADE_BLOCK, ExplorercraftLootTableProvider.addBasicBlockLootTable((IItemProvider)ExplorerBlocks.JADE_BLOCK), consumer);
        ExplorercraftLootTableProvider.registerBlock(ExplorerBlocks.RUBY_BLOCK, ExplorercraftLootTableProvider.addBasicBlockLootTable((IItemProvider)ExplorerBlocks.RUBY_BLOCK), consumer);
        ExplorercraftLootTableProvider.registerBlock(ExplorerBlocks.BASALT, ExplorercraftLootTableProvider.addDifferentDropLootTable(ExplorerBlocks.BASALT, (IItemProvider)ExplorerBlocks.BASALT_COBBLESTONE), consumer);
        ExplorercraftLootTableProvider.registerBlock(ExplorerBlocks.BASALT_SLAB, ExplorercraftLootTableProvider.addSlabBlockLootTable(ExplorerBlocks.BASALT_SLAB), consumer);
        ExplorercraftLootTableProvider.registerBlock(ExplorerBlocks.SLIMEY_STONE, ExplorercraftLootTableProvider.addDifferentDropLootTable(ExplorerBlocks.SLIMEY_STONE, (IItemProvider)Blocks.field_150348_b), consumer);
        ExplorercraftLootTableProvider.registerBlock(ExplorerBlocks.DISSOLVED_STONE, ExplorercraftLootTableProvider.addDifferentDropLootTable(ExplorerBlocks.DISSOLVED_STONE, (IItemProvider)Items.field_151123_aH), consumer);
    }

    private static void registerBlock(Block block, LootTable lootTable, BiConsumer<ResourceLocation, LootTable> consumer) {
        ResourceLocation registryName = block.getRegistryName();
        consumer.accept(new ResourceLocation(registryName.func_110624_b(), "blocks/" + registryName.func_110623_a()), lootTable);
    }

    private static LootTable addSlabBlockLootTable(Block block) {
        return LootTable.func_216119_b().func_216039_a(LootParameterSets.field_216267_h).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)block).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)2)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE)))).func_212840_b_(SurvivesExplosion.func_215968_b()))).func_216038_b();
    }

    private static LootTable addBasicBlockLootTable(IItemProvider itemProvider) {
        return LootTable.func_216119_b().func_216039_a(LootParameterSets.field_216267_h).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)itemProvider)).func_212840_b_(SurvivesExplosion.func_215968_b())).func_216038_b();
    }

    private static LootTable addDifferentDropLootTable(Block block, IItemProvider itemProvider) {
        return LootTable.func_216119_b().func_216039_a(LootParameterSets.field_216267_h).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_(MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(Enchantments.field_185306_r, MinMaxBounds.IntBound.func_211340_b((int)1)))))).func_216080_a(ItemLootEntry.func_216168_a((IItemProvider)itemProvider).func_212840_b_(SurvivesExplosion.func_215968_b())))).func_216038_b();
    }

    private static LootTable addFortuneBlockLootTable(Block block, IItemProvider itemProvider) {
        return LootTable.func_216119_b().func_216039_a(LootParameterSets.field_216267_h).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_(MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(Enchantments.field_185306_r, MinMaxBounds.IntBound.func_211340_b((int)1)))))).func_216080_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)itemProvider).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215869_a((Enchantment)Enchantments.field_185308_t)).func_212841_b_((ILootFunction.IBuilder)ExplosionDecay.func_215863_b())))).func_216038_b();
    }
}

