/*
 * Decompiled with CFR 0.152.
 */
package com.zathrox.explorercraft.core.proxy;

import com.zathrox.explorercraft.client.ClientForgeEventSubscriber;
import com.zathrox.explorercraft.client.render.BrushStoogeRenderer;
import com.zathrox.explorercraft.client.render.EnderGhastRenderer;
import com.zathrox.explorercraft.client.render.EnderreeperRenderer;
import com.zathrox.explorercraft.client.render.InfectedCreeperRenderer;
import com.zathrox.explorercraft.client.render.InfectedSkeletonRenderer;
import com.zathrox.explorercraft.client.render.InfectedZombieRenderer;
import com.zathrox.explorercraft.client.render.SkeletaurRenderer;
import com.zathrox.explorercraft.client.render.WizardRenderer;
import com.zathrox.explorercraft.core.Explorercraft;
import com.zathrox.explorercraft.core.config.Config;
import com.zathrox.explorercraft.core.proxy.CommonProxy;
import com.zathrox.explorercraft.core.registry.ExplorerBlocks;
import com.zathrox.explorercraft.core.registry.ExplorerEntities;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GrassColors;
import net.minecraft.world.ILightReader;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;

@OnlyIn(value=Dist.CLIENT)
public class ClientProxy
extends CommonProxy {
    public ClientProxy() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Config.client_config);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        Config.loadConfig(Config.client_config, FMLPaths.CONFIGDIR.get().resolve("explorercraft-client.toml").toString());
    }

    private void clientSetup(FMLClientSetupEvent event) {
        Explorercraft.LOGGER.debug("ClientProxy clientSetup method");
        this.registerRenderLayers();
        this.registerEntityRenderer();
        MinecraftForge.EVENT_BUS.register((Object)new ClientForgeEventSubscriber());
    }

    private void registerEntityRenderer() {
        RenderingRegistry.registerEntityRenderingHandler(ExplorerEntities.BRUSH_STOOGE, BrushStoogeRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ExplorerEntities.ENDERGHAST, EnderGhastRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ExplorerEntities.ENDERREEPER, EnderreeperRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ExplorerEntities.INFECTED_CREEPER, InfectedCreeperRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ExplorerEntities.INFECTED_SKELETON, InfectedSkeletonRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ExplorerEntities.INFECTED_ZOMBIE, InfectedZombieRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ExplorerEntities.WIZARD, WizardRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ExplorerEntities.SKELETAUR, SkeletaurRenderer::new);
    }

    private void registerRenderLayers() {
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.INFECTED_WILLOW_PLANKS, (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.LEEK_WILD, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.LEEKS, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.NOCTILUCAS, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.RICE_TOP, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.RICE_BASE, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.LOTUS_FLOWER, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.LOTUS_STEM, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.DAFFODIL, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.LUPINE, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.GREEN_MUSHROOM, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.PINK_MUSHROOM, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.TALL_CATTAIL, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.CATTAIL, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.SHORT_GRASS, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.WILLOW, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.POTTED_WILD_LEEK, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.POTTED_DAFFODIL, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.POTTED_LUPINE, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.POTTED_GREEN_MUSHROOM, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.POTTED_PINK_MUSHROOM, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.POTTED_ASH_SAPLING, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.POTTED_BAMBOO_SAPLING, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.POTTED_CHERRY_SAPLING, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.POTTED_MAPLE_SAPLING, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.POTTED_WILLOW_SAPLING, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.ASH_TRAPDOOR, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.BAMBOO_TRAPDOOR, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.CHERRY_TRAPDOOR, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.MAPLE_TRAPDOOR, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.WILLOW_TRAPDOOR, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.INFECTED_WILLOW_TRAPDOOR, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.ASH_DOOR, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.BAMBOO_DOOR, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.CHERRY_DOOR, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.MAPLE_DOOR, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.WILLOW_DOOR, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.INFECTED_WILLOW_DOOR, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.ASH_LEAVES, (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.BAMBOO_LEAVES, (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.CHERRY_LEAVES, (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.MAPLE_LEAVES, (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.WILLOW_LEAVES, (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.ASH_SAPLING, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.BAMBOO_SAPLING, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.CHERRY_SAPLING, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.MAPLE_SAPLING, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.WILLOW_SAPLING, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ExplorerBlocks.DISSOLVED_STONE, (RenderType)RenderType.func_228645_f_());
    }

    private void registerBlockColours(ColorHandlerEvent.Block event) {
        BlockColors blockColors = event.getBlockColors();
        blockColors.func_186722_a((state, world, pos, tint_index) -> world != null && pos != null ? BiomeColors.func_228358_a_((ILightReader)world, (BlockPos)pos) : GrassColors.func_77480_a((double)0.5, (double)1.0), new Block[]{ExplorerBlocks.LOTUS_FLOWER, ExplorerBlocks.SHORT_GRASS, ExplorerBlocks.WILLOW_LEAVES, ExplorerBlocks.WILLOW});
    }

    private void registerItemColors(ColorHandlerEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        itemColors.func_199877_a((stack, tintIndex) -> GrassColors.func_77480_a((double)0.5, (double)1.0), new IItemProvider[]{ExplorerBlocks.WILLOW_LEAVES, ExplorerBlocks.WILLOW});
        itemColors.func_199877_a((stack, tintIndex) -> GrassColors.func_77480_a((double)0.5, (double)1.0), new IItemProvider[]{ExplorerBlocks.SHORT_GRASS});
        itemColors.func_199877_a((stack, tintIndex) -> GrassColors.func_77480_a((double)0.5, (double)1.0), new IItemProvider[]{ExplorerBlocks.SHORT_GRASS});
    }

    @Override
    protected void postInit(InterModProcessEvent event) {
        super.postInit(event);
        this.registerBlockColours(new ColorHandlerEvent.Block(Minecraft.func_71410_x().func_184125_al()));
        this.registerItemColors(new ColorHandlerEvent.Item(Minecraft.func_71410_x().getItemColors(), Minecraft.func_71410_x().func_184125_al()));
    }
}

