/*
 * Decompiled with CFR 0.152.
 */
package com.zathrox.explorercraft.core.registry;

import com.zathrox.explorercraft.common.world.biome.BambooGroveBiome;
import com.zathrox.explorercraft.common.world.biome.CherryGroveBiome;
import com.zathrox.explorercraft.common.world.biome.ForestedMountainsBiome;
import com.zathrox.explorercraft.common.world.biome.FungalForestBiome;
import com.zathrox.explorercraft.common.world.biome.SnowdoniaBiome;
import com.zathrox.explorercraft.core.config.BiomeConfig;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public class ExplorerBiomes {
    public static final DeferredRegister<Biome> BIOMES = new DeferredRegister(ForgeRegistries.BIOMES, "explorercraft");
    public static final RegistryObject<Biome> FORESTED_MOUNTAIN = BIOMES.register("forested_mountain", () -> new ForestedMountainsBiome());
    public static final RegistryObject<Biome> BAMBOO_GROVE = BIOMES.register("bamboo_grove", () -> new BambooGroveBiome());
    public static final RegistryObject<Biome> SNOWDONIA = BIOMES.register("snowdonia", () -> new SnowdoniaBiome());
    public static final RegistryObject<Biome> FUNGAL_FOREST = BIOMES.register("fungal_forest", () -> new FungalForestBiome());
    public static final RegistryObject<Biome> CHERRY_GROVE = BIOMES.register("cherry_grove", () -> new CherryGroveBiome());

    public static void registerBiomes() {
        ExplorerBiomes.addBiomesToManager((Biome)BAMBOO_GROVE.get(), (Integer)BiomeConfig.bambooForestWeight.get(), false, (Boolean)BiomeConfig.spawnBambooForest.get(), BiomeManager.BiomeType.COOL, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.WET);
        ExplorerBiomes.addBiomesToManager((Biome)FORESTED_MOUNTAIN.get(), (Integer)BiomeConfig.forestedMountainWeight.get(), false, (Boolean)BiomeConfig.spawnForestedMountain.get(), BiomeManager.BiomeType.WARM, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.FOREST);
        ExplorerBiomes.addBiomesToManager((Biome)SNOWDONIA.get(), (Integer)BiomeConfig.snowdoniaWeight.get(), false, (Boolean)BiomeConfig.spawnSnowdonia.get(), BiomeManager.BiomeType.COOL, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.WET);
        ExplorerBiomes.addBiomesToManager((Biome)FUNGAL_FOREST.get(), (Integer)BiomeConfig.fungalForestWeight.get(), false, (Boolean)BiomeConfig.spawnFungalForest.get(), BiomeManager.BiomeType.WARM, BiomeDictionary.Type.WET, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.RARE);
        BiomeDictionary.addTypes((Biome)((Biome)CHERRY_GROVE.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.WET});
    }

    public static void addBiomesToManager(Biome biome, int weight, Boolean village, Boolean allowed, BiomeManager.BiomeType biomeType, BiomeDictionary.Type ... types) {
        if (allowed.booleanValue()) {
            BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])types);
            BiomeManager.addSpawnBiome((Biome)biome);
            BiomeManager.addBiome((BiomeManager.BiomeType)biomeType, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(biome, weight));
        }
    }
}

