/*
 * Decompiled with CFR 0.152.
 */
package com.zathrox.explorercraft.core.registry;

import com.google.common.collect.Lists;
import com.zathrox.explorercraft.common.entity.BrushStoogeEntity;
import com.zathrox.explorercraft.common.entity.EnderGhastEntity;
import com.zathrox.explorercraft.common.entity.EnderreeperEntity;
import com.zathrox.explorercraft.common.entity.InfectedCreeperEntity;
import com.zathrox.explorercraft.common.entity.InfectedSkeletonEntity;
import com.zathrox.explorercraft.common.entity.InfectedZombieEntity;
import com.zathrox.explorercraft.common.entity.SkeletaurEntity;
import com.zathrox.explorercraft.common.entity.WizardEntity;
import com.zathrox.explorercraft.core.config.EntityConfig;
import com.zathrox.explorercraft.core.registry.ExplorerItemGroups;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="explorercraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ExplorerEntities {
    private static List<EntityType> entities = Lists.newArrayList();
    private static List<Item> spawnEggs = Lists.newArrayList();
    public static final EntityType<BrushStoogeEntity> BRUSH_STOOGE = ExplorerEntities.createEntity(BrushStoogeEntity::new, EntityClassification.MONSTER, "brush_stooge", 0.4f, 0.7f, 10092400, 0xFFFFFF);
    public static final EntityType<EnderGhastEntity> ENDERGHAST = ExplorerEntities.createEntity(EnderGhastEntity::new, EntityClassification.MONSTER, "enderghast", 10.0f, 4.5f, 4801171, 6078066);
    public static final EntityType<EnderreeperEntity> ENDERREEPER = ExplorerEntities.createEntity(EnderreeperEntity::new, EntityClassification.MONSTER, "enderreeper", 0.6f, 1.99f, 3801171, 7078066);
    public static final EntityType<InfectedCreeperEntity> INFECTED_CREEPER = ExplorerEntities.createEntity(InfectedCreeperEntity::new, EntityClassification.MONSTER, "infected_creeper", 0.6f, 1.7f, 894731, 0xDC1C1C);
    public static final EntityType<InfectedSkeletonEntity> INFECTED_SKELETON = ExplorerEntities.createEntity(InfectedSkeletonEntity::new, EntityClassification.MONSTER, "infected_skeleton", 0.6f, 1.99f, 0xFFFFFF, 10092400);
    public static final EntityType<InfectedZombieEntity> INFECTED_ZOMBIE = ExplorerEntities.createEntity(InfectedZombieEntity::new, EntityClassification.MONSTER, "infected_zombie", 0.6f, 1.99f, 0x1000012, 10092500);
    public static final EntityType<SkeletaurEntity> SKELETAUR = ExplorerEntities.createEntity(SkeletaurEntity::new, EntityClassification.MONSTER, "skeletaur", 1.3964844f, 2.25f, 16433238, 4869992);
    public static final EntityType<WizardEntity> WIZARD = ExplorerEntities.createEntity(WizardEntity::new, EntityClassification.MONSTER, "wizard", 0.6f, 1.99f, 4869992, 16433238);

    private static <T extends Entity> EntityType<T> createEntity(EntityType.IFactory<T> factory, EntityClassification entityClassification, String name, float width, float height, int eggPrimary, int eggSecondary) {
        ResourceLocation location = new ResourceLocation("explorercraft", name);
        EntityType entity = EntityType.Builder.func_220322_a(factory, (EntityClassification)entityClassification).func_220321_a(width, height).setTrackingRange(64).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3).func_206830_a(location.toString());
        entity.setRegistryName(location);
        entities.add(entity);
        spawnEggs.add(ExplorerEntities.createSpawnEggForEntity(entity, eggPrimary, eggSecondary, ExplorerItemGroups.EXPLORERCRAFT));
        return entity;
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        for (EntityType entity : entities) {
            event.getRegistry().register((IForgeRegistryEntry)entity);
        }
        EntitySpawnPlacementRegistry.func_209343_a(BRUSH_STOOGE, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(ENDERGHAST, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EnderGhastEntity::spawnConditions);
        EntitySpawnPlacementRegistry.func_209343_a(ENDERREEPER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EnderreeperEntity::spawnEnderreeper);
        EntitySpawnPlacementRegistry.func_209343_a(INFECTED_CREEPER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(INFECTED_SKELETON, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(INFECTED_ZOMBIE, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(WIZARD, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
        EntitySpawnPlacementRegistry.func_209343_a(SKELETAUR, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
    }

    @SubscribeEvent
    public static void registerSpawnEggs(RegistryEvent.Register<Item> event) {
        for (Item spawnEgg : spawnEggs) {
            event.getRegistry().register((IForgeRegistryEntry)spawnEgg);
        }
    }

    public static Item createSpawnEggForEntity(EntityType entityType, int eggColor1, int eggColor2, ItemGroup itemGroup) {
        return (Item)new SpawnEggItem(entityType, eggColor1, eggColor2, new Item.Properties().func_200916_a(itemGroup)).setRegistryName(entityType.getRegistryName() + "_spawn_egg");
    }

    private static void registerEntityWorldSpawn(EntityType<?> type, int weight, int minCount, int maxCount, Biome ... biomes) {
        for (Biome biome : biomes) {
            if (biome == null) continue;
            biome.func_76747_a(type.func_220339_d()).add(new Biome.SpawnListEntry(type, weight, minCount, maxCount));
        }
    }

    public static void registerEntityWorldSpawns() {
        if (((Boolean)EntityConfig.enderreeper_enabled.get()).booleanValue()) {
            ExplorerEntities.registerEntityWorldSpawn(ENDERREEPER, 2, 1, 1, Biomes.field_76779_k);
            ExplorerEntities.registerEntityWorldSpawn(ENDERREEPER, 5, 1, 1, Biomes.field_201939_S, Biomes.field_201936_P, Biomes.field_201938_R, Biomes.field_201937_Q);
        }
        if (((Boolean)EntityConfig.enderreeper_nether_spawn_enabled.get()).booleanValue()) {
            ExplorerEntities.registerEntityWorldSpawn(ENDERREEPER, 2, 1, 2, Biomes.field_76778_j);
        }
        if (((Boolean)EntityConfig.enderghast_enabled.get()).booleanValue()) {
            ExplorerEntities.registerEntityWorldSpawn(ENDERGHAST, 10, 1, 4, Biomes.field_76779_k);
            ExplorerEntities.registerEntityWorldSpawn(ENDERGHAST, 15, 1, 4, Biomes.field_201939_S, Biomes.field_201936_P, Biomes.field_201938_R, Biomes.field_201937_Q);
        }
        if (((Boolean)EntityConfig.infected_skeleton_enabled.get()).booleanValue()) {
            ExplorerEntities.registerEntityWorldSpawn(INFECTED_SKELETON, 90, 4, 4, Biomes.field_150585_R, Biomes.field_185430_ab, Biomes.field_76782_w, Biomes.field_150574_L, Biomes.field_76792_x, Biomes.field_222370_aw, Biomes.field_222371_ax, Biomes.field_185447_Y, Biomes.field_185446_X);
        }
        if (((Boolean)EntityConfig.infected_skeleton_enabled.get()).booleanValue()) {
            ExplorerEntities.registerEntityWorldSpawn(INFECTED_ZOMBIE, 95, 4, 4, Biomes.field_150585_R, Biomes.field_185430_ab, Biomes.field_76782_w, Biomes.field_150574_L, Biomes.field_76792_x, Biomes.field_222370_aw, Biomes.field_222371_ax, Biomes.field_185447_Y, Biomes.field_185446_X);
        }
        if (((Boolean)EntityConfig.infected_creeper_enabled.get()).booleanValue()) {
            ExplorerEntities.registerEntityWorldSpawn(INFECTED_CREEPER, 80, 4, 4, Biomes.field_150585_R, Biomes.field_185430_ab, Biomes.field_76782_w, Biomes.field_150574_L, Biomes.field_76792_x, Biomes.field_222370_aw, Biomes.field_222371_ax, Biomes.field_185447_Y, Biomes.field_185446_X);
        }
        if (((Boolean)EntityConfig.brush_stooge_enabled.get()).booleanValue()) {
            ExplorerEntities.registerEntityWorldSpawn(BRUSH_STOOGE, 88, 2, 8, Biomes.field_150585_R, Biomes.field_185430_ab, Biomes.field_76782_w, Biomes.field_150574_L, Biomes.field_76792_x, Biomes.field_222370_aw, Biomes.field_222371_ax, Biomes.field_185447_Y, Biomes.field_185446_X);
        }
        if (((Boolean)EntityConfig.skeletaur_enabled.get()).booleanValue()) {
            ExplorerEntities.registerEntityWorldSpawn(SKELETAUR, 70, 1, 1, Biomes.field_76772_c, Biomes.field_185441_Q, Biomes.field_185444_T);
        }
    }
}

