/*
 * Decompiled with CFR 0.152.
 */
package com.zathrox.explorercraft.core.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.zathrox.explorercraft.common.entity.WizardEntity;
import com.zathrox.explorercraft.core.registry.ExplorerBlocks;
import com.zathrox.explorercraft.core.registry.ExplorerEnchantments;
import com.zathrox.explorercraft.core.registry.ExplorerItems;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.villager.IVillagerDataHolder;
import net.minecraft.entity.villager.IVillagerType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.DyeableArmorItem;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.SuspiciousStewItem;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionBrewing;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;

public class ExplorerTrades {
    public static final Int2ObjectMap<VillagerTrades.ITrade[]> WIZARD_TRADER = (Int2ObjectMap)Util.func_199748_a(() -> {
        VillagerTrades.ITrade[] baseOffers = new VillagerTrades.ITrade[]{new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_151071_bq, 16), 1, 3, 3, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_179556_br, 8), 1, 3, 3, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_226635_pU_, 32), 1, 3, 4, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Blocks.field_226905_ma_, 1), 2, 2, 8, 1.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_221596_x, 32), 1, 3, 4, 3.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_221774_cw, 32), 1, 3, 2, 3.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_221620_aV, 32), 1, 3, 2, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_221621_aW, 32), 1, 3, 2, 2.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_221622_aX, 32), 1, 3, 2, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_221623_aY, 32), 1, 3, 2, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_221624_aZ, 32), 1, 3, 2, 3.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_221678_ba, 32), 1, 3, 2, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_221680_bb, 32), 1, 3, 2, 3.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_221682_bc, 32), 1, 3, 2, 3.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_221684_bd, 32), 1, 3, 2, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_221684_bd, 32), 1, 3, 2, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_221686_be, 32), 1, 3, 2, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_221688_bf, 32), 1, 3, 2, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)ExplorerItems.RICE, 64), 1, 3, 2, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)ExplorerBlocks.CHERRY_SAPLING, 32), 1, 3, 4, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)ExplorerBlocks.MAPLE_SAPLING, 32), 1, 3, 4, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)ExplorerItems.LEEK, 64), 1, 3, 4, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)ExplorerBlocks.DAFFODIL, 32), 1, 3, 4, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)ExplorerBlocks.ASH_SAPLING, 32), 2, 2, 8, 2.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)ExplorerBlocks.WILLOW_SAPLING, 32), 1, 3, 4, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)ExplorerBlocks.LUPINE, 32), 1, 3, 4, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)ExplorerBlocks.GREEN_MUSHROOM, 16), 1, 3, 4, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)ExplorerBlocks.PINK_MUSHROOM, 16), 1, 3, 4, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)ExplorerBlocks.LOTUS_FLOWER, 8), 1, 3, 4, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)ExplorerBlocks.INFECTED_WILLOW_LOG, 32), 1, 3, 4, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_151073_bk, 16), 1, 3, 6, 2.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_221690_bg, 32), 2, 3, 8, 2.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_196183_dw), 8, 1, 15, 2.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_221695_cJ, 16), 1, 5, 2, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_221663_bT, 16), 1, 3, 2, 1.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_185162_cT, 32), 1, 2, 2, 1.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_151061_bv, 4), 1, 2, 4, 2.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_190930_cZ, 2), 4, 1, 12, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_222067_kP, 64), 1, 3, 2, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)ExplorerBlocks.NOCTILUCAS, 32), 1, 1, 8, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_221646_ak, 8), 3, 3, 8, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_205157_eZ, 16), 2, 2, 8, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_179563_cD, 32), 2, 3, 4, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_179562_cC, 32), 2, 3, 4, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_222068_kQ, 64), 1, 2, 4, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_196130_bo, 32), 1, 2, 4, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_221595_w, 32), 1, 3, 4, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_221597_y, 32), 1, 3, 4, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_190929_cY), 2, 1, 15, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)ExplorerItems.CHEESE, 22), 1, 3, 3, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)ExplorerItems.DRIED_FRUITS, 22), 1, 3, 3, 4.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_196188_eb), 2, 1, 12, 1.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_196189_ec), 2, 1, 12, 1.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_196156_dS), 2, 1, 12, 1.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_196160_dU), 2, 1, 12, 1.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_196158_dT), 2, 1, 12, 1.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_196162_dV), 2, 1, 12, 1.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_196164_dW), 2, 1, 12, 1.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_196166_dX), 2, 1, 12, 1.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_196168_dY), 2, 1, 12, 1.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_196170_dZ), 2, 1, 12, 1.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_196187_ea), 2, 1, 12, 1.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_196190_ed), 2, 1, 12, 1.0f)};
        VillagerTrades.ITrade[] rareOffers = new VillagerTrades.ITrade[]{new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_185160_cR), 64, 1, 25, 0.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_205158_fa, 1), 10, 1, 20, 0.0f), new ItemsForGemTrade(new ItemStack((IItemProvider)Items.field_151156_bN, 1), 64, 1, 25, 0.0f)};
        VillagerTrades.ITrade[] welshOffers = new VillagerTrades.ITrade[]{new Trade(new ItemStack((IItemProvider)Items.field_151121_aF, 22), new ItemStack((IItemProvider)Items.field_222078_li, 32), new ItemStack((IItemProvider)ExplorerItems.WELSHFLAG_BANNER_PATTERN), 1, 5, 5.0f, true), new Trade(new ItemStack((IItemProvider)ExplorerBlocks.DRAGON_HEART), new ItemStack((IItemProvider)Items.field_151042_j, 64), new ItemStack((IItemProvider)ExplorerItems.WELSH_SHIELD), 1, 5, 5.0f, true), new Trade(new ItemStack((IItemProvider)ExplorerBlocks.DRAGON_HEART), new ItemStack((IItemProvider)Blocks.field_196563_aS, 64), new ItemStack((IItemProvider)ExplorerItems.WIZARD_HAT), 1, 5, 5.0f, true), new Trade(new ItemStack((IItemProvider)ExplorerBlocks.DRAGON_HEART), new ItemStack((IItemProvider)ExplorerBlocks.ASH_LOG, 64), new ItemStack((IItemProvider)ExplorerItems.WIZARD_STAFF), 1, 5, 5.0f, true), new Trade(new ItemStack((IItemProvider)ExplorerBlocks.DRAGON_HEART), new ItemStack((IItemProvider)Items.field_196191_eg, 1), WizardEntity.createWelshFlagBanner(), 1, 5, 1.0f, false), new Trade(new ItemStack((IItemProvider)ExplorerBlocks.DRAGON_HEART), new ItemStack((IItemProvider)ExplorerBlocks.SLATE_CHISELED, 64), new ItemStack((IItemProvider)ExplorerBlocks.SLATE_WELSH, 64), 1, 5, 5.0f, true)};
        return ExplorerTrades.newTradeMap((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)0, (Object)baseOffers, (Object)1, (Object)rareOffers, (Object)2, (Object)welshOffers));
    });

    public static Int2ObjectMap<VillagerTrades.ITrade[]> newTradeMap(ImmutableMap<Integer, VillagerTrades.ITrade[]> map) {
        return new Int2ObjectOpenHashMap(map);
    }

    public static List<Item> getGems() {
        ArrayList<Item> gemList = new ArrayList<Item>();
        gemList.add(Items.field_151045_i);
        gemList.add(Items.field_151166_bC);
        gemList.add(ExplorerItems.AMETHYST);
        gemList.add(ExplorerItems.JADE);
        gemList.add(ExplorerItems.RUBY);
        gemList.add(Items.field_196128_bn);
        return gemList;
    }

    public static class ItemsForEmeraldsAndItemsTrade
    implements VillagerTrades.ITrade {
        private final ItemStack field_221200_a;
        private final int field_221201_b;
        private final int field_221202_c;
        private final ItemStack field_221203_d;
        private final int field_221204_e;
        private final int field_221205_f;
        private final int field_221206_g;
        private final float field_221207_h;

        public ItemsForEmeraldsAndItemsTrade(IItemProvider p_i50533_1_, int p_i50533_2_, Item p_i50533_3_, int p_i50533_4_, int p_i50533_5_, int p_i50533_6_) {
            this(p_i50533_1_, p_i50533_2_, 1, p_i50533_3_, p_i50533_4_, p_i50533_5_, p_i50533_6_);
        }

        public ItemsForEmeraldsAndItemsTrade(IItemProvider p_i50534_1_, int p_i50534_2_, int p_i50534_3_, Item p_i50534_4_, int p_i50534_5_, int p_i50534_6_, int p_i50534_7_) {
            this.field_221200_a = new ItemStack(p_i50534_1_);
            this.field_221201_b = p_i50534_2_;
            this.field_221202_c = p_i50534_3_;
            this.field_221203_d = new ItemStack((IItemProvider)p_i50534_4_);
            this.field_221204_e = p_i50534_5_;
            this.field_221205_f = p_i50534_6_;
            this.field_221206_g = p_i50534_7_;
            this.field_221207_h = 0.05f;
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity p_221182_1_, Random p_221182_2_) {
            return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, this.field_221202_c), new ItemStack((IItemProvider)this.field_221200_a.func_77973_b(), this.field_221201_b), new ItemStack((IItemProvider)this.field_221203_d.func_77973_b(), this.field_221204_e), this.field_221205_f, this.field_221206_g, this.field_221207_h);
        }
    }

    public static class ItemWithPotionForEmeraldsAndItemsTrade
    implements VillagerTrades.ITrade {
        private final ItemStack field_221219_a;
        private final int field_221220_b;
        private final int field_221221_c;
        private final int field_221222_d;
        private final int field_221223_e;
        private final Item field_221224_f;
        private final int field_221225_g;
        private final float field_221226_h;

        public ItemWithPotionForEmeraldsAndItemsTrade(Item p_i50526_1_, int p_i50526_2_, Item p_i50526_3_, int p_i50526_4_, int p_i50526_5_, int p_i50526_6_, int p_i50526_7_) {
            this.field_221219_a = new ItemStack((IItemProvider)p_i50526_3_);
            this.field_221221_c = p_i50526_5_;
            this.field_221222_d = p_i50526_6_;
            this.field_221223_e = p_i50526_7_;
            this.field_221224_f = p_i50526_1_;
            this.field_221225_g = p_i50526_2_;
            this.field_221220_b = p_i50526_4_;
            this.field_221226_h = 0.05f;
        }

        public MerchantOffer func_221182_a(Entity p_221182_1_, Random p_221182_2_) {
            ItemStack itemstack = new ItemStack((IItemProvider)Items.field_151166_bC, this.field_221221_c);
            List list = Registry.field_212621_j.func_201756_e().filter(p_221218_0_ -> !p_221218_0_.func_185170_a().isEmpty() && PotionBrewing.func_222124_a((Potion)p_221218_0_)).collect(Collectors.toList());
            Potion potion = (Potion)list.get(p_221182_2_.nextInt(list.size()));
            ItemStack itemstack1 = PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)this.field_221219_a.func_77973_b(), this.field_221220_b), (Potion)potion);
            return new MerchantOffer(itemstack, new ItemStack((IItemProvider)this.field_221224_f, this.field_221225_g), itemstack1, this.field_221222_d, this.field_221223_e, this.field_221226_h);
        }
    }

    public static class EnchantedItemForEmeraldsTrade
    implements VillagerTrades.ITrade {
        private final ItemStack field_221195_a;
        private final int field_221196_b;
        private final int field_221197_c;
        private final int field_221198_d;
        private final float field_221199_e;

        public EnchantedItemForEmeraldsTrade(Item p_i50535_1_, int p_i50535_2_, int p_i50535_3_, int p_i50535_4_) {
            this(p_i50535_1_, p_i50535_2_, p_i50535_3_, p_i50535_4_, 0.05f);
        }

        public EnchantedItemForEmeraldsTrade(Item p_i50536_1_, int p_i50536_2_, int p_i50536_3_, int p_i50536_4_, float p_i50536_5_) {
            this.field_221195_a = new ItemStack((IItemProvider)p_i50536_1_);
            this.field_221196_b = p_i50536_2_;
            this.field_221197_c = p_i50536_3_;
            this.field_221198_d = p_i50536_4_;
            this.field_221199_e = p_i50536_5_;
        }

        public MerchantOffer func_221182_a(Entity p_221182_1_, Random p_221182_2_) {
            int i = 5 + p_221182_2_.nextInt(15);
            ItemStack itemstack = EnchantmentHelper.func_77504_a((Random)p_221182_2_, (ItemStack)new ItemStack((IItemProvider)this.field_221195_a.func_77973_b()), (int)i, (boolean)false);
            int j = Math.min(this.field_221196_b + i, 64);
            ItemStack itemstack1 = new ItemStack((IItemProvider)Items.field_151166_bC, j);
            return new MerchantOffer(itemstack1, itemstack, this.field_221197_c, this.field_221198_d, this.field_221199_e);
        }
    }

    public static class EnchantedBookForEmeraldsTrade
    implements VillagerTrades.ITrade {
        private final int field_221194_a;

        public EnchantedBookForEmeraldsTrade(int p_i50537_1_) {
            this.field_221194_a = p_i50537_1_;
        }

        public MerchantOffer func_221182_a(Entity p_221182_1_, Random p_221182_2_) {
            Enchantment enchantment = (Enchantment)Registry.field_212628_q.func_186801_a(p_221182_2_);
            int i = MathHelper.func_76136_a((Random)p_221182_2_, (int)enchantment.func_77319_d(), (int)enchantment.func_77325_b());
            ItemStack itemstack = EnchantedBookItem.func_92111_a((EnchantmentData)new EnchantmentData(enchantment, i));
            int j = 2 + p_221182_2_.nextInt(5 + i * 10) + 3 * i;
            if (enchantment.func_185261_e()) {
                j *= 2;
            }
            if (j > 64) {
                j = 64;
            }
            return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, j), new ItemStack((IItemProvider)Items.field_151122_aG), itemstack, 12, this.field_221194_a, 0.2f);
        }
    }

    public static class EmeraldForVillageTypeItemTrade
    implements VillagerTrades.ITrade {
        private final Map<IVillagerType, Item> field_221190_a;
        private final int field_221191_b;
        private final int field_221192_c;
        private final int field_221193_d;

        public EmeraldForVillageTypeItemTrade(int p_i50538_1_, int p_i50538_2_, int p_i50538_3_, Map<IVillagerType, Item> p_i50538_4_) {
            Registry.field_218369_K.func_201756_e().filter(p_221188_1_ -> !p_i50538_4_.containsKey(p_221188_1_)).findAny().ifPresent(p_221189_0_ -> {
                throw new IllegalStateException("Missing trade for villager type: " + Registry.field_218369_K.func_177774_c(p_221189_0_));
            });
            this.field_221190_a = p_i50538_4_;
            this.field_221191_b = p_i50538_1_;
            this.field_221192_c = p_i50538_2_;
            this.field_221193_d = p_i50538_3_;
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity p_221182_1_, Random p_221182_2_) {
            if (p_221182_1_ instanceof IVillagerDataHolder) {
                ItemStack itemstack = new ItemStack((IItemProvider)this.field_221190_a.get(((IVillagerDataHolder)p_221182_1_).func_213700_eh().func_221129_a()), this.field_221191_b);
                return new MerchantOffer(itemstack, new ItemStack((IItemProvider)Items.field_151166_bC), this.field_221192_c, this.field_221193_d, 0.05f);
            }
            return null;
        }
    }

    public static class EmeraldForMapTrade
    implements VillagerTrades.ITrade {
        private final int count;
        private final String structureName;
        private final MapDecoration.Type mapDecorationType;
        private final int maxUses;
        private final int xpValue;

        public EmeraldForMapTrade(int countIn, String structureNameIn, MapDecoration.Type decoration, int maxUsesIn, int xpValueIn) {
            this.count = countIn;
            this.structureName = structureNameIn;
            this.mapDecorationType = decoration;
            this.maxUses = maxUsesIn;
            this.xpValue = xpValueIn;
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            if (!(trader.field_70170_p instanceof ServerWorld)) {
                return null;
            }
            ServerWorld serverworld = (ServerWorld)trader.field_70170_p;
            BlockPos blockpos = serverworld.func_211157_a(this.structureName, new BlockPos(trader), 100, true);
            if (blockpos != null) {
                ItemStack itemstack = FilledMapItem.func_195952_a((World)serverworld, (int)blockpos.func_177958_n(), (int)blockpos.func_177952_p(), (byte)2, (boolean)true, (boolean)true);
                FilledMapItem.func_226642_a_((ServerWorld)serverworld, (ItemStack)itemstack);
                MapData.func_191094_a((ItemStack)itemstack, (BlockPos)blockpos, (String)"+", (MapDecoration.Type)this.mapDecorationType);
                itemstack.func_200302_a((ITextComponent)new TranslationTextComponent("filled_map." + this.structureName.toLowerCase(Locale.ROOT), new Object[0]));
                return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, this.count), new ItemStack((IItemProvider)Items.field_151111_aL), itemstack, this.maxUses, this.xpValue, 0.2f);
            }
            System.out.println("NO STRUCTURE FOUND, SO NO MAP CREATED");
            return null;
        }
    }

    public static class DyedArmorForEmeraldsTrade
    implements VillagerTrades.ITrade {
        private final Item field_221233_a;
        private final int field_221234_b;
        private final int field_221235_c;
        private final int field_221236_d;

        public DyedArmorForEmeraldsTrade(Item p_i50540_1_, int p_i50540_2_) {
            this(p_i50540_1_, p_i50540_2_, 12, 1);
        }

        public DyedArmorForEmeraldsTrade(Item p_i50541_1_, int p_i50541_2_, int p_i50541_3_, int p_i50541_4_) {
            this.field_221233_a = p_i50541_1_;
            this.field_221234_b = p_i50541_2_;
            this.field_221235_c = p_i50541_3_;
            this.field_221236_d = p_i50541_4_;
        }

        public MerchantOffer func_221182_a(Entity p_221182_1_, Random p_221182_2_) {
            ItemStack itemstack = new ItemStack((IItemProvider)Items.field_151166_bC, this.field_221234_b);
            ItemStack itemstack1 = new ItemStack((IItemProvider)this.field_221233_a);
            if (this.field_221233_a instanceof DyeableArmorItem) {
                ArrayList list = Lists.newArrayList();
                list.add(DyedArmorForEmeraldsTrade.func_221232_a(p_221182_2_));
                if (p_221182_2_.nextFloat() > 0.7f) {
                    list.add(DyedArmorForEmeraldsTrade.func_221232_a(p_221182_2_));
                }
                if (p_221182_2_.nextFloat() > 0.8f) {
                    list.add(DyedArmorForEmeraldsTrade.func_221232_a(p_221182_2_));
                }
                itemstack1 = IDyeableArmorItem.func_219975_a((ItemStack)itemstack1, (List)list);
            }
            return new MerchantOffer(itemstack, itemstack1, this.field_221235_c, this.field_221236_d, 0.2f);
        }

        private static DyeItem func_221232_a(Random p_221232_0_) {
            return DyeItem.func_195961_a((DyeColor)DyeColor.func_196056_a((int)p_221232_0_.nextInt(16)));
        }
    }

    public static class SuspiciousStewForEmeraldTrade
    implements VillagerTrades.ITrade {
        final Effect field_221214_a;
        final int field_221215_b;
        final int field_221216_c;
        private final float field_221217_d;

        public SuspiciousStewForEmeraldTrade(Effect p_i50527_1_, int p_i50527_2_, int p_i50527_3_) {
            this.field_221214_a = p_i50527_1_;
            this.field_221215_b = p_i50527_2_;
            this.field_221216_c = p_i50527_3_;
            this.field_221217_d = 0.05f;
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity p_221182_1_, Random p_221182_2_) {
            ItemStack itemstack = new ItemStack((IItemProvider)Items.field_222115_pz, 1);
            SuspiciousStewItem.func_220037_a((ItemStack)itemstack, (Effect)this.field_221214_a, (int)this.field_221215_b);
            return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 1), itemstack, 12, this.field_221216_c, this.field_221217_d);
        }
    }

    public static class EmeraldForItemsTrade
    implements VillagerTrades.ITrade {
        private final Item itemstack;
        private final int stackSize;
        private final int recievedSize;
        private final int maxUses;
        private final float givenExp;

        public EmeraldForItemsTrade(IItemProvider item, int amount, int maxUses, int p_i50539_4_) {
            this.itemstack = item.func_199767_j();
            this.stackSize = amount;
            this.recievedSize = maxUses;
            this.maxUses = p_i50539_4_;
            this.givenExp = 0.05f;
        }

        public MerchantOffer func_221182_a(Entity player, Random random) {
            ItemStack itemstack = new ItemStack((IItemProvider)this.itemstack, this.stackSize);
            return new MerchantOffer(itemstack, new ItemStack((IItemProvider)Items.field_151166_bC), this.recievedSize, this.maxUses, this.givenExp);
        }
    }

    public static class ItemsForEmeraldsTrade
    implements VillagerTrades.ITrade {
        private final ItemStack itemstack;
        private final int stackSize;
        private final int recievedSize;
        private final int maxUses;
        private final int givenExp;
        private final float priceMultiplier;

        public ItemsForEmeraldsTrade(Block block, int stackSize, int recievedSize, int maxUses, int givenExp) {
            this(new ItemStack((IItemProvider)block), stackSize, recievedSize, maxUses, givenExp);
        }

        public ItemsForEmeraldsTrade(Item item, int stackSize, int recievedSize, int givenExp) {
            this(new ItemStack((IItemProvider)item), stackSize, recievedSize, 12, givenExp);
        }

        public ItemsForEmeraldsTrade(Item item, int stackSize, int recievedSize, int maxUses, int givenExp) {
            this(new ItemStack((IItemProvider)item), stackSize, recievedSize, maxUses, givenExp);
        }

        public ItemsForEmeraldsTrade(ItemStack stack, int stackSize, int recievedSize, int maxUses, int givenExp) {
            this(stack, stackSize, recievedSize, maxUses, givenExp, 0.05f);
        }

        public ItemsForEmeraldsTrade(ItemStack stack, int stackSize, int recievedSize, int maxUses, int givenExp, float priceMultiplier) {
            this.itemstack = stack;
            this.stackSize = stackSize;
            this.recievedSize = recievedSize;
            this.maxUses = maxUses;
            this.givenExp = givenExp;
            this.priceMultiplier = priceMultiplier;
        }

        public MerchantOffer func_221182_a(Entity p_221182_1_, Random p_221182_2_) {
            return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, this.stackSize), new ItemStack((IItemProvider)this.itemstack.func_77973_b(), this.recievedSize), this.maxUses, this.givenExp, this.priceMultiplier);
        }
    }

    public static class EnchantedBookForTabletTrade
    implements VillagerTrades.ITrade {
        private final ItemStack tablet;
        private final int value;

        public EnchantedBookForTabletTrade(ItemStack tablet, int value) {
            this.tablet = tablet;
            this.value = value;
        }

        public MerchantOffer func_221182_a(Entity entity, Random random) {
            Enchantment enchantment = null;
            enchantment = this.tablet.func_77973_b() == Items.field_151061_bv ? (Enchantment)ExplorerEnchantments.ENDERBANE.get() : (this.tablet.func_77973_b() == Items.field_151073_bk ? (Enchantment)ExplorerEnchantments.NETHERBANE.get() : (this.tablet.func_77973_b() == Items.field_221559_L ? (Enchantment)ExplorerEnchantments.ILLIAGERBANE.get() : (Enchantment)Registry.field_212628_q.func_186801_a(random)));
            int i = MathHelper.func_76136_a((Random)random, (int)enchantment.func_77319_d(), (int)enchantment.func_77325_b());
            ItemStack enchantedBook = EnchantedBookItem.func_92111_a((EnchantmentData)new EnchantmentData(enchantment, i));
            int j = 2 + random.nextInt(5 + i * 10) + 3 * i;
            if (enchantment.func_185261_e()) {
                j *= 2;
            }
            if (j > 64) {
                j = 64;
            }
            return new MerchantOffer(new ItemStack((IItemProvider)this.tablet.func_77973_b(), j), new ItemStack((IItemProvider)Items.field_151122_aG), enchantedBook, 12, this.value, 0.2f);
        }
    }

    static class ItemsForGemTrade
    implements VillagerTrades.ITrade {
        private final ItemStack firstBuyStack;
        private final ItemStack secondBuyStack;
        private final int sellingAmount;
        private final int maxUses;
        private final int experience;
        private final float priceMultiplier;
        private final boolean allowFluxation;

        public ItemsForGemTrade(ItemStack firstBuyStack, int sellingAmount, int maxUses, int experience, float priceMultiplier) {
            this.firstBuyStack = firstBuyStack;
            this.secondBuyStack = ItemStack.field_190927_a;
            this.sellingAmount = sellingAmount;
            this.maxUses = maxUses;
            this.experience = experience;
            this.priceMultiplier = priceMultiplier;
            this.allowFluxation = false;
        }

        public ItemsForGemTrade(ItemStack firstBuyStack, ItemStack secondBuyStack, int sellingAmount, int maxUses, int experience, float priceMultiplier, boolean allowFluxation) {
            this.firstBuyStack = firstBuyStack;
            this.secondBuyStack = secondBuyStack;
            this.sellingAmount = sellingAmount;
            this.maxUses = maxUses;
            this.experience = experience;
            this.priceMultiplier = priceMultiplier;
            this.allowFluxation = allowFluxation;
        }

        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            int gem = rand.nextInt(ExplorerTrades.getGems().size());
            System.out.println("Item: " + this.firstBuyStack.toString());
            if (!this.secondBuyStack.func_190926_b() && this.allowFluxation) {
                this.secondBuyStack.func_190920_e(MathHelper.func_76125_a((int)(Math.max(this.secondBuyStack.func_190916_E() - 4, 1) + rand.nextInt(8) + 1), (int)1, (int)64));
            }
            return new MerchantOffer(this.firstBuyStack, this.secondBuyStack, new ItemStack((IItemProvider)ExplorerTrades.getGems().get(gem), this.sellingAmount), this.maxUses, this.experience, this.priceMultiplier);
        }
    }

    static class Trade
    implements VillagerTrades.ITrade {
        private final ItemStack firstBuyStack;
        private final ItemStack secondBuyStack;
        private final ItemStack sellingStack;
        private final int maxUses;
        private final int experience;
        private final float priceMultiplier;
        private final boolean allowFluxation;

        public Trade(ItemStack firstBuyStack, ItemStack sellingStack, int maxUses, int experience, float priceMultiplier, boolean allowFluxation) {
            this.firstBuyStack = firstBuyStack;
            this.secondBuyStack = ItemStack.field_190927_a;
            this.sellingStack = sellingStack;
            this.maxUses = maxUses;
            this.experience = experience;
            this.priceMultiplier = priceMultiplier;
            this.allowFluxation = allowFluxation;
        }

        public Trade(ItemStack firstBuyStack, ItemStack secondBuyStack, ItemStack sellingStack, int maxUses, int experience, float priceMultiplier, boolean allowFluxation) {
            this.firstBuyStack = firstBuyStack;
            this.secondBuyStack = secondBuyStack;
            this.sellingStack = sellingStack;
            this.maxUses = maxUses;
            this.experience = experience;
            this.priceMultiplier = priceMultiplier;
            this.allowFluxation = allowFluxation;
        }

        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            if (!this.secondBuyStack.func_190926_b() && this.allowFluxation) {
                this.secondBuyStack.func_190920_e(MathHelper.func_76125_a((int)(Math.max(this.secondBuyStack.func_190916_E() - 4, 1) + rand.nextInt(8) + 1), (int)1, (int)64));
            }
            return new MerchantOffer(this.firstBuyStack, this.secondBuyStack, this.sellingStack, this.maxUses, this.experience, this.priceMultiplier);
        }
    }
}

