/*
 * Decompiled with CFR 0.152.
 */
package com.golems.content;

import com.golems.entity.GolemBase;
import com.golems.events.GolemBuildEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class BlockGolemHead
extends BlockDirectional {
    public BlockGolemHead() {
        super(Material.field_151578_c);
        this.func_149663_c("golem_head").func_149647_a(CreativeTabs.field_78026_f).func_149658_d("pumpkin_side").func_149672_a(field_149766_f);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return Blocks.field_150423_aK.func_149691_a(side, meta);
    }

    public void func_149689_a(World world_, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        int l = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 2.5)) & 3;
        world_.func_72921_c(x, y, z, l, 2);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        if (y > 2 && y < 256) {
            this.activate(world, x, y, z);
        }
    }

    public void activate(World world, int x, int y, int z) {
        Block blockBelow2;
        Block blockBelow1 = world.func_147439_a(x, y - 1, z);
        if (blockBelow1 == (blockBelow2 = world.func_147439_a(x, y - 2, z))) {
            boolean alignedX = world.func_147439_a(x - 1, y - 1, z) == blockBelow1 && world.func_147439_a(x + 1, y - 1, z) == blockBelow1;
            boolean alignedZ = world.func_147439_a(x, y - 1, z - 1) == blockBelow1 && world.func_147439_a(x, y - 1, z + 1) == blockBelow1;
            int meta = world.func_72805_g(x, y - 1, z);
            if (blockBelow1 == Blocks.field_150433_aE) {
                if (!world.field_72995_K) {
                    BlockGolemHead.removeGolemBlocks(world, x, y, z, false, false);
                    EntitySnowman entitysnowman = new EntitySnowman(world);
                    entitysnowman.func_70012_b((double)x + 0.5, (double)y - 1.95, (double)z + 0.5, 0.0f, 0.0f);
                    System.out.print("[Extra Golems] Building regular boring Snow Golem\n");
                    world.func_72838_d((Entity)entitysnowman);
                }
                this.spawnParticles(world, x, y - 2, z);
                return;
            }
            if (blockBelow1 == Blocks.field_150339_S && (alignedX || alignedZ)) {
                if (!world.field_72995_K) {
                    BlockGolemHead.removeGolemBlocks(world, x, y, z, alignedX);
                    EntityIronGolem golem = new EntityIronGolem(world);
                    System.out.print("[Extra Golems] Building regular boring Iron Golem\n");
                    golem.func_70849_f(true);
                    golem.func_70012_b((double)x + 0.5, (double)y - 1.95, (double)z + 0.5, 0.0f, 0.0f);
                    world.func_72838_d((Entity)golem);
                }
                this.spawnParticles(world, x, y - 2, z);
                return;
            }
            if (alignedX || alignedZ) {
                if (!world.field_72995_K) {
                    GolemBuildEvent event = new GolemBuildEvent(world, x, y, z);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    if (event.isGolemNull() || event.isGolemBanned()) {
                        return;
                    }
                    BlockGolemHead.removeGolemBlocks(world, x, y, z, alignedX);
                    GolemBase golem = event.getGolem();
                    System.out.print("[Extra Golems] Building golem of type " + golem.toString() + "\n");
                    golem.setPlayerCreated(true);
                    golem.func_70012_b((double)x + 0.5, (double)y - 1.95, (double)z + 0.5, 0.0f, 0.0f);
                    world.func_72838_d((Entity)golem);
                }
                this.spawnParticles(world, x, y - 2, z);
            }
        }
    }

    protected void spawnParticles(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            for (int l = 0; l < 80; ++l) {
                world.func_72869_a("snowballpoof", (double)x + world.field_73012_v.nextDouble(), (double)y + world.field_73012_v.nextDouble() * 3.9, (double)z + world.field_73012_v.nextDouble(), 0.0, 0.0, 0.0);
            }
        }
    }

    public static void removeGolemBlocks(World world, int headX, int headY, int headZ, boolean isXAligned) {
        BlockGolemHead.removeGolemBlocks(world, headX, headY, headZ, isXAligned, true);
    }

    public static void removeGolemBlocks(World world, int headX, int headY, int headZ, boolean isXAligned, boolean removeArms) {
        world.func_147468_f(headX, headY, headZ);
        world.func_147468_f(headX, headY - 1, headZ);
        world.func_147468_f(headX, headY - 2, headZ);
        if (removeArms) {
            if (isXAligned) {
                world.func_147468_f(headX - 1, headY - 1, headZ);
                world.func_147468_f(headX + 1, headY - 1, headZ);
            } else {
                world.func_147468_f(headX, headY - 1, headZ - 1);
                world.func_147468_f(headX, headY - 1, headZ + 1);
            }
        }
    }
}

