/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.main.Config;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;

public class EntityIceGolem
extends GolemBase {
    public EntityIceGolem(World world) {
        super(world, 6.0f, Blocks.field_150403_cj);
        this.func_70661_as().func_75491_a(false);
    }

    @Override
    protected void applyTexture() {
        this.setTextureType(EntityIceGolem.getGolemTexture("ice"));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70173_aa % 2 == 0) {
            int x = MathHelper.func_76128_c((double)this.field_70165_t);
            int y = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f - (double)this.field_70129_M));
            int z = MathHelper.func_76128_c((double)this.field_70161_v);
            int[][] blockBelowCoords = new int[][]{{x, y - 1, z}, {x + 1, y, z}, {x - 1, y, z}, {x, y, z + 1}, {x, y, z - 1}, {x + 1, y, z + 1}, {x - 1, y, z + 1}, {x + 1, y, z - 1}, {x - 1, y, z - 1}, {x + 2, y, z}, {x - 2, y, z}, {x, y, z - 2}, {x, y, z + 2}};
            if (this.field_70170_p.func_72807_a(x, z).func_150564_a(x, y, z) > 1.0f) {
                this.func_70097_a(DamageSource.field_76370_b, (float)Math.random() + 0.1f);
            }
            if (Config.ALLOW_ICE_SPECIAL) {
                for (int m = 0; m < 3; ++m) {
                    for (int[] coord : blockBelowCoords) {
                        x = coord[0];
                        y = coord[1] - m + 1;
                        z = coord[2];
                        Block b1 = this.field_70170_p.func_147439_a(x, y, z);
                        boolean shouldBeThinIce = false;
                        if (b1 == Blocks.field_150355_j && !(shouldBeThinIce = this.field_70146_Z.nextBoolean())) {
                            this.field_70170_p.func_147449_b(x, y, z, Blocks.field_150403_cj);
                        }
                        if (shouldBeThinIce || b1 == Blocks.field_150358_i) {
                            this.field_70170_p.func_147449_b(x, y, z, Blocks.field_150432_aD);
                            continue;
                        }
                        if (b1 == Blocks.field_150353_l) {
                            this.field_70170_p.func_147449_b(x, y, z, Blocks.field_150343_Z);
                            continue;
                        }
                        if (b1 != Blocks.field_150356_k) continue;
                        this.field_70170_p.func_147449_b(x, y, z, Blocks.field_150347_e);
                    }
                }
            }
        }
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (entity.func_70027_ad()) {
                this.func_70097_a(DamageSource.field_76377_j, 0.5f);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(18.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
    }

    @Override
    public void addGolemDrops(List<WeightedRandomChestContent> dropList, boolean recentlyHit, int lootingLevel) {
        int size = 1 + lootingLevel;
        GolemBase.addGuaranteedDropEntry(dropList, new ItemStack(Blocks.field_150432_aD, size > 4 ? 4 : size));
        if (lootingLevel > 0 || !Config.CAN_USE_REGULAR_ICE) {
            GolemBase.addDropEntry(dropList, Blocks.field_150403_cj, 0, 0, size > 2 ? 2 : size, 80);
        }
    }

    @Override
    protected String func_70673_aS() {
        return "random.break";
    }

    @Override
    public String getGolemSound() {
        return Block.field_149778_k.field_150501_a;
    }
}

