/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.main.Config;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;

public class EntityLapisGolem
extends GolemBase {
    private int[] badEffects;

    public EntityLapisGolem(World world) {
        super(world, 1.5f, Blocks.field_150368_y);
        this.badEffects = new int[]{Potion.field_76440_q.field_76415_H, Potion.field_76421_d.field_76415_H, Potion.field_76436_u.field_76415_H, Potion.field_76437_t.field_76415_H, Potion.field_82731_v.field_76415_H};
    }

    @Override
    protected void applyTexture() {
        this.setTextureType(EntityLapisGolem.getGolemTexture("lapis"));
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (Config.ALLOW_LAPIS_SPECIAL && entity instanceof EntityLivingBase) {
                int potionID = entity instanceof EntityZombie || entity instanceof EntitySkeleton ? Potion.field_76432_h.field_76415_H : this.badEffects[this.field_70146_Z.nextInt(this.badEffects.length)];
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(potionID, 20 * (3 + this.field_70146_Z.nextInt(10)), 1 + this.field_70146_Z.nextInt(3)));
            }
            return true;
        }
        return false;
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.28);
    }

    @Override
    public void addGolemDrops(List<WeightedRandomChestContent> dropList, boolean recentlyHit, int lootingLevel) {
        int size = 8 + this.field_70146_Z.nextInt(10) + lootingLevel * 4;
        GolemBase.addGuaranteedDropEntry(dropList, new ItemStack(Items.field_151100_aR, size, 4));
        GolemBase.addDropEntry(dropList, Items.field_151043_k, 0, 1, 1 + lootingLevel, 8 + lootingLevel * 30);
    }

    @Override
    public String getGolemSound() {
        return Block.field_149769_e.field_150501_a;
    }
}

