/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.ai.EntityAIDefendAgainstMonsters;
import com.golems.main.ContentInit;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.village.Village;
import net.minecraft.world.World;

public abstract class GolemBase
extends EntityCreature
implements IAnimals {
    private static final String KEY_PLAYER_CREATED = "isPlayerCreated";
    private int homeCheckTimer = 70;
    protected int attackTimer;
    protected float attackDamage;
    protected boolean isPlayerCreated;
    protected boolean canTakeFallDamage;
    protected boolean hasHome;
    protected ResourceLocation textureLoc;
    protected Block creativeReturn;
    Village villageObj;

    private GolemBase(World world) {
        super(world);
        this.func_70105_a(1.4f, 2.9f);
        this.setCanTakeFallDamage(false);
        this.field_70138_W = 0.5f;
        this.func_110171_b((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 4);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.9, 32.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 0.6, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.4));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIDefendAgainstMonsters(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 0, false, true, IMob.field_82192_a));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        if (this.getTextureType() == null) {
            this.setTextureType(GolemBase.getGolemTexture("clay"));
        }
    }

    public GolemBase(World world, float attack, Block pickBlock) {
        this(world);
        this.setCreativeReturn(pickBlock);
        this.attackDamage = attack;
        this.field_70728_aV = 4 + this.field_70146_Z.nextInt((int)this.attackDamage + 2);
    }

    public GolemBase(World world, float attack) {
        this(world, attack, ContentInit.golemHead);
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected void func_70629_bd() {
        if (--this.homeCheckTimer <= 0) {
            this.homeCheckTimer = 70 + this.field_70146_Z.nextInt(50);
            this.villageObj = this.field_70170_p.field_72982_D.func_75550_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v), 32);
            if (this.villageObj == null) {
                if (!this.hasHome) {
                    this.func_110171_b((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 32);
                    this.hasHome = true;
                }
            } else {
                ChunkCoordinates chunkcoordinates = this.villageObj.func_75577_a();
                this.func_110171_b(chunkcoordinates.field_71574_a, chunkcoordinates.field_71572_b, chunkcoordinates.field_71573_c, (int)((float)this.villageObj.func_75568_b() * 0.6f));
            }
        }
        super.func_70629_bd();
    }

    protected int func_70682_h(int i) {
        return i;
    }

    public boolean func_110164_bC() {
        return true;
    }

    protected void func_82167_n(Entity entity) {
        if (entity instanceof IMob && this.func_70681_au().nextInt(10) == 0) {
            this.func_70624_b((EntityLivingBase)entity);
        }
        super.func_82167_n(entity);
    }

    public void func_70636_d() {
        int k;
        int j;
        int i;
        Block block;
        super.func_70636_d();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 2.500000277905201E-7 && this.field_70146_Z.nextInt(5) == 0 && (block = this.field_70170_p.func_147439_a(i = MathHelper.func_76128_c((double)this.field_70165_t), j = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f - (double)this.field_70129_M)), k = MathHelper.func_76128_c((double)this.field_70161_v))).func_149688_o() != Material.field_151579_a) {
            this.field_70170_p.func_72869_a("blockcrack_" + Block.func_149682_b((Block)block) + "_" + this.field_70170_p.func_72805_g(i, j, k), this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.field_70121_D.field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0);
        }
    }

    public boolean func_70686_a(Class p_70686_1_) {
        return this.isPlayerCreated() && EntityPlayer.class.isAssignableFrom(p_70686_1_) ? false : super.func_70686_a(p_70686_1_);
    }

    public boolean func_70652_k(Entity entity) {
        float CRITICAL_CHANCE = 5.0f;
        float VARIANCE = 0.8f;
        float damage = this.getAttackDamage() + (float)(this.field_70146_Z.nextDouble() - 0.5) * 0.8f * this.getAttackDamage();
        if ((float)this.field_70146_Z.nextInt(100) < 5.0f) {
            damage *= 2.5f;
        }
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        boolean flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), damage);
        if (flag) {
            entity.field_70181_x += (double)0.4f;
        }
        this.func_85030_a(this.getThrowSound(), 1.0f, 1.0f);
        return flag;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte b) {
        if (b == 4) {
            this.attackTimer = 10;
            this.func_85030_a(this.getThrowSound(), 1.0f, 1.0f);
        } else {
            super.func_70103_a(b);
        }
    }

    public void func_70020_e(NBTTagCompound tag) {
        super.func_70020_e(tag);
        this.setPlayerCreated(tag.func_74767_n(KEY_PLAYER_CREATED));
    }

    public void func_70109_d(NBTTagCompound tag) {
        super.func_70109_d(tag);
        tag.func_74757_a(KEY_PLAYER_CREATED, this.isPlayerCreated());
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    protected void func_70069_a(float f) {
        if (this.getCanTakeFallDamage()) {
            super.func_70069_a(f);
        }
    }

    protected void func_145780_a(int x, int y, int z, Block block) {
        this.func_85030_a(this.getWalkingSound(), 1.0f, 1.0f);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public int func_70627_aG() {
        return 120;
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        return new ItemStack(this.getCreativeReturn(), 1);
    }

    protected void func_70628_a(boolean recentlyHit, int lootingLevel) {
        ArrayList<WeightedRandomChestContent> drops = new ArrayList<WeightedRandomChestContent>();
        GolemBase.addDropEntry(drops, (Block)(this.field_70146_Z.nextBoolean() ? Blocks.field_150327_N : Blocks.field_150328_O), 0, 1, 2, 65);
        GolemBase.addDropEntry(drops, Items.field_151137_ax, 0, 1, 1, 20 + lootingLevel * 10);
        this.addGolemDrops(drops, recentlyHit, lootingLevel);
        for (WeightedRandomChestContent w : drops) {
            int size;
            if (this.field_70146_Z.nextInt(100) >= w.field_76292_a) continue;
            int min = w.field_76295_d;
            int max = w.field_76296_e;
            ItemStack toDrop = w.field_76297_b;
            toDrop.field_77994_a = size = max > min ? min + this.field_70146_Z.nextInt(max - min) : min;
            this.func_70099_a(toDrop, 0.0f);
        }
    }

    public static boolean addGuaranteedDropEntry(List<WeightedRandomChestContent> list, ItemStack in) {
        return GolemBase.addDropEntry(list, in.func_77973_b(), in.func_77960_j(), in.field_77994_a, in.field_77994_a, 100);
    }

    public static boolean addDropEntry(List<WeightedRandomChestContent> list, Block in, int meta, int minAmount, int maxAmount, int percentChance) {
        return GolemBase.addDropEntry(list, Item.func_150898_a((Block)in), meta, minAmount, maxAmount, percentChance);
    }

    public static boolean addDropEntry(List<WeightedRandomChestContent> list, Item in, int meta, int minAmount, int maxAmount, int percentChance) {
        return list.add(new WeightedRandomChestContent(in, meta, minAmount, maxAmount, percentChance));
    }

    public static boolean removeDropEntry(List<WeightedRandomChestContent> list, Item in, int meta) {
        boolean flag = false;
        for (WeightedRandomChestContent w : list) {
            if (w.field_76297_b.func_77973_b() != in || meta != Short.MAX_VALUE && w.field_76297_b.func_77960_j() != meta) continue;
            list.remove(w);
            flag = true;
        }
        return flag;
    }

    public void setTextureType(ResourceLocation texturelocation) {
        this.textureLoc = texturelocation;
    }

    public ResourceLocation getTextureType() {
        return this.textureLoc;
    }

    public void setCreativeReturn(Block blockToReturn) {
        this.creativeReturn = blockToReturn;
    }

    public Block getCreativeReturn() {
        return this.creativeReturn;
    }

    protected void setAttackDamage(float f) {
        this.attackDamage = f;
    }

    public float getAttackDamage() {
        return this.attackDamage;
    }

    public Village getVillage() {
        return this.villageObj;
    }

    public void setPlayerCreated(boolean bool) {
        this.isPlayerCreated = bool;
    }

    public boolean isPlayerCreated() {
        return this.isPlayerCreated;
    }

    public void setCanTakeFallDamage(boolean toSet) {
        this.canTakeFallDamage = toSet;
    }

    public boolean getCanTakeFallDamage() {
        return this.canTakeFallDamage;
    }

    public boolean doesInteractChangeTexture() {
        return false;
    }

    public static ResourceLocation getGolemTexture(String texture) {
        return GolemBase.getGolemTexture("golems", texture);
    }

    public static ResourceLocation getGolemTexture(String MODID, String texture) {
        return new ResourceLocation(MODID + ":textures/entity/golem_" + texture + ".png");
    }

    protected String func_70639_aQ() {
        return this.getGolemSound();
    }

    protected String getWalkingSound() {
        return this.getGolemSound();
    }

    public String getThrowSound() {
        return this.getGolemSound();
    }

    protected String func_70621_aR() {
        return this.getGolemSound();
    }

    protected String func_70673_aS() {
        return this.getGolemSound();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.applyTexture();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.applyAttributes();
    }

    protected abstract void applyAttributes();

    protected abstract void applyTexture();

    public abstract void addGolemDrops(List<WeightedRandomChestContent> var1, boolean var2, int var3);

    public abstract String getGolemSound();
}

