/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.content.BlockLightProvider;
import com.golems.entity.GolemBase;
import com.golems.main.ContentInit;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public abstract class GolemLightProvider
extends GolemBase {
    private EnumLightLevel lightLevel;

    public GolemLightProvider(World world, float attack, Block pick, EnumLightLevel light) {
        super(world, attack, pick);
        this.lightLevel = light;
    }

    public GolemLightProvider(World world, float attack, EnumLightLevel light) {
        this(world, attack, ContentInit.golemHead, light);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float f) {
        return 0xF000F0;
    }

    public float func_70013_c(float f) {
        return 1.0f;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70173_aa % 2 == 0) {
            this.placeLightNearby();
        }
    }

    public boolean placeLightNearby() {
        int[][] validCoords;
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f));
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        for (int[] coord : validCoords = new int[][]{{x, z}, {x + 1, z}, {x - 1, z}, {x, z + 1}, {x, z - 1}, {x + 1, z + 1}, {x - 1, z + 1}, {x + 1, z - 1}, {x - 1, z - 1}}) {
            int xPos = coord[0];
            int zPos = coord[1];
            for (int k = 0; k < 3; ++k) {
                int yPos = y + k + 1;
                if (this.field_70170_p.func_147439_a(xPos, yPos, zPos) == Blocks.field_150350_a) {
                    return this.field_70170_p.func_147449_b(xPos, yPos, zPos, this.lightLevel.getLightBlock());
                }
                if (!(this.field_70170_p.func_147439_a(xPos, yPos, zPos) instanceof BlockLightProvider)) continue;
                return false;
            }
        }
        return false;
    }

    public static enum EnumLightLevel {
        HALF(0.5f),
        FULL(1.0f);

        private final float light;

        private EnumLightLevel(float brightness) {
            this.light = brightness;
        }

        public Block getLightBlock() {
            switch (this) {
                case FULL: {
                    return ContentInit.blockLightProviderFull;
                }
                case HALF: {
                    return ContentInit.blockLightProviderHalf;
                }
            }
            return Blocks.field_150350_a;
        }

        public float getBrightness() {
            return this.light;
        }
    }
}

