/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.main.ContentInit;
import net.minecraft.block.Block;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public abstract class GolemMultiTextured
extends GolemBase {
    private static final int DATA_WATCHER_TEXTURE = 13;
    private static final String NBT_TEXTURE = "GolemTextureData";
    protected final String[] textures;

    public GolemMultiTextured(World world, float attack, Block pick, String[] textureNames) {
        super(world, attack, pick);
        this.textures = textureNames;
        if (textureNames.length < 1 || textureNames.length > 128) {
            System.out.print("[Extra Golems]: Error - a subclass of GolemMultiTextured passed an invalid String array to the constructor. Acceptable lengths are between 1 and 128, inclusive\n");
        }
    }

    public GolemMultiTextured(World world, float attack, String[] textureNames) {
        this(world, attack, ContentInit.golemHead, textureNames);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70096_w().func_75682_a(13, (Object)new Byte(0));
    }

    @Override
    protected void applyTexture() {
        this.setTextureType(GolemMultiTextured.getGolemTexture("clay"));
    }

    public boolean func_70085_c(EntityPlayer player) {
        if (player.func_70694_bm() != null) {
            return super.func_70085_c(player);
        }
        this.setTextureNum((byte)((this.getTextureNum() + 1) % this.textures.length));
        this.setTextureType(this.getSpecialGolemTexture());
        this.func_70014_b(new NBTTagCompound());
        player.func_71038_i();
        return true;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70173_aa == 2) {
            this.setTextureType(this.getSpecialGolemTexture());
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74774_a(NBT_TEXTURE, (byte)this.getTextureNum());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setTextureNum(nbt.func_74771_c(NBT_TEXTURE));
        this.setTextureType(this.getSpecialGolemTexture());
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        this.setTextureNum((byte)this.field_70146_Z.nextInt(this.textures.length));
        this.setTextureType(this.getSpecialGolemTexture());
        return super.func_110161_a(data);
    }

    @Override
    public boolean doesInteractChangeTexture() {
        return true;
    }

    public ResourceLocation getSpecialGolemTexture() {
        return this.getSpecialGolemTexture(this.getTextureStringFromArray());
    }

    public ResourceLocation getSpecialGolemTexture(String s) {
        return GolemBase.getGolemTexture(this.getModId(), this.getTexturePrefix() + "_" + s);
    }

    public void setTextureNum(byte toSet) {
        this.field_70180_af.func_75692_b(13, (Object)new Byte(toSet));
    }

    public int getTextureNum() {
        return this.field_70180_af.func_75683_a(13);
    }

    public String getTextureStringFromArray() {
        return this.textures[this.getTextureNum()];
    }

    public abstract String getModId();

    public abstract String getTexturePrefix();
}

