/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.init.Config;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;

public class EntityIceGolem
extends GolemBase {
    public EntityIceGolem(World world) {
        super(world, 6.0f, Blocks.field_150403_cj);
        ((PathNavigateGround)this.func_70661_as()).func_179690_a(false);
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityIceGolem.makeGolemTexture("ice");
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70173_aa % 2 == 0) {
            int z;
            int y;
            int x = MathHelper.func_76128_c((double)this.field_70165_t);
            BlockPos below = new BlockPos(x, y = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)), z = MathHelper.func_76128_c((double)this.field_70161_v));
            if (this.field_70170_p.func_180494_b(below).func_180626_a(below) > 1.0f) {
                this.func_70097_a(DamageSource.field_76370_b, 1.0f);
            }
            if (Config.ALLOW_ICE_SPECIAL) {
                this.freezeBlocks(this.field_70170_p, x, y, z);
            }
        }
    }

    public boolean freezeBlocks(World world, int x, int y, int z) {
        int ICE_RANGE = 3;
        BlockPos below = new BlockPos(x, y, z);
        boolean flag = false;
        for (int i = -3; i <= 3; ++i) {
            for (int j = 1; j >= -1; --j) {
                for (int k = -3; k <= 3; ++k) {
                    if (!(below.func_177954_c((double)(x + i), (double)y, (double)(z + k)) <= 9.0)) continue;
                    BlockPos pos = new BlockPos(x + i, y + j, z + k);
                    Block b1 = this.field_70170_p.func_180495_p(pos).func_177230_c();
                    Block toBecome = null;
                    boolean shouldBeThinIce = false;
                    if (b1 == Blocks.field_150355_j) {
                        toBecome = Blocks.field_150403_cj;
                    }
                    if (b1 == Blocks.field_150358_i || toBecome == Blocks.field_150403_cj && this.field_70146_Z.nextBoolean()) {
                        toBecome = Blocks.field_150432_aD;
                    } else if (b1 == Blocks.field_150353_l) {
                        toBecome = Blocks.field_150343_Z;
                    } else if (b1 == Blocks.field_150356_k) {
                        toBecome = Blocks.field_150347_e;
                    }
                    flag = toBecome != null ? this.field_70170_p.func_180501_a(pos, toBecome.func_176223_P(), 3) : false;
                }
            }
        }
        return flag;
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (entity.func_70027_ad()) {
                this.func_70097_a(DamageSource.field_76377_j, 0.5f);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(18.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
    }

    @Override
    public void addGolemDrops(List<WeightedRandomChestContent> dropList, boolean recentlyHit, int lootingLevel) {
        int size = 1 + lootingLevel;
        this.addGuaranteedDropEntry(dropList, new ItemStack(Blocks.field_150432_aD, size > 4 ? 4 : size));
        if (lootingLevel > 0 || !Config.CAN_USE_REGULAR_ICE) {
            this.addDropEntry(dropList, Blocks.field_150403_cj, 0, 0, size > 2 ? 2 : size, 80);
        }
    }

    @Override
    protected String func_70673_aS() {
        return "random.break";
    }

    @Override
    public String getGolemSound() {
        return Block.field_149778_k.func_150498_e();
    }
}

