/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.entity.ai.EntityAIPlaceBlocksRandomly;
import com.golems.init.Config;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;

public class EntityMelonGolem
extends GolemBase {
    private IBlockState[] flowers;
    private final Block[] soils = new Block[]{Blocks.field_150346_d, Blocks.field_150349_c, Blocks.field_150391_bh};

    public EntityMelonGolem(World world) {
        super(world, 1.5f, Blocks.field_150440_ba);
        ArrayList<IBlockState> lFlowers = new ArrayList<IBlockState>();
        for (BlockFlower.EnumFlowerType e : BlockFlower.EnumFlowerType.values()) {
            lFlowers.add(e.func_176964_a().func_180346_a().func_176203_a(e.func_176968_b()));
        }
        for (int j = 0; j < 3; ++j) {
            lFlowers.add(Blocks.field_150329_H.func_176203_a(j));
        }
        this.flowers = lFlowers.toArray(new IBlockState[lFlowers.size()]);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPlaceBlocksRandomly(this, Config.TWEAK_MELON, this.flowers, this.soils, Config.ALLOW_MELON_SPECIAL));
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityMelonGolem.makeGolemTexture("melon");
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(18.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
    }

    @Override
    public void addGolemDrops(List<WeightedRandomChestContent> dropList, boolean recentlyHit, int lootingLevel) {
        int size = 6 + this.field_70146_Z.nextInt(6 + lootingLevel * 4);
        this.addGuaranteedDropEntry(dropList, new ItemStack(Items.field_151127_ba, size));
        this.addDropEntry(dropList, Items.field_151081_bc, 0, 1, 6 + lootingLevel, 20 + lootingLevel * 10);
        this.addDropEntry(dropList, Items.field_151060_bw, 0, 1, 1, 2 + lootingLevel * 10);
    }

    @Override
    public String getGolemSound() {
        return Block.field_149779_h.func_150498_e();
    }
}

