/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.init.Config;
import com.golems.init.GolemItems;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;

public class EntityRedstoneGolem
extends GolemBase {
    public EntityRedstoneGolem(World world) {
        this(world, 2.0f, Blocks.field_150451_bX);
    }

    public EntityRedstoneGolem(World world, float attack, ItemStack pick) {
        super(world, attack, pick);
    }

    public EntityRedstoneGolem(World world, float attack, Block pick) {
        this(world, attack, new ItemStack(pick, 1));
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityRedstoneGolem.makeGolemTexture("redstone");
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (Config.ALLOW_REDSTONE_SPECIAL && this.field_70173_aa % 2 == 0) {
            this.placePowerNearby(Config.TWEAK_REDSTONE);
        }
    }

    protected boolean placePowerNearby(int power) {
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f));
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        for (int k = -1; k < 3; ++k) {
            BlockPos at = new BlockPos(x, y + k, z);
            if (!this.field_70170_p.func_175623_d(at)) continue;
            return this.field_70170_p.func_175656_a(at, GolemItems.blockPowerSource.func_176203_a(power));
        }
        return false;
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(18.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
    }

    @Override
    public void addGolemDrops(List<WeightedRandomChestContent> dropList, boolean recentlyHit, int lootingLevel) {
        int size = 8 + this.field_70146_Z.nextInt(14 + lootingLevel * 4);
        this.addGuaranteedDropEntry(dropList, new ItemStack(Items.field_151137_ax, size > 36 ? 36 : size));
    }

    @Override
    public String getGolemSound() {
        return Block.field_149769_e.func_150498_e();
    }
}

