/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.init.Config;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;

public class EntitySlimeGolem
extends GolemBase {
    public EntitySlimeGolem(World world) {
        super(world, 2.5f, Blocks.field_180399_cE);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        ((PathNavigateGround)this.func_70661_as()).func_179690_a(false);
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntitySlimeGolem.makeGolemTexture("slime");
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (Config.ALLOW_SLIME_SPECIAL) {
                this.knockbackTarget(entity, Config.TWEAK_SLIME);
            }
            return true;
        }
        return false;
    }

    protected void func_70665_d(DamageSource source, float amount) {
        if (!this.func_180431_b(source)) {
            super.func_70665_d(source, amount);
            if (source.func_76346_g() != null && Config.ALLOW_SLIME_SPECIAL) {
                this.knockbackTarget(source.func_76346_g(), Config.TWEAK_SLIME * 3.0f / 5.0f);
            }
        }
    }

    private void knockbackTarget(Entity entity, double KNOCKBACK_FACTOR) {
        double dX = (entity.field_70165_t - this.field_70165_t) * KNOCKBACK_FACTOR;
        double dZ = (entity.field_70161_v - this.field_70161_v) * KNOCKBACK_FACTOR;
        entity.func_70024_g(dX, KNOCKBACK_FACTOR / 4.0, dZ);
        entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 0.1f);
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(85.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.29);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.5);
    }

    @Override
    public void addGolemDrops(List<WeightedRandomChestContent> dropList, boolean recentlyHit, int lootingLevel) {
        int size = 11 + this.field_70146_Z.nextInt(16 + lootingLevel * 4);
        this.addGuaranteedDropEntry(dropList, new ItemStack(Items.field_151123_aH, size));
    }

    @Override
    public String getGolemSound() {
        return Block.field_149779_h.func_150498_e();
    }
}

