/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemMultiTextured;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;

public class EntityWoodenGolem
extends GolemMultiTextured {
    private static final String[] woodTypes = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "big_oak"};

    public EntityWoodenGolem(World world) {
        super(world, 3.0f, Blocks.field_150364_r, woodTypes);
        this.setCanSwim(true);
    }

    @Override
    public String getTexturePrefix() {
        return "wooden";
    }

    @Override
    public String getModId() {
        return "golems";
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
    }

    @Override
    public void addGolemDrops(List<WeightedRandomChestContent> dropList, boolean recentlyHit, int lootingLevel) {
        int size = 6 + this.field_70146_Z.nextInt(4 + lootingLevel * 4);
        int meta = this.field_70146_Z.nextBoolean() ? this.getTextureNum() : 0;
        this.addGuaranteedDropEntry(dropList, new ItemStack(Item.func_150898_a((Block)Blocks.field_150344_f), size > 16 ? 16 : size, meta));
        this.addDropEntry(dropList, Items.field_151055_y, 0, 1, 4, 10 + lootingLevel * 4);
        this.addDropEntry(dropList, Blocks.field_150345_g, 0, 1, 2, 4 + lootingLevel * 4);
    }

    @Override
    public String getGolemSound() {
        return Block.field_149766_f.func_150498_e();
    }
}

