/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemMultiTextured;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;

public class EntityWoolGolem
extends GolemMultiTextured {
    private static final String[] coloredWoolTypes = new String[]{"black", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "silver", "cyan", "purple", "blue", "brown", "green", "red", "white"};

    public EntityWoolGolem(World world) {
        super(world, 1.0f, Blocks.field_150325_L, coloredWoolTypes);
        this.setCanSwim(true);
    }

    @Override
    public String getTexturePrefix() {
        return "wool";
    }

    @Override
    public String getModId() {
        return "golems";
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
    }

    @Override
    public void addGolemDrops(List<WeightedRandomChestContent> dropList, boolean recentlyHit, int lootingLevel) {
        int size = 1 + this.field_70146_Z.nextInt(3) + lootingLevel;
        int meta = this.getTextureNum() % coloredWoolTypes.length;
        this.addGuaranteedDropEntry(dropList, new ItemStack(Blocks.field_150325_L, 1 + this.field_70146_Z.nextInt(2), 0));
        this.addDropEntry(dropList, Blocks.field_150325_L, meta, 1, 2, 60 + lootingLevel * 10);
        this.addDropEntry(dropList, Items.field_151007_F, 0, 1, 2, 5 + lootingLevel * 10);
    }

    @Override
    public void setTextureNum(byte toSet) {
        toSet = (byte)(toSet % (byte)(coloredWoolTypes.length - 1));
        super.setTextureNum(toSet);
    }

    @Override
    public String getGolemSound() {
        return Block.field_149775_l.func_150498_e();
    }
}

