/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.init.GolemItems;
import net.minecraft.block.Block;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public abstract class GolemMultiTextured
extends GolemBase {
    private static final int DATA_WATCHER_TEXTURE = 13;
    private static final String NBT_TEXTURE = "GolemTextureData";
    private final String[] textures;

    public GolemMultiTextured(World world, float attack, Block pick, String[] textureNames) {
        super(world, attack, pick);
        this.textures = textureNames;
    }

    public GolemMultiTextured(World world, float attack, String[] textureNames) {
        this(world, attack, GolemItems.golemHead, textureNames);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70096_w().func_75682_a(13, (Object)new Byte(0));
    }

    @Override
    protected ResourceLocation applyTexture() {
        return GolemMultiTextured.makeGolemTexture("clay");
    }

    public boolean func_70085_c(EntityPlayer player) {
        if (player.func_70694_bm() != null) {
            return super.func_70085_c(player);
        }
        this.setTextureNum((byte)((this.getTextureNum() + 1) % this.textures.length));
        this.setTextureType(this.getSpecialGolemTexture());
        this.func_70014_b(new NBTTagCompound());
        player.func_71038_i();
        return true;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70173_aa == 2) {
            this.setTextureType(this.getSpecialGolemTexture(this.getTextureStringFromArray()));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74774_a(NBT_TEXTURE, (byte)this.getTextureNum());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setTextureNum(nbt.func_74771_c(NBT_TEXTURE));
        this.setTextureType(this.getSpecialGolemTexture(this.getTextureStringFromArray()));
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData data) {
        this.setTextureNum((byte)this.field_70146_Z.nextInt(this.textures.length));
        this.setTextureType(this.getSpecialGolemTexture(this.getTextureStringFromArray()));
        return super.func_180482_a(difficulty, data);
    }

    public ResourceLocation getSpecialGolemTexture() {
        return this.getSpecialGolemTexture(this.getTextureStringFromArray());
    }

    public ResourceLocation getSpecialGolemTexture(String s) {
        return GolemBase.makeGolemTexture(this.getModId(), this.getTexturePrefix() + "_" + s);
    }

    public void setTextureNum(byte toSet) {
        this.field_70180_af.func_75692_b(13, (Object)new Byte(toSet));
    }

    public int getTextureNum() {
        return this.field_70180_af.func_75683_a(13);
    }

    public String getTextureStringFromArray() {
        return this.textures[this.getTextureNum()];
    }

    public abstract String getTexturePrefix();

    public abstract String getModId();

    public String[] getTextureStringArray() {
        return this.textures;
    }
}

