/*
 * Decompiled with CFR 0.152.
 */
package me.marnic.extrabows.api.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import me.marnic.extrabows.api.upgrade.ArrowModifierUpgrade;
import me.marnic.extrabows.api.upgrade.ArrowMultiplierUpgrade;
import me.marnic.extrabows.api.upgrade.BasicUpgrade;
import me.marnic.extrabows.common.items.BasicBow;
import me.marnic.extrabows.common.packet.ExtraBowsPacketHandler;
import me.marnic.extrabows.common.packet.PacketSendDestroyMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.ItemStackHandler;

public class UpgradeList {
    private ArrowMultiplierUpgrade arrowMultiplier;
    private ArrayList<ArrowModifierUpgrade> arrowModifiers;
    private HashMap<BasicUpgrade, Object> dataMap;
    private ItemStackHandler handler;
    private BasicBow basicBow;

    public UpgradeList(ArrowMultiplierUpgrade arrowMultiplier, ArrayList<ArrowModifierUpgrade> arrowModifiers, ItemStackHandler handler, BasicBow bow) {
        this.arrowMultiplier = arrowMultiplier;
        this.arrowModifiers = arrowModifiers;
        this.dataMap = new HashMap();
        this.handler = handler;
        this.basicBow = bow;
    }

    public ArrayList<ArrowModifierUpgrade> getArrowModifiers() {
        return this.arrowModifiers;
    }

    public ArrowMultiplierUpgrade getArrowMultiplier() {
        return this.arrowMultiplier;
    }

    public boolean hasMul() {
        return this.arrowMultiplier != null;
    }

    public boolean hasMods() {
        return !this.arrowModifiers.isEmpty();
    }

    public BasicBow getBasicBow() {
        return this.basicBow;
    }

    public boolean contains(BasicUpgrade upgrade) {
        return (this.arrowMultiplier != null && this.arrowMultiplier.equals(upgrade)) | this.arrowModifiers.contains(upgrade);
    }

    public void handleModifierHittingEvent(ArrowModifierUpgrade.EventType eventType, BlockPos pos, Entity entity, World world, EntityPlayer player, EntityArrow arrow) {
        if (this.hasMods()) {
            switch (eventType) {
                case ENTITY_HIT: {
                    if (entity != null) {
                        for (ArrowModifierUpgrade up : this.getArrowModifiers()) {
                            up.handleEntityHit(entity, world, player, arrow, this);
                        }
                    }
                }
                case BLOCK_HIT: {
                    if (pos != null) {
                        for (ArrowModifierUpgrade up : this.getArrowModifiers()) {
                            up.handleBlockHit(pos, world, player, arrow, this);
                        }
                    }
                }
                case WATER_HIT: {
                    if (pos == null) break;
                    for (ArrowModifierUpgrade up : this.getArrowModifiers()) {
                        up.handleWaterHit(pos, world, player, arrow, this);
                    }
                    break;
                }
            }
        }
    }

    public void handleOnUpdatedEvent(EntityArrow arrow, World world) {
        if (this.hasMods()) {
            for (ArrowModifierUpgrade upgrade : this.getArrowModifiers()) {
                upgrade.handleFlyingEvent(arrow, world, this);
            }
        }
    }

    public void handleInsertedEvent(ItemStack bow) {
        for (ArrowModifierUpgrade modifierUpgrade : this.getArrowModifiers()) {
            modifierUpgrade.handleUpgradeInsert(bow);
        }
    }

    public void handleModifierEvent(ArrowModifierUpgrade.EventType eventType, EntityArrow arrow, EntityPlayer player, ItemStack bowStack) {
        if (this.hasMods()) {
            switch (eventType) {
                case ARROW_CREATE: {
                    for (ArrowModifierUpgrade up : this.getArrowModifiers()) {
                        up.handleArrowCreate(arrow, player, this);
                    }
                }
                case SET_EFFECT: {
                    for (ArrowModifierUpgrade up : this.getArrowModifiers()) {
                        up.handleSetEffect(arrow, this);
                    }
                }
                case ENTITY_INIT: {
                    for (ArrowModifierUpgrade up : this.getArrowModifiers()) {
                        up.handleEntityInit(arrow, this, player);
                    }
                    break;
                }
            }
        }
    }

    public void applyDamage(EntityPlayer player) {
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            ItemStack stack = this.handler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            ItemStack old = stack.func_77946_l();
            stack.func_77972_a(1, (EntityLivingBase)player);
            if (!stack.func_190926_b()) continue;
            ExtraBowsPacketHandler.INSTANCE.sendTo((IMessage)new PacketSendDestroyMessage().setText(old.func_82833_r()), (EntityPlayerMP)player);
        }
    }

    public HashMap<BasicUpgrade, Object> getDataMap() {
        return this.dataMap;
    }

    public void dropItems(EntityPlayer player) {
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            player.func_71019_a(this.handler.getStackInSlot(i), false);
        }
    }
}

