/*
 * Decompiled with CFR 0.152.
 */
package me.marnic.extrabows.api.upgrade;

import java.util.List;
import me.marnic.extrabows.api.energy.ExtraBowsEnergy;
import me.marnic.extrabows.api.upgrade.ArrowModifierUpgrade;
import me.marnic.extrabows.api.upgrade.ArrowMultiplierUpgrade;
import me.marnic.extrabows.api.upgrade.UpgradeList;
import me.marnic.extrabows.api.util.ArrowUtil;
import me.marnic.extrabows.api.util.RandomUtil;
import me.marnic.extrabows.api.util.TimeCommand;
import me.marnic.extrabows.api.util.TimerUtil;
import me.marnic.extrabows.api.util.UpgradeUtil;
import me.marnic.extrabows.common.config.ExtraBowsConfig;
import me.marnic.extrabows.common.items.BasicBow;
import me.marnic.extrabows.common.upgrades.BridgeUpgrade;
import me.marnic.extrabows.common.upgrades.ElectricUpgrade;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;

public class Upgrades {
    public static ArrowMultiplierUpgrade DOUBLE_UPGRADE;
    public static ArrowMultiplierUpgrade TRIPLE_UPGRADE;
    public static ArrowModifierUpgrade LIGHTNING_UPGRADE;
    public static ArrowModifierUpgrade FIRE_UPGRADE;
    public static ArrowModifierUpgrade ENDER_UPGRADE;
    public static ArrowModifierUpgrade FREEZE_UPGRADE;
    public static ArrowModifierUpgrade EXPLOSIVE_UPGRADE;
    public static ArrowModifierUpgrade WATER_UPGRADE;
    public static ArrowModifierUpgrade BRIDGE_UPGRADE;
    public static ArrowModifierUpgrade PUSH_UPGRADE;
    public static ArrowModifierUpgrade FLYING_UPGRADE;
    public static ArrowModifierUpgrade METEOR_UPGRADE;
    public static ArrowModifierUpgrade HEAL_FROM_DAMAGE;
    public static ArrowModifierUpgrade ARROW_COST;
    public static ArrowModifierUpgrade ELECTRIC_UPGRADE;

    public static void init() {
        DOUBLE_UPGRADE = new ArrowMultiplierUpgrade("double_upgrade", ExtraBowsConfig.DURABILITY_DOUBLE_UPGRADE){

            @Override
            public void handleAction(BasicBow basicBow, World worldIn, ItemStack bow, EntityPlayer entityplayer, float f, ItemStack arrow, boolean flag1, UpgradeList list, boolean isLoaded) {
                if (arrow.func_190916_E() >= 2 || flag1 || isLoaded) {
                    EntityArrow entityarrow2 = ArrowUtil.createArrowComplete(worldIn, bow, arrow, entityplayer, basicBow, f, flag1, 0.0f, 2.5f, list, isLoaded);
                    worldIn.func_72838_d((Entity)entityarrow2);
                    EntityArrow entityarrow1 = ArrowUtil.createArrowComplete(worldIn, bow, arrow, entityplayer, basicBow, f, flag1, 0.0f, -2.5f, list, isLoaded);
                    worldIn.func_72838_d((Entity)entityarrow1);
                } else {
                    EntityArrow entityarrow = ArrowUtil.createArrowComplete(worldIn, bow, arrow, entityplayer, basicBow, f, flag1, 0.0f, 0.0f, list, isLoaded);
                    worldIn.func_72838_d((Entity)entityarrow);
                }
            }

            @Override
            public void shrinkStack(ItemStack stack) {
                stack.func_190918_g(stack.func_190916_E() >= 2 ? 2 : 1);
            }

            @Override
            public void removeEnergy(ItemStack stack, ExtraBowsEnergy extraBowsEnergy) {
                extraBowsEnergy.extractEnergy(200, false);
            }

            @Override
            public boolean canShoot(ItemStack arrow, EntityPlayer player) {
                return arrow.func_190916_E() >= 2;
            }

            @Override
            public List<String> getDescription() {
                return UpgradeUtil.createDescriptionFromStingList(UpgradeUtil.getTranslatedDescriptionForUpgrade(this));
            }
        };
        TRIPLE_UPGRADE = new ArrowMultiplierUpgrade("triple_upgrade", ExtraBowsConfig.DURABILITY_TRIPLE_UPGRADE){

            @Override
            public void handleAction(BasicBow basicBow, World worldIn, ItemStack bow, EntityPlayer entityplayer, float f, ItemStack arrow, boolean flag1, UpgradeList list, boolean isLoaded) {
                if (arrow.func_190916_E() >= 3 || flag1 || isLoaded) {
                    EntityArrow entityarrow1 = ArrowUtil.createArrowComplete(worldIn, bow, arrow, entityplayer, basicBow, f, flag1, 0.0f, 2.5f, list, isLoaded);
                    worldIn.func_72838_d((Entity)entityarrow1);
                    EntityArrow entityarrow2 = ArrowUtil.createArrowComplete(worldIn, bow, arrow, entityplayer, basicBow, f, flag1, 0.0f, 0.0f, list, isLoaded);
                    worldIn.func_72838_d((Entity)entityarrow2);
                    EntityArrow entityarrow3 = ArrowUtil.createArrowComplete(worldIn, bow, arrow, entityplayer, basicBow, f, flag1, 0.0f, -2.5f, list, isLoaded);
                    worldIn.func_72838_d((Entity)entityarrow3);
                } else if (arrow.func_190916_E() == 2) {
                    DOUBLE_UPGRADE.handleAction(basicBow, worldIn, bow, entityplayer, f, arrow, flag1, list, isLoaded);
                } else {
                    EntityArrow entityarrow = ArrowUtil.createArrowComplete(worldIn, bow, arrow, entityplayer, basicBow, f, flag1, 0.0f, 0.0f, list, isLoaded);
                    worldIn.func_72838_d((Entity)entityarrow);
                }
            }

            @Override
            public void shrinkStack(ItemStack stack) {
                stack.func_190918_g(stack.func_190916_E() >= 3 ? 3 : (stack.func_190916_E() >= 2 ? 2 : 1));
            }

            @Override
            public void removeEnergy(ItemStack stack, ExtraBowsEnergy extraBowsEnergy) {
                extraBowsEnergy.extractEnergy(300, false);
            }

            @Override
            public boolean canShoot(ItemStack arrow, EntityPlayer player) {
                return arrow.func_190916_E() >= 3;
            }

            @Override
            public List<String> getDescription() {
                return UpgradeUtil.createDescriptionFromStingList(UpgradeUtil.getTranslatedDescriptionForUpgrade(this));
            }
        };
        LIGHTNING_UPGRADE = new ArrowModifierUpgrade("lightning_upgrade", ExtraBowsConfig.DURABILITY_LIGHTNING_UPGRADE){

            @Override
            public void handleBlockHit(BlockPos pos, World world, EntityPlayer player, EntityArrow arrow, UpgradeList upgradeList) {
                world.func_72942_c((Entity)new EntityLightningBolt(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), false));
                arrow.func_70106_y();
            }

            @Override
            public void handleEntityHit(Entity entity, World world, EntityPlayer player, EntityArrow arrow, UpgradeList upgradeList) {
                world.func_72942_c((Entity)new EntityLightningBolt(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, false));
                arrow.func_70106_y();
            }

            @Override
            public void handleArrowCreate(EntityArrow arrow, EntityPlayer player, UpgradeList upgradeList) {
                arrow.func_70015_d(10000);
            }

            @Override
            public List<String> getDescription() {
                return UpgradeUtil.createDescriptionFromStingList(UpgradeUtil.getTranslatedDescriptionForUpgrade(this));
            }
        };
        FIRE_UPGRADE = new ArrowModifierUpgrade("fire_upgrade", ExtraBowsConfig.DURABILITY_FIRE_UPGRADE){

            @Override
            public void handleBlockHit(BlockPos pos, World world, EntityPlayer player, EntityArrow arrow, UpgradeList upgradeList) {
                if (world.func_175623_d(pos = pos.func_177982_a(0, 1, 0))) {
                    world.func_180501_a(pos, Blocks.field_150480_ab.func_176223_P(), 11);
                }
            }

            @Override
            public void handleEntityHit(Entity entity, World world, EntityPlayer player, EntityArrow arrow, UpgradeList upgradeList) {
                entity.func_70015_d(5);
            }

            @Override
            public void handleArrowCreate(EntityArrow arrow, EntityPlayer player, UpgradeList upgradeList) {
                arrow.func_70015_d(10000);
            }

            @Override
            public List<String> getDescription() {
                return UpgradeUtil.createDescriptionFromStingList(UpgradeUtil.getTranslatedDescriptionForUpgrade(this, 1), UpgradeUtil.getTranslatedDescriptionForUpgrade(this, 2));
            }
        };
        ENDER_UPGRADE = new ArrowModifierUpgrade("ender_upgrade", ExtraBowsConfig.DURABILITY_ENDER_UPGRADE){

            @Override
            public void handleBlockHit(BlockPos pos, World world, EntityPlayer player, EntityArrow arrow, UpgradeList upgradeList) {
                player.func_70634_a((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
            }

            @Override
            public void handleEntityHit(Entity entity, World world, EntityPlayer player, EntityArrow arrow, UpgradeList upgradeList) {
                player.func_70634_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            }

            @Override
            public List<String> getDescription() {
                return UpgradeUtil.createDescriptionFromStingList(UpgradeUtil.getTranslatedDescriptionForUpgrade(this));
            }
        };
        FREEZE_UPGRADE = new ArrowModifierUpgrade("freeze_upgrade", ExtraBowsConfig.DURABILITY_FREEZE_UPGRADE){

            @Override
            public void handleBlockHit(BlockPos pos, World world, EntityPlayer player, EntityArrow arrow, UpgradeList upgradeList) {
                if (world.func_175623_d(pos = pos.func_177982_a(0, 1, 0)) && world.func_175665_u(pos.func_177982_a(0, -1, 0))) {
                    world.func_175656_a(pos, Blocks.field_150431_aC.func_176223_P());
                    if (RandomUtil.isChance(8, 1)) {
                        EntitySnowman snowman = new EntitySnowman(world);
                        snowman.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                        world.func_72838_d((Entity)snowman);
                    }
                }
            }

            @Override
            public void handleEntityHit(Entity entity, World world, EntityPlayer player, EntityArrow arrow, UpgradeList upgradeList) {
                if (entity instanceof EntityLivingBase) {
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 200, 1));
                }
            }

            @Override
            public void handleWaterHit(BlockPos pos, World world, EntityPlayer player, EntityArrow arrow, UpgradeList upgradeList) {
                if (world.func_180495_p(pos).func_177230_c().equals(Blocks.field_150355_j)) {
                    world.func_175656_a(pos, Blocks.field_150403_cj.func_176223_P());
                }
                for (BlockPos pos1 : UpgradeUtil.getBlocksInRadius(pos, 2)) {
                    if (!world.func_180495_p(pos1).func_177230_c().equals(Blocks.field_150355_j) && !world.func_180495_p(pos1).func_177230_c().equals(Blocks.field_150358_i) || !world.func_175623_d(pos1.func_177984_a())) continue;
                    if (RandomUtil.isChance(2, 1)) {
                        world.func_175656_a(pos1, Blocks.field_150403_cj.func_176223_P());
                    }
                    if (!RandomUtil.isChance(2, 1) || !world.func_175623_d(pos1.func_177984_a().func_177984_a())) continue;
                    world.func_175656_a(pos1.func_177984_a(), Blocks.field_150431_aC.func_176223_P());
                }
            }

            @Override
            public List<String> getDescription() {
                return UpgradeUtil.createDescriptionFromStingList(UpgradeUtil.getTranslatedDescriptionForUpgrade(this));
            }
        };
        EXPLOSIVE_UPGRADE = new ArrowModifierUpgrade("explosive_upgrade", ExtraBowsConfig.DURABILITY_EXPLOSIVE_UPGRADE){

            @Override
            public void handleBlockHit(BlockPos pos, World world, EntityPlayer player, EntityArrow arrow, UpgradeList upgradeList) {
                world.func_72876_a((Entity)player, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 3.0f, true);
                arrow.func_70106_y();
            }

            @Override
            public void handleEntityHit(Entity entity, World world, EntityPlayer player, EntityArrow arrow, UpgradeList upgradeList) {
                world.func_72876_a((Entity)player, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 3.0f, true);
                arrow.func_70106_y();
            }

            @Override
            public List<String> getDescription() {
                return UpgradeUtil.createDescriptionFromStingList(UpgradeUtil.getTranslatedDescriptionForUpgrade(this));
            }
        };
        HEAL_FROM_DAMAGE = new ArrowModifierUpgrade("heal_from_damage_upgrade", ExtraBowsConfig.DURABILITY_HEAL_FROM_DAMAGE_UPGRADE){

            @Override
            public void handleEntityHit(Entity entity, World world, EntityPlayer player, EntityArrow arrow, UpgradeList upgradeList) {
                if (entity instanceof EntityLivingBase && RandomUtil.isChance(3, 1)) {
                    player.func_70691_i(0.5f);
                }
            }

            @Override
            public List<String> getDescription() {
                return UpgradeUtil.createDescriptionFromStingList(UpgradeUtil.getTranslatedDescriptionForUpgrade(this));
            }
        };
        ARROW_COST = new ArrowModifierUpgrade("arrow_cost_upgrade", ExtraBowsConfig.DURABILITY_ARROW_COST_UPGRADE){

            @Override
            public void handleArrowCreate(EntityArrow arrow, EntityPlayer player, UpgradeList upgradeList) {
                if (RandomUtil.isChance(8, 1) && !player.func_191521_c(new ItemStack(Items.field_151032_g, 1))) {
                    player.func_71019_a(new ItemStack(Items.field_151032_g, 1), true);
                }
            }

            @Override
            public List<String> getDescription() {
                return UpgradeUtil.createDescriptionFromStingList(UpgradeUtil.getTranslatedDescriptionForUpgrade(this));
            }
        };
        WATER_UPGRADE = new ArrowModifierUpgrade("water_upgrade", ExtraBowsConfig.DURABILITY_WATER_UPGRADE){

            @Override
            public void handleBlockHit(BlockPos pos, World world, EntityPlayer player, EntityArrow arrow, UpgradeList upgradeList) {
                Iterable<BlockPos> list = UpgradeUtil.getBlocksInRadius(pos, 3);
                for (BlockPos pos1 : list) {
                    if (!world.func_180495_p(pos1).func_177230_c().equals(Blocks.field_150480_ab)) continue;
                    world.func_175698_g(pos1);
                }
                if (RandomUtil.isChance(6, 1) && world.field_73011_w.func_186058_p() != DimensionType.NETHER) {
                    world.func_175656_a(pos.func_177982_a(0, 1, 0), Blocks.field_150358_i.func_176223_P());
                    TimerUtil.addTimeCommand(new TimeCommand(100, () -> world.func_175698_g(pos.func_177982_a(0, 1, 0))));
                }
            }

            @Override
            public List<String> getDescription() {
                return UpgradeUtil.createDescriptionFromStingList(UpgradeUtil.getTranslatedDescriptionForUpgrade(this, 1), UpgradeUtil.getTranslatedDescriptionForUpgrade(this, 2));
            }
        };
        PUSH_UPGRADE = new ArrowModifierUpgrade("push_upgrade", ExtraBowsConfig.DURABILITY_PUSH_UPGRADE){

            @Override
            public void handleBlockHit(BlockPos pos, World world, EntityPlayer player, EntityArrow arrow, UpgradeList upgradeList) {
                world.func_72872_a(EntityLiving.class, UpgradeUtil.getRadiusBoundingBox(pos, 6)).forEach(livingEntity -> {
                    double deltaX = livingEntity.field_70165_t - arrow.field_70165_t;
                    double deltaZ = livingEntity.field_70161_v - arrow.field_70161_v;
                    int posX = deltaX > 0.0 ? 1 : -1;
                    int posZ = deltaZ > 0.0 ? 1 : -1;
                    deltaX = Math.abs(deltaX);
                    deltaZ = Math.abs(deltaZ);
                    double highestValue = deltaX > deltaZ ? deltaX : deltaZ;
                    livingEntity.func_70024_g((double)posX * (deltaX / highestValue), (double)0.7f, (double)posZ * (deltaZ / highestValue));
                });
            }

            @Override
            public void handleEntityHit(Entity entity, World world, EntityPlayer player, EntityArrow arrow, UpgradeList upgradeList) {
                world.func_72872_a(EntityLiving.class, UpgradeUtil.getRadiusBoundingBox(entity.func_180425_c(), 6)).forEach(livingEntity -> {
                    double deltaX = livingEntity.field_70165_t - arrow.field_70165_t;
                    double deltaZ = livingEntity.field_70161_v - arrow.field_70161_v;
                    int posX = deltaX > 0.0 ? 1 : -1;
                    int posZ = deltaZ > 0.0 ? 1 : -1;
                    deltaX = Math.abs(deltaX);
                    deltaZ = Math.abs(deltaZ);
                    double highestValue = deltaX > deltaZ ? deltaX : deltaZ;
                    livingEntity.func_70024_g((double)posX * (deltaX / highestValue), (double)0.7f, (double)posZ * (deltaZ / highestValue));
                });
            }

            @Override
            public List<String> getDescription() {
                return UpgradeUtil.createDescriptionFromStingList(UpgradeUtil.getTranslatedDescriptionForUpgrade(this));
            }
        };
        FLYING_UPGRADE = new ArrowModifierUpgrade("flying_upgrade", ExtraBowsConfig.DURABILITY_FLY_UPGRADE){

            @Override
            public void handleEntityInit(EntityArrow arrow, UpgradeList upgradeList, EntityPlayer player) {
                arrow.func_184216_O().add("flyingUpgrade");
                player.func_184220_m((Entity)arrow);
            }

            @Override
            public void handleBlockHit(BlockPos pos, World world, EntityPlayer player, EntityArrow arrow, UpgradeList upgradeList) {
                if (arrow.func_184207_aI()) {
                    player.func_70097_a(DamageSource.field_76379_h, 2.0f);
                }
            }

            @Override
            public void handleEntityHit(Entity entity, World world, EntityPlayer player, EntityArrow arrow, UpgradeList upgradeList) {
                if (arrow.func_184207_aI()) {
                    player.func_70097_a(DamageSource.field_76379_h, 2.0f);
                }
            }

            @Override
            public List<String> getDescription() {
                return UpgradeUtil.createDescriptionFromStingList(UpgradeUtil.getTranslatedDescriptionForUpgrade(this));
            }
        };
        METEOR_UPGRADE = new ArrowModifierUpgrade("meteor_upgrade", ExtraBowsConfig.DURABILITY_METEOR_UPGRADE){

            @Override
            public void handleBlockHit(BlockPos pos, World world, EntityPlayer player, EntityArrow arrow, UpgradeList upgradeList) {
                this.spawnMeteor(world, arrow);
            }

            @Override
            public void handleEntityHit(Entity entity, World world, EntityPlayer player, EntityArrow arrow, UpgradeList upgradeList) {
                this.spawnMeteor(world, arrow);
            }

            private void spawnMeteor(World world, EntityArrow arrow) {
                if (world.func_175623_d(new BlockPos(arrow.field_70165_t, arrow.field_70163_u + 20.0, arrow.field_70161_v))) {
                    EntityLargeFireball fireballEntity = new EntityLargeFireball(world);
                    fireballEntity.func_70634_a(arrow.field_70165_t, arrow.field_70163_u + 20.0, arrow.field_70161_v);
                    fireballEntity.func_70024_g(0.0, -2.0, 0.0);
                    world.func_72838_d((Entity)fireballEntity);
                }
            }

            @Override
            public List<String> getDescription() {
                return UpgradeUtil.createDescriptionFromStingList(UpgradeUtil.getTranslatedDescriptionForUpgrade(this));
            }
        };
        ELECTRIC_UPGRADE = new ElectricUpgrade();
        BRIDGE_UPGRADE = new BridgeUpgrade();
    }
}

