/*
 * Decompiled with CFR 0.152.
 */
package me.marnic.extrabows.common.events;

import java.util.HashMap;
import me.marnic.extrabows.api.item.IModelRegistry;
import me.marnic.extrabows.api.upgrade.ArrowModifierUpgrade;
import me.marnic.extrabows.api.upgrade.UpgradeList;
import me.marnic.extrabows.api.upgrade.Upgrades;
import me.marnic.extrabows.api.util.ArrowUtil;
import me.marnic.extrabows.api.util.TimeCommand;
import me.marnic.extrabows.api.util.TimerUtil;
import me.marnic.extrabows.api.util.UpgradeUtil;
import me.marnic.extrabows.client.input.ExtraBowsInputHandler;
import me.marnic.extrabows.common.items.BasicBow;
import me.marnic.extrabows.common.items.BowSettings;
import me.marnic.extrabows.common.main.ExtraBowsObjects;
import me.marnic.extrabows.common.packet.ExtraBowsPacketHandler;
import me.marnic.extrabows.common.packet.PacketUpdateArrow;
import me.marnic.extrabows.common.recipes.BasicBowRecipe;
import me.marnic.extrabows.common.recipes.BasicBowShapelessRecipe;
import me.marnic.extrabows.common.registry.ExtraBowsRegistry;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class ExtraBowsEventHandler {
    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> e) {
        for (Item item : ExtraBowsRegistry.ITEMS_TO_REGISTER) {
            e.getRegistry().register((IForgeRegistryEntry)item);
        }
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> e) {
        for (Block block : ExtraBowsRegistry.BLOCKS_TO_REGISTER) {
            e.getRegistry().register((IForgeRegistryEntry)block);
        }
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent e) {
        for (IModelRegistry registry : ExtraBowsRegistry.MODELS_TO_REGISTER) {
            registry.registerModel();
        }
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> e) {
        HashMap<ResourceLocation, IRecipe> bowRecipes = new HashMap<ResourceLocation, IRecipe>();
        e.getRegistry().getValuesCollection().stream().filter(r -> r.getRegistryName().func_110624_b().equalsIgnoreCase("extrabows") && r.getRegistryName().func_110623_a().contains("bow")).forEach(r -> bowRecipes.put(r.getRegistryName(), (IRecipe)r));
        bowRecipes.forEach((k, v) -> {
            BasicBowRecipe basicBowRecipe;
            if (k.func_110623_a().contains("stone_bow")) {
                basicBowRecipe = (BasicBowRecipe)new BasicBowRecipe(k.func_110623_a(), (NonNullList<Ingredient>)v.func_192400_c(), new ItemStack((Item)ExtraBowsObjects.STONE_BOW), BowSettings.STONE).setRegistryName((ResourceLocation)k);
                e.getRegistry().register((IForgeRegistryEntry)basicBowRecipe);
                e.getRegistry().register((IForgeRegistryEntry)new BasicBowShapelessRecipe(basicBowRecipe, ExtraBowsObjects.STONE_UPGRADE_KIT));
            }
            if (k.func_110623_a().contains("golden_bow")) {
                basicBowRecipe = (BasicBowRecipe)new BasicBowRecipe(k.func_110623_a(), (NonNullList<Ingredient>)v.func_192400_c(), new ItemStack((Item)ExtraBowsObjects.GOLD_BOW), BowSettings.GOLD).setRegistryName((ResourceLocation)k);
                e.getRegistry().register((IForgeRegistryEntry)basicBowRecipe);
                e.getRegistry().register((IForgeRegistryEntry)new BasicBowShapelessRecipe(basicBowRecipe, ExtraBowsObjects.GOLD_UPGRADE_KIT));
            }
            if (k.func_110623_a().contains("iron_bow")) {
                basicBowRecipe = (BasicBowRecipe)new BasicBowRecipe(k.func_110623_a(), (NonNullList<Ingredient>)v.func_192400_c(), new ItemStack((Item)ExtraBowsObjects.IRON_BOW), BowSettings.IRON).setRegistryName((ResourceLocation)k);
                e.getRegistry().register((IForgeRegistryEntry)basicBowRecipe);
                e.getRegistry().register((IForgeRegistryEntry)new BasicBowShapelessRecipe(basicBowRecipe, ExtraBowsObjects.IRON_UPGRADE_KIT));
            }
            if (k.func_110623_a().contains("diamond_bow")) {
                basicBowRecipe = (BasicBowRecipe)new BasicBowRecipe(k.func_110623_a(), (NonNullList<Ingredient>)v.func_192400_c(), new ItemStack((Item)ExtraBowsObjects.DIAMOND_BOW), BowSettings.DIAMOND).setRegistryName((ResourceLocation)k);
                e.getRegistry().register((IForgeRegistryEntry)basicBowRecipe);
                e.getRegistry().register((IForgeRegistryEntry)new BasicBowShapelessRecipe(basicBowRecipe, ExtraBowsObjects.DIAMOND_UPGRADE_KIT));
            }
            if (k.func_110623_a().contains("emerald_bow")) {
                basicBowRecipe = (BasicBowRecipe)new BasicBowRecipe(k.func_110623_a(), (NonNullList<Ingredient>)v.func_192400_c(), new ItemStack((Item)ExtraBowsObjects.EMERALD_BOW), BowSettings.EMERALD).setRegistryName((ResourceLocation)k);
                e.getRegistry().register((IForgeRegistryEntry)basicBowRecipe);
                e.getRegistry().register((IForgeRegistryEntry)new BasicBowShapelessRecipe(basicBowRecipe, ExtraBowsObjects.EMERALD_UPGRADE_KIT));
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void keyInput(InputEvent.KeyInputEvent e) {
        ExtraBowsInputHandler.handleKeyPressedEvent(e);
    }

    @SubscribeEvent
    public static void worldTickEvent(TickEvent.ServerTickEvent event) {
        TimerUtil.handleTickEvent(event);
    }

    @SubscribeEvent
    public static void blockbreak(BlockEvent.BreakEvent e) {
        if (e.getState().func_177230_c().equals(ExtraBowsObjects.BRIDGE_BLOCK)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void itemCrafted(final PlayerEvent.ItemCraftedEvent e) {
        if (e.crafting.func_77973_b().equals(Upgrades.LIGHTNING_UPGRADE.getItem())) {
            for (int i = 1; i < 14; ++i) {
                TimerUtil.addTimeCommand(new TimeCommand(20 * i, new Runnable(){

                    @Override
                    public void run() {
                        e.player.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(e.player.field_70170_p, e.player.field_70165_t, e.player.field_70163_u, e.player.field_70161_v, false));
                    }
                }));
            }
        }
    }

    @SubscribeEvent
    public static void projectileHit(ProjectileImpactEvent.Arrow e) {
        if (e.getEntity() instanceof EntityArrow) {
            EntityArrow arrow = (EntityArrow)e.getEntity();
            if (arrow.field_70250_c instanceof EntityPlayer && UpgradeUtil.isExtraBowsArrow((Entity)arrow)) {
                EntityPlayer player = (EntityPlayer)arrow.field_70250_c;
                if (e.getRayTraceResult().field_72313_a == RayTraceResult.Type.ENTITY && arrow.field_70250_c.equals((Object)e.getRayTraceResult().field_72308_g) && arrow.func_184216_O().contains("flyingUpgrade")) {
                    e.setCanceled(true);
                    return;
                }
                if (!arrow.getEntityData().func_74767_n("alreadyHit")) {
                    arrow.getEntityData().func_74757_a("alreadyHit", true);
                    UpgradeList list = ArrowUtil.ARROWS_TO_UPGRADES.get(arrow.func_110124_au());
                    if (list != null) {
                        if (e.getRayTraceResult().field_72313_a == RayTraceResult.Type.BLOCK) {
                            list.handleModifierHittingEvent(ArrowModifierUpgrade.EventType.BLOCK_HIT, e.getRayTraceResult().func_178782_a(), null, e.getEntity().field_70170_p, player, arrow);
                            list.getBasicBow().onArrowHit(arrow);
                        } else if (e.getRayTraceResult().field_72313_a == RayTraceResult.Type.ENTITY) {
                            list.handleModifierHittingEvent(ArrowModifierUpgrade.EventType.ENTITY_HIT, null, e.getRayTraceResult().field_72308_g, e.getEntity().field_70170_p, player, arrow);
                            list.getBasicBow().onArrowHit(arrow);
                        }
                        ArrowUtil.ARROWS_TO_UPGRADES.remove(arrow.func_110124_au());
                        TimeCommand.EndableTimeCommand command = (TimeCommand.EndableTimeCommand)TimerUtil.forId(arrow.func_145782_y());
                        if (command != null) {
                            command.setEnd(true);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void arrowConstructing(final EntityJoinWorldEvent e) {
        if (!e.getWorld().field_72995_K && e.getEntity() instanceof EntityArrow && UpgradeUtil.isExtraBowsArrow(e.getEntity())) {
            final EntityArrow arrow = (EntityArrow)e.getEntity();
            if (arrow.field_70250_c instanceof EntityPlayerMP) {
                ItemStack bow = ((EntityPlayer)arrow.field_70250_c).func_184614_ca();
                if (!(bow.func_77973_b() instanceof BasicBow)) {
                    return;
                }
                final UpgradeList list = UpgradeUtil.getUpgradesFromStack(bow);
                ArrowUtil.ARROWS_TO_UPGRADES.put(arrow.func_110124_au(), list);
                final TimeCommand.EndableTimeCommand command = new TimeCommand.EndableTimeCommand(0, arrow.func_145782_y());
                command.setExecute(new Runnable(){
                    boolean prevWater = false;

                    @Override
                    public void run() {
                        if (arrow.func_70090_H() && !this.prevWater) {
                            list.handleModifierHittingEvent(ArrowModifierUpgrade.EventType.WATER_HIT, arrow.func_180425_c(), null, e.getWorld(), (EntityPlayer)arrow.field_70250_c, arrow);
                        }
                        if (!arrow.getEntityData().func_74767_n("alreadyHit")) {
                            list.handleOnUpdatedEvent(arrow, arrow.field_70170_p);
                        } else {
                            command.setEnd(true);
                        }
                        this.prevWater = arrow.func_70090_H();
                    }
                });
                TimerUtil.addTimeCommand(command);
                list.handleModifierEvent(ArrowModifierUpgrade.EventType.ENTITY_INIT, arrow, (EntityPlayer)arrow.field_70250_c, bow);
            }
        }
    }

    @SubscribeEvent
    public static void startTracking(PlayerEvent.StartTracking e) {
        if (e.getTarget() instanceof EntityArrow && UpgradeUtil.isExtraBowsArrow(e.getTarget()) && e.getTarget().func_184216_O().contains("flyingUpgrade")) {
            ExtraBowsPacketHandler.INSTANCE.sendTo((IMessage)new PacketUpdateArrow((EntityArrow)e.getTarget()), (EntityPlayerMP)e.getEntityPlayer());
        }
    }
}

