/*
 * Decompiled with CFR 0.152.
 */
package me.marnic.extrabows.common.items;

import me.marnic.extrabows.common.config.ExtraBowsConfig;
import net.minecraft.item.Item;

public class CustomBowSettings {
    public static final float NORMAL_DAMAGE = 0.0f;
    public static final float NORMAL_INACCURACY = 1.0f;
    public static final float NORMAL_TIME = 20.0f;
    public static final int ENERGY_COST_PER_ARROW = 100;
    public static final int ENERGY_BOW = 40000;
    public static final int ENERGY_BOW_UPGRADE = 30000;
    public static final int ENERGY_RECEIVE = 50;
    private String name;
    private int maxUses;
    private float velocityMul;
    private float damage;
    private float inaccuracy;
    private float time;
    private Item type;

    public CustomBowSettings(String name, int maxUses, float velocityMul, float damage, float inaccuracy, float time) {
        this.name = name;
        this.maxUses = maxUses;
        this.velocityMul = velocityMul;
        this.damage = damage;
        this.inaccuracy = inaccuracy;
        this.time = time;
        this.onInit();
    }

    public CustomBowSettings(String name) {
        this.name = name;
        this.maxUses = 384;
        this.velocityMul = 3.0f;
        this.damage = 0.0f;
        this.inaccuracy = 1.0f;
        this.time = 20.0f;
        this.onInit();
    }

    public CustomBowSettings(String name, ExtraBowsConfig.BowConfig config) {
        this(name, config.durability, config.velocityMultiplier, config.damage, config.inaccuracy, config.time);
    }

    public CustomBowSettings copy(CustomBowSettings settings) {
        this.maxUses = settings.maxUses;
        this.velocityMul = settings.velocityMul;
        this.damage = settings.damage;
        this.inaccuracy = settings.inaccuracy;
        this.time = settings.time;
        return this;
    }

    public void onInit() {
    }

    public String getName() {
        return this.name;
    }

    public int getMaxUses() {
        return this.maxUses;
    }

    public float getVelocityMul() {
        return this.velocityMul;
    }

    public float getDamage() {
        return this.damage;
    }

    public float getInaccuracy() {
        return this.inaccuracy;
    }

    public float getTime() {
        return this.time;
    }

    public Item getType() {
        return this.type;
    }

    public CustomBowSettings setType(Item type) {
        this.type = type;
        return this;
    }
}

