/*
 * Decompiled with CFR 0.152.
 */
package me.marnic.extrabows.common.upgrades;

import java.util.ArrayList;
import java.util.List;
import me.marnic.extrabows.api.upgrade.ArrowModifierUpgrade;
import me.marnic.extrabows.api.upgrade.UpgradeList;
import me.marnic.extrabows.api.util.TimeCommand;
import me.marnic.extrabows.api.util.TimerUtil;
import me.marnic.extrabows.api.util.UpgradeUtil;
import me.marnic.extrabows.common.blocks.tileentities.TileEntityBridgeBlock;
import me.marnic.extrabows.common.config.ExtraBowsConfig;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class BridgeUpgrade
extends ArrowModifierUpgrade {
    public static Block BUILDING_BLOCK;
    public static int ACTIVE_TIME;

    public BridgeUpgrade() {
        super("bridge_upgrade", ExtraBowsConfig.DURABILITY_BRIDGE_UPGRADE);
    }

    public static boolean placeBlock(BlockPos pos, IBlockState state, World world) {
        if (world.func_175623_d(pos)) {
            world.func_175656_a(pos, state);
            return true;
        }
        if (world.func_180495_p(pos).func_177230_c().equals(Blocks.field_150355_j)) {
            world.func_175656_a(pos, state);
            ((TileEntityBridgeBlock)world.func_175625_s(pos)).setFluid((Block)Blocks.field_150355_j);
            return true;
        }
        if (world.func_180495_p(pos).func_177230_c().equals(Blocks.field_150353_l)) {
            world.func_175656_a(pos, state);
            ((TileEntityBridgeBlock)world.func_175625_s(pos)).setFluid((Block)Blocks.field_150353_l);
            return true;
        }
        return false;
    }

    @Override
    public List<String> getDescription() {
        return UpgradeUtil.createDescriptionFromStingList(UpgradeUtil.getTranslatedDescriptionForUpgrade(this, 1), UpgradeUtil.getTranslatedDescriptionForUpgrade(this, 2));
    }

    @Override
    public void handleEntityInit(EntityArrow arrow, UpgradeList upgradeList, EntityPlayer player) {
        BuildingUpgradeData data = new BuildingUpgradeData();
        data.facing = player.func_174811_aO();
        upgradeList.getDataMap().put(this, data);
    }

    @Override
    public void handleFlyingEvent(final EntityArrow arrow, final World world, UpgradeList upgradeList) {
        final BuildingUpgradeData data = (BuildingUpgradeData)upgradeList.getDataMap().get(this);
        BlockPos pos = arrow.func_180425_c().func_177982_a(0, -3, 0);
        data.builder.needsFix(pos, data.blockPos.size() >= 1 ? data.blockPos.get(data.blockPos.size() - 1) : null, data.blockPos, data.blockPos.size(), world, data.facing);
        data.blockPos.add(new BlockSave(pos, data.blockPos.size()).setRemovable(world.func_175623_d(pos)));
        TimerUtil.addTimeCommand(new TimeCommand(data.blockPos.size() * 2, new Runnable(){
            BlockPos pos1;
            int size;
            {
                this.pos1 = arrow.func_180425_c().func_177982_a(0, -3, 0);
                this.size = data.blockPos.size();
            }

            @Override
            public void run() {
                if (BridgeUpgrade.placeBlock(this.pos1, BUILDING_BLOCK.func_176223_P(), world)) {
                    ((TileEntityBridgeBlock)world.func_175625_s(this.pos1)).setTicksToLive(this.size + ACTIVE_TIME * 20);
                }
            }
        }));
    }

    private boolean fix(BlockPos next) {
        return this.isOffset(next.func_177958_n(), 1) || this.isOffset(next.func_177956_o(), 1) || this.isOffset(next.func_177952_p(), 1);
    }

    private boolean isOffset(int number, int offset) {
        return number > offset | number < -offset;
    }

    static {
        ACTIVE_TIME = 20;
    }

    class BridgeBuilder {
        BridgeBuilder() {
        }

        public void needsFix(BlockPos pos, BlockSave last, ArrayList<BlockSave> blocks, final int id, final World world, EnumFacing facing) {
            if (blocks.size() >= 1) {
                BlockPos next = last.pos.func_177973_b((Vec3i)pos);
                BlockPos nextAbs = new BlockPos(Math.abs(next.func_177958_n()), Math.abs(next.func_177956_o()), Math.abs(next.func_177952_p()));
                if (BridgeUpgrade.this.fix(next)) {
                    int y_needed = nextAbs.func_177956_o();
                    int x_needed = nextAbs.func_177958_n();
                    int z_needed = nextAbs.func_177952_p();
                    int neg_x = next.func_177958_n() < 0 ? -1 : 1;
                    int neg_y = next.func_177956_o() < 0 ? -1 : 1;
                    int neg_z = next.func_177952_p() < 0 ? -1 : 1;
                    BlockPos begin = pos.func_177982_a(0, 0, 0);
                    int all = x_needed + y_needed + z_needed;
                    for (int i = 0; i < all; ++i) {
                        if (y_needed > 0) {
                            begin = begin.func_177982_a(0, neg_y * 1, 0);
                        }
                        if (x_needed > 0) {
                            begin = begin.func_177982_a(1 * neg_x, 0, 0);
                        }
                        if (z_needed > 0) {
                            begin = begin.func_177982_a(0, 0, 1 * neg_z);
                        }
                        final BlockPos finalBegin = begin;
                        TimerUtil.addTimeCommand(new TimeCommand(id * 2, new Runnable(){

                            @Override
                            public void run() {
                                if (BridgeUpgrade.placeBlock(finalBegin, BUILDING_BLOCK.func_176223_P(), world)) {
                                    ((TileEntityBridgeBlock)world.func_175625_s(finalBegin)).setTicksToLive(id + ACTIVE_TIME * 20);
                                }
                            }
                        }));
                        --x_needed;
                        --y_needed;
                        --z_needed;
                    }
                }
            }
        }
    }

    class BlockSave {
        public BlockPos pos;
        public int id;
        public boolean canBeRemoved = true;

        public BlockSave(BlockPos pos, int id) {
            this.pos = pos;
            this.id = id;
        }

        public BlockSave setRemovable(boolean value) {
            this.canBeRemoved = value;
            return this;
        }
    }

    class BuildingUpgradeData {
        public ArrayList<BlockSave> blockPos = new ArrayList();
        public BridgeBuilder builder;
        public EnumFacing facing;

        public BuildingUpgradeData() {
            this.builder = new BridgeBuilder();
        }
    }
}

