/*
 * Decompiled with CFR 0.152.
 */
package me.marnic.extrabows.api.util;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import me.marnic.extrabows.api.upgrade.ArrowModifierUpgrade;
import me.marnic.extrabows.api.upgrade.ArrowMultiplierUpgrade;
import me.marnic.extrabows.api.upgrade.BasicUpgrade;
import me.marnic.extrabows.api.upgrade.UpgradeList;
import me.marnic.extrabows.common.items.BasicBow;
import me.marnic.extrabows.common.items.upgrades.BasicUpgradeItem;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class UpgradeUtil {
    public static UpgradeList getUpgradesFromStack(ItemStack stack) {
        ArrowMultiplierUpgrade multiplierUpgrade = null;
        ArrayList<ArrowModifierUpgrade> mods = new ArrayList<ArrowModifierUpgrade>();
        ItemStackHandler handler = UpgradeUtil.getHandlerForItemStack(stack);
        if (handler != null) {
            if (!handler.getStackInSlot(0).func_190926_b()) {
                multiplierUpgrade = (ArrowMultiplierUpgrade)UpgradeUtil.getUpgradeFromStack(handler.getStackInSlot(0));
            }
            for (int i = 1; i < 4; ++i) {
                if (handler.getStackInSlot(i).func_190926_b()) continue;
                mods.add((ArrowModifierUpgrade)UpgradeUtil.getUpgradeFromStack(handler.getStackInSlot(i)));
            }
        }
        return new UpgradeList(multiplierUpgrade, mods, handler, (BasicBow)stack.func_77973_b());
    }

    public static BasicUpgrade getUpgradeFromStack(ItemStack stack) {
        if (stack.func_77973_b() instanceof BasicUpgradeItem) {
            return ((BasicUpgradeItem)stack.func_77973_b()).getUpgrade();
        }
        return null;
    }

    public static ItemStackHandler getHandlerForItemStack(ItemStack stack) {
        return (ItemStackHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElse(null);
    }

    public static void saveUpgradesToStack(ItemStack stack, ItemStackHandler handler2) {
        ItemStackHandler handler = (ItemStackHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElse(null);
        for (int i = 0; i < handler2.getSlots(); ++i) {
            handler.setStackInSlot(i, handler2.getStackInSlot(i));
        }
    }

    public static void copyUpgradesToStack(ItemStack old, ItemStack newOne) {
        ItemStackHandler handlerOld = UpgradeUtil.getHandlerForItemStack(old);
        UpgradeUtil.saveUpgradesToStack(newOne, handlerOld);
    }

    public static Stream<BlockPos> getBlocksInRadius(BlockPos center, int radius) {
        BlockPos min = new BlockPos(center.func_177958_n() - radius, center.func_177956_o() - radius, center.func_177952_p() - radius);
        BlockPos max = new BlockPos(center.func_177958_n() + radius, center.func_177956_o() + radius, center.func_177952_p() + radius);
        return BlockPos.func_218281_b((BlockPos)min, (BlockPos)max);
    }

    public static AxisAlignedBB getRadiusBoundingBox(BlockPos center, int radius) {
        BlockPos min = new BlockPos(center.func_177958_n() - radius, center.func_177956_o() - radius, center.func_177952_p() - radius);
        BlockPos max = new BlockPos(center.func_177958_n() + radius, center.func_177956_o() + radius, center.func_177952_p() + radius);
        return new AxisAlignedBB(min, max);
    }

    public static boolean isMultiplierUpgrade(ItemStack stack) {
        if (stack.func_77973_b() instanceof BasicUpgradeItem) {
            return ((BasicUpgradeItem)stack.func_77973_b()).getUpgrade() instanceof ArrowMultiplierUpgrade;
        }
        return false;
    }

    public static boolean isModifierUpgrade(ItemStack stack) {
        if (stack.func_77973_b() instanceof BasicUpgradeItem) {
            return ((BasicUpgradeItem)stack.func_77973_b()).getUpgrade() instanceof ArrowModifierUpgrade;
        }
        return false;
    }

    public static List<ITextComponent> createDescriptionFromStingList(String ... list) {
        ArrayList<ITextComponent> list1 = new ArrayList<ITextComponent>();
        for (String s : list) {
            list1.add((ITextComponent)new StringTextComponent(s));
        }
        return list1;
    }

    public static String getTranslatedDescriptionForUpgrade(BasicUpgrade upgrade) {
        return new TranslationTextComponent(upgrade.getNonFormattedName() + ".description.text", new Object[0]).func_150254_d();
    }

    public static String getTranslatedDescriptionForUpgrade(BasicUpgrade upgrade, int numb) {
        return new TranslationTextComponent(upgrade.getNonFormattedName() + ".description.text" + numb, new Object[0]).func_150254_d();
    }

    public static boolean isExtraBowsArrow(Entity e) {
        return e.func_184216_O().contains("extrabows");
    }
}

