/*
 * Decompiled with CFR 0.152.
 */
package me.marnic.extrabows.common.items;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.marnic.extrabows.api.energy.ExtraBowsEnergy;
import me.marnic.extrabows.api.item.BasicItem;
import me.marnic.extrabows.api.upgrade.BasicUpgrade;
import me.marnic.extrabows.api.upgrade.UpgradeList;
import me.marnic.extrabows.api.upgrade.Upgrades;
import me.marnic.extrabows.api.util.ArrowUtil;
import me.marnic.extrabows.api.util.RandomUtil;
import me.marnic.extrabows.api.util.UpgradeUtil;
import me.marnic.extrabows.common.items.CustomBowSettings;
import me.marnic.extrabows.common.items.bows.ItemElectricBow;
import me.marnic.extrabows.common.main.ExtraBowsObjects;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class BasicBow
extends BowItem
implements BasicItem {
    private CustomBowSettings settings;

    public BasicBow(String name) {
        super(new Item.Properties().func_200916_a(ExtraBowsObjects.CREATIVE_TAB).func_200917_a(1));
        this.createItem(name);
    }

    public BasicBow(String name, Item.Properties builder, CustomBowSettings settings) {
        super(builder.func_200917_a(1));
        this.settings = settings;
        this.createItem(name);
    }

    @Override
    public void initConfigOptions() {
        this.func_185043_a(new ResourceLocation("pull"), (p_210310_0_, p_210310_1_, p_210310_2_) -> {
            if (p_210310_2_ == null) {
                return 0.0f;
            }
            return !(p_210310_2_.func_184607_cu().func_77973_b() instanceof BowItem) ? 0.0f : (float)(p_210310_0_.func_77988_m() - p_210310_2_.func_184605_cv()) / this.settings.getTime();
        });
    }

    private ItemStack findAmmoNEW(PlayerEntity player, boolean electric) {
        if (electric) {
            return new ItemStack((IItemProvider)Items.field_151032_g);
        }
        if (this.isArrow(player.func_184586_b(Hand.OFF_HAND))) {
            return player.func_184586_b(Hand.OFF_HAND);
        }
        if (this.isArrow(player.func_184586_b(Hand.MAIN_HAND))) {
            return player.func_184586_b(Hand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isArrow(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (this.isLoaded(UpgradeUtil.getUpgradesFromStack(stack), stack)) {
            playerIn.func_184598_c(handIn);
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof PlayerEntity) {
            PlayerEntity entityplayer = (PlayerEntity)entityLiving;
            boolean flag = entityplayer.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            UpgradeList list = UpgradeUtil.getUpgradesFromStack(stack);
            boolean isLoaded = this.isLoaded(list, stack);
            ItemStack arrowStack = this.findAmmoNEW(entityplayer, isLoaded);
            int i = this.func_77626_a(stack) - timeLeft;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)worldIn, (PlayerEntity)entityplayer, (int)i, (!arrowStack.func_190926_b() || flag ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!arrowStack.func_190926_b() || flag) {
                float f;
                if (arrowStack.func_190926_b()) {
                    arrowStack = new ItemStack((IItemProvider)Items.field_151032_g);
                }
                if ((double)(f = ArrowUtil.getArrowVelocity(i, this)) >= 0.1) {
                    boolean flag1;
                    boolean bl = flag1 = entityplayer.field_71075_bZ.field_75098_d || arrowStack.func_77973_b() instanceof ArrowItem && ((ArrowItem)arrowStack.func_77973_b()).isInfinite(arrowStack, stack, entityplayer);
                    if (!worldIn.field_72995_K) {
                        list.applyDamage(entityplayer);
                        if (list.hasMul()) {
                            list.getArrowMultiplier().handleAction(this, worldIn, stack, entityplayer, f, arrowStack, flag1, list, isLoaded);
                        } else {
                            AbstractArrowEntity entityarrow = ArrowUtil.createArrowComplete(worldIn, stack, arrowStack, entityplayer, this, f, flag1, 0.0f, 0.0f, list, isLoaded);
                            worldIn.func_217376_c((Entity)entityarrow);
                        }
                    }
                    worldIn.func_184148_a(null, (double)entityplayer.func_180425_c().func_177958_n(), (double)entityplayer.func_180425_c().func_177956_o(), (double)entityplayer.func_180425_c().func_177952_p(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (RandomUtil.RANDOM.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                    if (!flag1 && !entityplayer.field_71075_bZ.field_75098_d) {
                        ExtraBowsEnergy extraBowsEnergy;
                        boolean useNormal = true;
                        if (isLoaded && (extraBowsEnergy = (ExtraBowsEnergy)((Object)stack.getCapability(CapabilityEnergy.ENERGY, null).orElse(null))).getEnergyStored() >= 100) {
                            useNormal = false;
                            if (list.hasMul()) {
                                list.getArrowMultiplier().removeEnergy(arrowStack, extraBowsEnergy);
                            } else if (extraBowsEnergy.getEnergyStored() >= 100) {
                                extraBowsEnergy.extractEnergy(100, false);
                            }
                        }
                        if (useNormal) {
                            if (list.hasMul()) {
                                list.getArrowMultiplier().shrinkStack(arrowStack);
                            } else {
                                arrowStack.func_190918_g(1);
                                if (arrowStack.func_190926_b()) {
                                    entityplayer.field_71071_by.func_184437_d(arrowStack);
                                }
                            }
                            if (!worldIn.field_72995_K && stack.func_77952_i() == stack.func_77958_k()) {
                                list.dropItems(entityplayer);
                                stack.func_222118_a(1, (LivingEntity)entityplayer, p -> p.func_213334_d(p.func_184600_cs()));
                            }
                        }
                    }
                    entityplayer.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                }
            }
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ExtraBowsEnergy storage;
        UpgradeList list = UpgradeUtil.getUpgradesFromStack(stack);
        tooltip.add((ITextComponent)new StringTextComponent("Press B to open the Upgrade inventory"));
        if (!list.hasMul() && !list.hasMods()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("message.no_upgrades.text", new Object[0]));
        } else {
            tooltip.add((ITextComponent)new StringTextComponent("Upgrades:"));
        }
        if (list.hasMul()) {
            tooltip.add((ITextComponent)new StringTextComponent("Arrow Multiplier:"));
            tooltip.add((ITextComponent)new StringTextComponent("- " + list.getArrowMultiplier().getName()));
        }
        if (list.hasMods()) {
            tooltip.add((ITextComponent)new StringTextComponent("Arrow Modifiers:"));
            for (BasicUpgrade basicUpgrade : list.getArrowModifiers()) {
                tooltip.add((ITextComponent)new StringTextComponent("- " + basicUpgrade.getName()));
            }
        }
        if (this.isElectric(list, stack) && worldIn != null && (storage = (ExtraBowsEnergy)((Object)stack.getCapability(CapabilityEnergy.ENERGY, null).orElse(null))) != null) {
            tooltip.add((ITextComponent)new StringTextComponent("Energy: " + storage.getEnergyStored() + "/" + storage.getMaxEnergyStored() + "RF"));
        }
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack stack) {
        ItemStackHandler handler;
        ExtraBowsEnergy extraBowsEnergy;
        CompoundNBT compound = super.getShareTag(stack);
        if (compound == null) {
            compound = new CompoundNBT();
        }
        if ((extraBowsEnergy = (ExtraBowsEnergy)((Object)stack.getCapability(CapabilityEnergy.ENERGY, null).orElse(null))) != null) {
            compound.func_74768_a("energy", extraBowsEnergy.getEnergyStored());
            compound.func_74768_a("maxEnergy", extraBowsEnergy.getMaxEnergyStored());
        }
        if ((handler = (ItemStackHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElse(null)) != null) {
            compound.func_218657_a("itemHandlerData", (INBT)handler.serializeNBT());
        }
        return compound;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundNBT nbt) {
        super.readShareTag(stack, nbt);
        if (nbt != null) {
            ExtraBowsEnergy extraBowsEnergy = (ExtraBowsEnergy)((Object)stack.getCapability(CapabilityEnergy.ENERGY, null).orElse(null));
            ItemStackHandler handler = (ItemStackHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElse(null);
            if (extraBowsEnergy != null) {
                int energy = nbt.func_74762_e("energy");
                int maxEnergy = nbt.func_74762_e("maxEnergy");
                extraBowsEnergy.setEnergy(energy);
                extraBowsEnergy.setCapacity(maxEnergy);
            }
            if (handler != null) {
                CompoundNBT tag = nbt.func_74775_l("itemHandlerData");
                handler.deserializeNBT(tag);
            }
        }
    }

    @Override
    public Item getItem() {
        return this;
    }

    public CustomBowSettings getSettings() {
        return this.settings;
    }

    public void setSettings(CustomBowSettings settings) {
        this.settings = settings;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new BowCapability(stack);
    }

    public boolean func_82789_a(ItemStack left, ItemStack right) {
        return right.func_77973_b().equals(this.settings.getType());
    }

    private boolean isElectric(UpgradeList list, ItemStack stack) {
        return list.contains(Upgrades.ELECTRIC_UPGRADE) || stack.func_77973_b() instanceof ItemElectricBow;
    }

    private boolean isLoaded(UpgradeList list, ItemStack stack) {
        boolean b;
        boolean bl = b = list.contains(Upgrades.ELECTRIC_UPGRADE) || stack.func_77973_b() instanceof ItemElectricBow;
        if (b) {
            return ((IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null).orElse(null)).getEnergyStored() >= 100;
        }
        return false;
    }

    public void onArrowCreate(AbstractArrowEntity arrow) {
    }

    public void onArrowHit(AbstractArrowEntity arrow) {
    }

    private boolean isArrow(ItemStack stack) {
        return stack.func_77973_b() instanceof ArrowItem;
    }

    public int getMaxDamage(ItemStack stack) {
        return this.settings.getMaxUses();
    }

    public class BowCapability
    implements ICapabilitySerializable<CompoundNBT>,
    ICapabilityProvider {
        private ItemStackHandler handler = new ItemStackHandler(4);
        private ExtraBowsEnergy energy = new ExtraBowsEnergy(30000, 50, 300);
        private LazyOptional<IItemHandler> handlerLazyOptional = LazyOptional.of(() -> this.handler);
        private LazyOptional<IEnergyStorage> energyStorage = LazyOptional.of(() -> this.energy);
        private ItemStack stack;

        public BowCapability(ItemStack stack) {
            this.stack = stack;
        }

        public BowCapability(ExtraBowsEnergy energy, ItemStack stack) {
            this.energy = energy;
            this.stack = stack;
        }

        @Nullable
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return this.handlerLazyOptional.cast();
            }
            if (capability == CapabilityEnergy.ENERGY && BasicBow.this.isElectric(UpgradeUtil.getUpgradesFromStack(this.stack), this.stack)) {
                return this.energyStorage.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_218657_a("handler", (INBT)this.handler.serializeNBT());
            nbt.func_74768_a("capacity", this.energy.getMaxEnergyStored());
            nbt.func_74768_a("energy", this.energy.getEnergyStored());
            return nbt;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.handler.deserializeNBT(nbt.func_74775_l("handler"));
            this.energy.setCapacity(nbt.func_74762_e("capacity"));
            this.energy.setEnergy(nbt.func_74762_e("energy"));
        }
    }
}

