/*
 * Decompiled with CFR 0.152.
 */
package me.marnic.extrabows.api.upgrade;

import java.util.List;
import java.util.stream.Stream;
import me.marnic.extrabows.api.energy.ExtraBowsEnergy;
import me.marnic.extrabows.api.upgrade.ArrowModifierUpgrade;
import me.marnic.extrabows.api.upgrade.ArrowMultiplierUpgrade;
import me.marnic.extrabows.api.upgrade.UpgradeList;
import me.marnic.extrabows.api.util.ArrowUtil;
import me.marnic.extrabows.api.util.RandomUtil;
import me.marnic.extrabows.api.util.TimeCommand;
import me.marnic.extrabows.api.util.TimerUtil;
import me.marnic.extrabows.api.util.UpgradeUtil;
import me.marnic.extrabows.common.config.ExtraBowsConfig;
import me.marnic.extrabows.common.items.BasicBow;
import me.marnic.extrabows.common.upgrades.BridgeUpgrade;
import me.marnic.extrabows.common.upgrades.ElectricUpgrade;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.passive.SnowGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class Upgrades {
    public static ArrowMultiplierUpgrade DOUBLE_UPGRADE;
    public static ArrowMultiplierUpgrade TRIPLE_UPGRADE;
    public static ArrowModifierUpgrade LIGHTNING_UPGRADE;
    public static ArrowModifierUpgrade FIRE_UPGRADE;
    public static ArrowModifierUpgrade ENDER_UPGRADE;
    public static ArrowModifierUpgrade FREEZE_UPGRADE;
    public static ArrowModifierUpgrade EXPLOSIVE_UPGRADE;
    public static ArrowModifierUpgrade WATER_UPGRADE;
    public static ArrowModifierUpgrade BRIDGE_UPGRADE;
    public static ArrowModifierUpgrade PUSH_UPGRADE;
    public static ArrowModifierUpgrade FLYING_UPGRADE;
    public static ArrowModifierUpgrade METEOR_UPGRADE;
    public static ArrowModifierUpgrade HEAL_FROM_DAMAGE;
    public static ArrowModifierUpgrade ARROW_COST;
    public static ArrowModifierUpgrade ELECTRIC_UPGRADE;

    public static void init() {
        DOUBLE_UPGRADE = new ArrowMultiplierUpgrade("double_upgrade"){

            @Override
            public void handleAction(BasicBow basicBow, World worldIn, ItemStack bow, PlayerEntity entityplayer, float f, ItemStack arrow, boolean flag1, UpgradeList list, boolean isLoaded) {
                if (arrow.func_190916_E() >= 2 || flag1 || isLoaded) {
                    AbstractArrowEntity entityarrow2 = ArrowUtil.createArrowComplete(worldIn, bow, arrow, entityplayer, basicBow, f, flag1, 0.0f, 2.5f, list, isLoaded);
                    worldIn.func_217376_c((Entity)entityarrow2);
                    AbstractArrowEntity entityarrow1 = ArrowUtil.createArrowComplete(worldIn, bow, arrow, entityplayer, basicBow, f, flag1, 0.0f, -2.5f, list, isLoaded);
                    worldIn.func_217376_c((Entity)entityarrow1);
                } else {
                    AbstractArrowEntity entityarrow = ArrowUtil.createArrowComplete(worldIn, bow, arrow, entityplayer, basicBow, f, flag1, 0.0f, 0.0f, list, isLoaded);
                    worldIn.func_217376_c((Entity)entityarrow);
                }
            }

            @Override
            public void shrinkStack(ItemStack stack) {
                stack.func_190918_g(stack.func_190916_E() >= 2 ? 2 : 1);
            }

            @Override
            public void removeEnergy(ItemStack stack, ExtraBowsEnergy extraBowsEnergy) {
                extraBowsEnergy.extractEnergy(200, false);
            }

            @Override
            public boolean canShoot(ItemStack arrow, PlayerEntity player) {
                return arrow.func_190916_E() >= 2;
            }

            @Override
            public List<ITextComponent> getDescription() {
                return UpgradeUtil.createDescriptionFromStingList(UpgradeUtil.getTranslatedDescriptionForUpgrade(this));
            }

            @Override
            public void initConfigOptions() {
                this.getItem().setMaxDamage((Integer)ExtraBowsConfig.DURABILITY_DOUBLE_UPGRADE.get());
            }
        };
        TRIPLE_UPGRADE = new ArrowMultiplierUpgrade("triple_upgrade"){

            @Override
            public void handleAction(BasicBow basicBow, World worldIn, ItemStack bow, PlayerEntity entityplayer, float f, ItemStack arrow, boolean flag1, UpgradeList list, boolean isLoaded) {
                if (arrow.func_190916_E() >= 3 || flag1 || isLoaded) {
                    AbstractArrowEntity entityarrow1 = ArrowUtil.createArrowComplete(worldIn, bow, arrow, entityplayer, basicBow, f, flag1, 0.0f, 2.5f, list, isLoaded);
                    worldIn.func_217376_c((Entity)entityarrow1);
                    AbstractArrowEntity entityarrow2 = ArrowUtil.createArrowComplete(worldIn, bow, arrow, entityplayer, basicBow, f, flag1, 0.0f, 0.0f, list, isLoaded);
                    worldIn.func_217376_c((Entity)entityarrow2);
                    AbstractArrowEntity entityarrow3 = ArrowUtil.createArrowComplete(worldIn, bow, arrow, entityplayer, basicBow, f, flag1, 0.0f, -2.5f, list, isLoaded);
                    worldIn.func_217376_c((Entity)entityarrow3);
                } else if (arrow.func_190916_E() == 2) {
                    DOUBLE_UPGRADE.handleAction(basicBow, worldIn, bow, entityplayer, f, arrow, flag1, list, isLoaded);
                } else {
                    AbstractArrowEntity entityarrow = ArrowUtil.createArrowComplete(worldIn, bow, arrow, entityplayer, basicBow, f, flag1, 0.0f, 0.0f, list, isLoaded);
                    worldIn.func_217376_c((Entity)entityarrow);
                }
            }

            @Override
            public void shrinkStack(ItemStack stack) {
                stack.func_190918_g(stack.func_190916_E() >= 3 ? 3 : (stack.func_190916_E() >= 2 ? 2 : 1));
            }

            @Override
            public void removeEnergy(ItemStack stack, ExtraBowsEnergy extraBowsEnergy) {
                extraBowsEnergy.extractEnergy(300, false);
            }

            @Override
            public boolean canShoot(ItemStack arrow, PlayerEntity player) {
                return arrow.func_190916_E() >= 3;
            }

            @Override
            public List<ITextComponent> getDescription() {
                return UpgradeUtil.createDescriptionFromStingList(UpgradeUtil.getTranslatedDescriptionForUpgrade(this));
            }

            @Override
            public void initConfigOptions() {
                this.getItem().setMaxDamage((Integer)ExtraBowsConfig.DURABILITY_TRIPLE_UPGRADE.get());
            }
        };
        LIGHTNING_UPGRADE = new ArrowModifierUpgrade("lightning_upgrade"){

            @Override
            public void handleBlockHit(BlockPos pos, World world, PlayerEntity player, AbstractArrowEntity arrow, UpgradeList upgradeList) {
                LightningBoltEntity lightningBoltEntity = new LightningBoltEntity(EntityType.field_200728_aG, world);
                lightningBoltEntity.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                ((ServerWorld)world).func_217376_c((Entity)lightningBoltEntity);
                arrow.func_70106_y();
            }

            @Override
            public void handleEntityHit(Entity entity, World world, PlayerEntity player, AbstractArrowEntity arrow, UpgradeList upgradeList) {
                LightningBoltEntity lightningBoltEntity = new LightningBoltEntity(EntityType.field_200728_aG, world);
                lightningBoltEntity.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
                ((ServerWorld)world).func_217376_c((Entity)lightningBoltEntity);
                arrow.func_70106_y();
            }

            @Override
            public void handleArrowCreate(AbstractArrowEntity arrow, PlayerEntity player, UpgradeList upgradeList) {
                arrow.func_70015_d(10000);
            }

            @Override
            public List<ITextComponent> getDescription() {
                return UpgradeUtil.createDescriptionFromStingList(UpgradeUtil.getTranslatedDescriptionForUpgrade(this));
            }

            @Override
            public void initConfigOptions() {
                this.getItem().setMaxDamage((Integer)ExtraBowsConfig.DURABILITY_LIGHTNING_UPGRADE.get());
            }
        };
        FIRE_UPGRADE = new ArrowModifierUpgrade("fire_upgrade"){

            @Override
            public void handleBlockHit(BlockPos pos, World world, PlayerEntity player, AbstractArrowEntity arrow, UpgradeList upgradeList) {
                if (world.func_175623_d(pos = pos.func_177982_a(0, 1, 0))) {
                    world.func_180501_a(pos, Blocks.field_150480_ab.func_176223_P(), 11);
                }
            }

            @Override
            public void handleEntityHit(Entity entity, World world, PlayerEntity player, AbstractArrowEntity arrow, UpgradeList upgradeList) {
                entity.func_70015_d(5);
            }

            @Override
            public void handleArrowCreate(AbstractArrowEntity arrow, PlayerEntity player, UpgradeList upgradeList) {
                arrow.func_70015_d(10000);
            }

            @Override
            public List<ITextComponent> getDescription() {
                return UpgradeUtil.createDescriptionFromStingList(UpgradeUtil.getTranslatedDescriptionForUpgrade(this, 1), UpgradeUtil.getTranslatedDescriptionForUpgrade(this, 2));
            }

            @Override
            public void initConfigOptions() {
                this.getItem().setMaxDamage((Integer)ExtraBowsConfig.DURABILITY_FIRE_UPGRADE.get());
            }
        };
        ENDER_UPGRADE = new ArrowModifierUpgrade("ender_upgrade"){

            @Override
            public void handleBlockHit(BlockPos pos, World world, PlayerEntity player, AbstractArrowEntity arrow, UpgradeList upgradeList) {
                player.func_70634_a((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
            }

            @Override
            public void handleEntityHit(Entity entity, World world, PlayerEntity player, AbstractArrowEntity arrow, UpgradeList upgradeList) {
                player.func_70634_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
            }

            @Override
            public List<ITextComponent> getDescription() {
                return UpgradeUtil.createDescriptionFromStingList(UpgradeUtil.getTranslatedDescriptionForUpgrade(this));
            }

            @Override
            public void initConfigOptions() {
                this.getItem().setMaxDamage((Integer)ExtraBowsConfig.DURABILITY_ENDER_UPGRADE.get());
            }
        };
        FREEZE_UPGRADE = new ArrowModifierUpgrade("freeze_upgrade"){

            @Override
            public void handleBlockHit(BlockPos pos, World world, PlayerEntity player, AbstractArrowEntity arrow, UpgradeList upgradeList) {
                if (world.func_175623_d(pos = pos.func_177982_a(0, 1, 0))) {
                    world.func_175656_a(pos, Blocks.field_150433_aE.func_176223_P());
                    if (RandomUtil.isChance(8, 1)) {
                        SnowGolemEntity snowman = new SnowGolemEntity(EntityType.field_200745_ak, world);
                        snowman.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                        world.func_217376_c((Entity)snowman);
                    }
                }
            }

            @Override
            public void handleEntityHit(Entity entity, World world, PlayerEntity player, AbstractArrowEntity arrow, UpgradeList upgradeList) {
                if (entity instanceof LivingEntity) {
                    ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76421_d, 200, 1));
                }
            }

            @Override
            public void handleWaterHit(BlockPos pos, World world, PlayerEntity player, AbstractArrowEntity arrow, UpgradeList upgradeList) {
                if (world.func_180495_p(pos).func_177230_c().equals(Blocks.field_150355_j)) {
                    world.func_175656_a(pos, Blocks.field_150403_cj.func_176223_P());
                }
                UpgradeUtil.getBlocksInRadius(pos, 2).forEach(pos1 -> {
                    if ((world.func_180495_p(pos1).func_177230_c().equals(Blocks.field_150355_j) || world.func_180495_p(pos1).func_177230_c().equals(Blocks.field_150355_j)) && world.func_175623_d(pos1.func_177984_a())) {
                        if (RandomUtil.isChance(2, 1)) {
                            world.func_175656_a(pos1, Blocks.field_150403_cj.func_176223_P());
                        }
                        if (RandomUtil.isChance(2, 1) && world.func_175623_d(pos1.func_177984_a().func_177984_a())) {
                            world.func_175656_a(pos1.func_177984_a(), Blocks.field_150433_aE.func_176223_P());
                        }
                    }
                });
            }

            @Override
            public List<ITextComponent> getDescription() {
                return UpgradeUtil.createDescriptionFromStingList(UpgradeUtil.getTranslatedDescriptionForUpgrade(this));
            }

            @Override
            public void initConfigOptions() {
                this.getItem().setMaxDamage((Integer)ExtraBowsConfig.DURABILITY_FREEZE_UPGRADE.get());
            }
        };
        EXPLOSIVE_UPGRADE = new ArrowModifierUpgrade("explosive_upgrade"){

            @Override
            public void handleBlockHit(BlockPos pos, World world, PlayerEntity player, AbstractArrowEntity arrow, UpgradeList upgradeList) {
                world.func_217385_a((Entity)player, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 3.0f, Explosion.Mode.DESTROY);
                arrow.func_70106_y();
            }

            @Override
            public void handleEntityHit(Entity entity, World world, PlayerEntity player, AbstractArrowEntity arrow, UpgradeList upgradeList) {
                world.func_217385_a((Entity)player, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 3.0f, Explosion.Mode.DESTROY);
                arrow.func_70106_y();
            }

            @Override
            public List<ITextComponent> getDescription() {
                return UpgradeUtil.createDescriptionFromStingList(UpgradeUtil.getTranslatedDescriptionForUpgrade(this));
            }

            @Override
            public void initConfigOptions() {
                this.getItem().setMaxDamage((Integer)ExtraBowsConfig.DURABILITY_EXPLOSIVE_UPGRADE.get());
            }
        };
        HEAL_FROM_DAMAGE = new ArrowModifierUpgrade("heal_from_damage_upgrade"){

            @Override
            public void handleEntityHit(Entity entity, World world, PlayerEntity player, AbstractArrowEntity arrow, UpgradeList upgradeList) {
                if (entity instanceof LivingEntity && RandomUtil.isChance(3, 1)) {
                    player.func_70691_i(0.5f);
                }
            }

            @Override
            public List<ITextComponent> getDescription() {
                return UpgradeUtil.createDescriptionFromStingList(UpgradeUtil.getTranslatedDescriptionForUpgrade(this));
            }

            @Override
            public void initConfigOptions() {
                this.getItem().setMaxDamage((Integer)ExtraBowsConfig.DURABILITY_HEAL_FROM_DAMAGE_UPGRADE.get());
            }
        };
        ARROW_COST = new ArrowModifierUpgrade("arrow_cost_upgrade"){

            @Override
            public void handleArrowCreate(AbstractArrowEntity arrow, PlayerEntity player, UpgradeList upgradeList) {
                if (RandomUtil.isChance(8, 1) && !player.func_191521_c(new ItemStack((IItemProvider)Items.field_151032_g, 1))) {
                    player.func_71019_a(new ItemStack((IItemProvider)Items.field_151032_g, 1), true);
                }
            }

            @Override
            public List<ITextComponent> getDescription() {
                return UpgradeUtil.createDescriptionFromStingList(UpgradeUtil.getTranslatedDescriptionForUpgrade(this));
            }

            @Override
            public void initConfigOptions() {
                this.getItem().setMaxDamage((Integer)ExtraBowsConfig.DURABILITY_ARROW_COST_UPGRADE.get());
            }
        };
        WATER_UPGRADE = new ArrowModifierUpgrade("water_upgrade"){

            @Override
            public void handleBlockHit(BlockPos pos, World world, PlayerEntity player, AbstractArrowEntity arrow, UpgradeList upgradeList) {
                Stream<BlockPos> list = UpgradeUtil.getBlocksInRadius(pos, 3);
                list.forEach(pos1 -> {
                    if (world.func_180495_p(pos1).func_177230_c().equals(Blocks.field_150480_ab)) {
                        world.func_217377_a(pos1, false);
                    }
                });
                if (RandomUtil.isChance(6, 1) && !world.func_230315_m_().func_242725_p().equals((Object)DimensionType.field_236000_d_.getRegistryName())) {
                    world.func_175656_a(pos.func_177982_a(0, 1, 0), Blocks.field_150355_j.func_176223_P());
                    TimerUtil.addTimeCommand(new TimeCommand(100, () -> world.func_217377_a(pos.func_177982_a(0, 1, 0), false)));
                }
            }

            @Override
            public List<ITextComponent> getDescription() {
                return UpgradeUtil.createDescriptionFromStingList(UpgradeUtil.getTranslatedDescriptionForUpgrade(this, 1), UpgradeUtil.getTranslatedDescriptionForUpgrade(this, 2));
            }

            @Override
            public void initConfigOptions() {
                this.getItem().setMaxDamage((Integer)ExtraBowsConfig.DURABILITY_WATER_UPGRADE.get());
            }
        };
        PUSH_UPGRADE = new ArrowModifierUpgrade("push_upgrade"){

            @Override
            public void handleBlockHit(BlockPos pos, World world, PlayerEntity player, AbstractArrowEntity arrow, UpgradeList upgradeList) {
                world.func_217357_a(LivingEntity.class, UpgradeUtil.getRadiusBoundingBox(pos, 6)).forEach(livingEntity -> {
                    double deltaX = livingEntity.func_226277_ct_() - arrow.func_226277_ct_();
                    double deltaZ = livingEntity.func_226281_cx_() - arrow.func_226281_cx_();
                    int posX = deltaX > 0.0 ? 1 : -1;
                    int posZ = deltaZ > 0.0 ? 1 : -1;
                    deltaX = Math.abs(deltaX);
                    deltaZ = Math.abs(deltaZ);
                    double highestValue = deltaX > deltaZ ? deltaX : deltaZ;
                    livingEntity.func_70024_g((double)posX * (deltaX / highestValue), (double)0.7f, (double)posZ * (deltaZ / highestValue));
                });
            }

            @Override
            public void handleEntityHit(Entity entity, World world, PlayerEntity player, AbstractArrowEntity arrow, UpgradeList upgradeList) {
                world.func_217357_a(LivingEntity.class, UpgradeUtil.getRadiusBoundingBox(new BlockPos(entity.func_213303_ch()), 6)).forEach(livingEntity -> {
                    double deltaX = livingEntity.func_226277_ct_() - arrow.func_226277_ct_();
                    double deltaZ = livingEntity.func_226281_cx_() - arrow.func_226281_cx_();
                    int posX = deltaX > 0.0 ? 1 : -1;
                    int posZ = deltaZ > 0.0 ? 1 : -1;
                    deltaX = Math.abs(deltaX);
                    deltaZ = Math.abs(deltaZ);
                    double highestValue = deltaX > deltaZ ? deltaX : deltaZ;
                    livingEntity.func_70024_g((double)posX * (deltaX / highestValue), (double)0.7f, (double)posZ * (deltaZ / highestValue));
                });
            }

            @Override
            public List<ITextComponent> getDescription() {
                return UpgradeUtil.createDescriptionFromStingList(UpgradeUtil.getTranslatedDescriptionForUpgrade(this));
            }

            @Override
            public void initConfigOptions() {
                this.getItem().setMaxDamage((Integer)ExtraBowsConfig.DURABILITY_PUSH_UPGRADE.get());
            }
        };
        FLYING_UPGRADE = new ArrowModifierUpgrade("flying_upgrade"){

            @Override
            public void handleEntityInit(AbstractArrowEntity arrow, UpgradeList upgradeList, PlayerEntity player) {
                arrow.func_184216_O().add("flyingUpgrade");
                player.func_184220_m((Entity)arrow);
            }

            @Override
            public void handleBlockHit(BlockPos pos, World world, PlayerEntity player, AbstractArrowEntity arrow, UpgradeList upgradeList) {
                if (arrow.func_184207_aI()) {
                    player.func_70097_a(DamageSource.field_76379_h, 2.0f);
                }
            }

            @Override
            public void handleEntityHit(Entity entity, World world, PlayerEntity player, AbstractArrowEntity arrow, UpgradeList upgradeList) {
                if (arrow.func_184207_aI()) {
                    player.func_70097_a(DamageSource.field_76379_h, 2.0f);
                }
            }

            @Override
            public List<ITextComponent> getDescription() {
                return UpgradeUtil.createDescriptionFromStingList(UpgradeUtil.getTranslatedDescriptionForUpgrade(this));
            }

            @Override
            public void initConfigOptions() {
                this.getItem().setMaxDamage((Integer)ExtraBowsConfig.DURABILITY_FLY_UPGRADE.get());
            }
        };
        METEOR_UPGRADE = new ArrowModifierUpgrade("meteor_upgrade"){

            @Override
            public void handleBlockHit(BlockPos pos, World world, PlayerEntity player, AbstractArrowEntity arrow, UpgradeList upgradeList) {
                this.spawnMeteor(world, arrow);
            }

            @Override
            public void handleEntityHit(Entity entity, World world, PlayerEntity player, AbstractArrowEntity arrow, UpgradeList upgradeList) {
                this.spawnMeteor(world, arrow);
            }

            private void spawnMeteor(World world, AbstractArrowEntity arrow) {
                if (world.func_175623_d(new BlockPos(arrow.func_226277_ct_(), arrow.func_226278_cu_() + 20.0, arrow.func_226281_cx_()))) {
                    FireballEntity fireballEntity = new FireballEntity(EntityType.field_200767_G, world);
                    fireballEntity.func_70634_a(arrow.func_226277_ct_(), arrow.func_226278_cu_() + 20.0, arrow.func_226281_cx_());
                    fireballEntity.func_70024_g(0.0, -2.0, 0.0);
                    world.func_217376_c((Entity)fireballEntity);
                }
            }

            @Override
            public List<ITextComponent> getDescription() {
                return UpgradeUtil.createDescriptionFromStingList(UpgradeUtil.getTranslatedDescriptionForUpgrade(this));
            }

            @Override
            public void initConfigOptions() {
                this.getItem().setMaxDamage((Integer)ExtraBowsConfig.DURABILITY_METEOR_UPGRADE.get());
            }
        };
        ELECTRIC_UPGRADE = new ElectricUpgrade();
        BRIDGE_UPGRADE = new BridgeUpgrade();
    }
}

