/*
 * Decompiled with CFR 0.152.
 */
package me.marnic.extrabows.api.util;

import me.marnic.extrabows.api.util.TimerUtil;

public class TimeCommand {
    protected Runnable execute;
    private int endTick;
    private int startTick = TimerUtil.currentTicks;
    private int id;

    public TimeCommand(int time, Runnable execute, int id) {
        this.endTick = this.startTick + time;
        this.execute = execute;
        this.id = id;
    }

    public TimeCommand(int time, int id) {
        this.endTick = this.startTick + time;
        this.id = id;
    }

    public TimeCommand(int time, Runnable execute) {
        this.endTick = this.startTick + time;
        this.execute = execute;
        this.id = -1;
    }

    public boolean handle(int current) {
        if (current >= this.endTick) {
            this.execute.run();
            return true;
        }
        return false;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setExecute(Runnable execute) {
        this.execute = execute;
    }

    public static class EndableTimeCommand
    extends TimeCommand {
        public boolean end = false;

        public EndableTimeCommand(int time, Runnable execute, int id) {
            super(time, execute, id);
        }

        public EndableTimeCommand(int time, int id) {
            super(time, id);
        }

        @Override
        public boolean handle(int current) {
            boolean a = this.end;
            this.execute.run();
            return a;
        }

        public void setEnd(boolean end) {
            this.end = end;
        }
    }
}

