/*
 * Decompiled with CFR 0.152.
 */
package me.marnic.extrabows.common.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class ExtraBowsConfig {
    public static ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static BowConfig STONE_BOW = new BowConfig("STONE_BOW", 434, 3.0f, 1.0f, 1.0f, 18.0f, BUILDER);
    public static BowConfig IRON_BOW = new BowConfig("IRON_BOW", 534, 3.5f, 2.0f, 1.0f, 16.0f, BUILDER);
    public static BowConfig GOLD_BOW = new BowConfig("GOLD_BOW", 300, 4.25f, 0.0f, 0.5f, 10.0f, BUILDER);
    public static BowConfig DIAMOND_BOW = new BowConfig("DIAMOND_BOW", 750, 3.75f, 5.0f, 1.0f, 15.0f, BUILDER);
    public static BowConfig EMERALD_BOW = new BowConfig("EMERALD_BOW", 1500, 4.0f, 8.0f, 1.0f, 15.0f, BUILDER);
    public static BowConfig ELECTRIC_BOW = BowConfig.copy("ELECTRIC_BOW", IRON_BOW, BUILDER);
    public static ForgeConfigSpec.IntValue DURABILITY_DOUBLE_UPGRADE = BUILDER.defineInRange("DURABILITY_DOUBLE_UPGRADE", 400, 1, Integer.MAX_VALUE);
    public static ForgeConfigSpec.IntValue DURABILITY_TRIPLE_UPGRADE = BUILDER.defineInRange("DURABILITY_TRIPLE_UPGRADE", 400, 1, Integer.MAX_VALUE);
    public static ForgeConfigSpec.IntValue DURABILITY_ARROW_COST_UPGRADE = BUILDER.defineInRange("DURABILITY_ARROW_COST_UPGRADE", 400, 1, Integer.MAX_VALUE);
    public static ForgeConfigSpec.IntValue DURABILITY_HEAL_FROM_DAMAGE_UPGRADE = BUILDER.defineInRange("DURABILITY_HEAL_FROM_DAMAGE_UPGRADE", 400, 1, Integer.MAX_VALUE);
    public static ForgeConfigSpec.IntValue DURABILITY_FIRE_UPGRADE = BUILDER.defineInRange("DURABILITY_FIRE_UPGRADE", 400, 1, Integer.MAX_VALUE);
    public static ForgeConfigSpec.IntValue DURABILITY_FREEZE_UPGRADE = BUILDER.defineInRange("DURABILITY_FREEZE_UPGRADE", 400, 1, Integer.MAX_VALUE);
    public static ForgeConfigSpec.IntValue DURABILITY_WATER_UPGRADE = BUILDER.defineInRange("DURABILITY_WATER_UPGRADE", 400, 1, Integer.MAX_VALUE);
    public static ForgeConfigSpec.IntValue DURABILITY_BRIDGE_UPGRADE = BUILDER.defineInRange("DURABILITY_BRIDGE_UPGRADE", 400, 1, Integer.MAX_VALUE);
    public static ForgeConfigSpec.IntValue DURABILITY_ENDER_UPGRADE = BUILDER.defineInRange("DURABILITY_ENDER_UPGRADE", 400, 1, Integer.MAX_VALUE);
    public static ForgeConfigSpec.IntValue DURABILITY_LIGHTNING_UPGRADE = BUILDER.defineInRange("DURABILITY_LIGHTNING_UPGRADE", 400, 1, Integer.MAX_VALUE);
    public static ForgeConfigSpec.IntValue DURABILITY_EXPLOSIVE_UPGRADE = BUILDER.defineInRange("DURABILITY_EXPLOSIVE_UPGRADE", 400, 1, Integer.MAX_VALUE);
    public static ForgeConfigSpec.IntValue DURABILITY_PUSH_UPGRADE = BUILDER.defineInRange("DURABILITY_PUSH_UPGRADE", 400, 1, Integer.MAX_VALUE);
    public static ForgeConfigSpec.IntValue DURABILITY_FLY_UPGRADE = BUILDER.defineInRange("DURABILITY_FLY_UPGRADE", 400, 1, Integer.MAX_VALUE);
    public static ForgeConfigSpec.IntValue DURABILITY_METEOR_UPGRADE = BUILDER.defineInRange("DURABILITY_METEOR_UPGRADE", 400, 1, Integer.MAX_VALUE);
    public static ForgeConfigSpec.IntValue DURABILITY_ENERGY_UPGRADE = BUILDER.defineInRange("DURABILITY_ENERGY_UPGRADE", 400, 1, Integer.MAX_VALUE);
    public static ForgeConfigSpec SPEC = BUILDER.build();

    public static class BowConfig {
        public ForgeConfigSpec.ConfigValue<Integer> durability;
        public ForgeConfigSpec.DoubleValue velocityMultiplier;
        public ForgeConfigSpec.DoubleValue inaccuracy;
        public ForgeConfigSpec.DoubleValue time;
        public ForgeConfigSpec.DoubleValue damage;
        private int defaultDurability;
        private float defaultVelocityMultiplier;
        private float defaultInaccuracy;
        private float defaultTime;
        private float defaultDamage;

        public BowConfig(String name, int durability, float velocityMultiplier, float damage, float inaccuracy, float time, ForgeConfigSpec.Builder builder) {
            builder.push(name);
            this.durability = builder.define("durability", (Object)durability);
            this.velocityMultiplier = builder.defineInRange("velocityMultiplier", (double)velocityMultiplier, 0.0, Double.MAX_VALUE);
            this.inaccuracy = builder.defineInRange("inaccuracy", (double)inaccuracy, 0.0, Double.MAX_VALUE);
            this.time = builder.defineInRange("time", (double)time, 0.0, Double.MAX_VALUE);
            this.damage = builder.defineInRange("damage", (double)damage, 0.0, Double.MAX_VALUE);
            this.defaultDurability = durability;
            this.defaultVelocityMultiplier = velocityMultiplier;
            this.defaultInaccuracy = inaccuracy;
            this.defaultTime = time;
            this.defaultDamage = damage;
            builder.pop();
        }

        public static BowConfig copy(String name, BowConfig from, ForgeConfigSpec.Builder builder) {
            return new BowConfig(name, from.defaultDurability, from.defaultVelocityMultiplier, from.defaultDamage, from.defaultInaccuracy, from.defaultTime, builder);
        }
    }
}

