/*
 * Decompiled with CFR 0.152.
 */
package me.marnic.extrabows.common.events;

import me.marnic.extrabows.api.upgrade.ArrowModifierUpgrade;
import me.marnic.extrabows.api.upgrade.UpgradeList;
import me.marnic.extrabows.api.upgrade.Upgrades;
import me.marnic.extrabows.api.util.ArrowUtil;
import me.marnic.extrabows.api.util.TimeCommand;
import me.marnic.extrabows.api.util.TimerUtil;
import me.marnic.extrabows.api.util.UpgradeUtil;
import me.marnic.extrabows.client.input.ExtraBowsInputHandler;
import me.marnic.extrabows.common.items.BasicBow;
import me.marnic.extrabows.common.main.ExtraBowsObjects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ExtraBowsEventHandler {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void keyInput(InputEvent.KeyInputEvent e) {
        ExtraBowsInputHandler.handleKeyPressedEvent(e);
    }

    @SubscribeEvent
    public static void worldTickEvent(TickEvent.ServerTickEvent event) {
        TimerUtil.handleTickEvent(event);
    }

    @SubscribeEvent
    public static void blockbreak(BlockEvent.BreakEvent e) {
        if (e.getState().func_177230_c().equals((Object)ExtraBowsObjects.BRIDGE_BLOCK)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void itemCrafted(final PlayerEvent.ItemCraftedEvent e) {
        if (e.getCrafting().func_77973_b().equals(Upgrades.LIGHTNING_UPGRADE.getItem())) {
            for (int i = 1; i < 14; ++i) {
                TimerUtil.addTimeCommand(new TimeCommand(20 * i, new Runnable(){

                    @Override
                    public void run() {
                        LightningBoltEntity lightningBoltEntity = new LightningBoltEntity(EntityType.field_200728_aG, e.getPlayer().field_70170_p);
                        lightningBoltEntity.func_70107_b(e.getPlayer().func_226277_ct_(), e.getPlayer().func_226278_cu_(), e.getPlayer().func_226281_cx_());
                        ((ServerWorld)e.getPlayer().field_70170_p).func_217376_c((Entity)lightningBoltEntity);
                    }
                }));
            }
        }
    }

    @SubscribeEvent
    public static void projectileHit(ProjectileImpactEvent.Arrow e) {
        AbstractArrowEntity arrow;
        if (e.getRayTraceResult().func_216346_c() != RayTraceResult.Type.MISS && e.getEntity() instanceof ArrowEntity && (arrow = (AbstractArrowEntity)e.getEntity()).func_234616_v_() instanceof PlayerEntity && UpgradeUtil.isExtraBowsArrow((Entity)arrow)) {
            PlayerEntity player = (PlayerEntity)arrow.func_234616_v_();
            if (e.getRayTraceResult().func_216346_c() == RayTraceResult.Type.ENTITY) {
                EntityRayTraceResult trace = (EntityRayTraceResult)e.getRayTraceResult();
                if (arrow.func_234616_v_().equals((Object)trace.func_216348_a()) && arrow.func_184216_O().contains("flyingUpgrade")) {
                    e.setCanceled(true);
                }
            }
            if (!arrow.getPersistentData().func_74767_n("alreadyHit")) {
                arrow.getPersistentData().func_74757_a("alreadyHit", true);
                UpgradeList list = ArrowUtil.ARROWS_TO_UPGRADES.get(arrow.func_110124_au());
                if (list != null) {
                    BlockRayTraceResult trace;
                    if (e.getRayTraceResult().func_216346_c() == RayTraceResult.Type.BLOCK) {
                        trace = (BlockRayTraceResult)e.getRayTraceResult();
                        list.handleModifierHittingEvent(ArrowModifierUpgrade.EventType.BLOCK_HIT, trace.func_216350_a(), null, e.getEntity().field_70170_p, player, arrow);
                        list.getBasicBow().onArrowHit(arrow);
                    } else if (e.getRayTraceResult().func_216346_c() == RayTraceResult.Type.ENTITY) {
                        trace = (EntityRayTraceResult)e.getRayTraceResult();
                        list.handleModifierHittingEvent(ArrowModifierUpgrade.EventType.ENTITY_HIT, null, trace.func_216348_a(), e.getEntity().field_70170_p, player, arrow);
                        list.getBasicBow().onArrowHit(arrow);
                    }
                    ArrowUtil.ARROWS_TO_UPGRADES.remove(arrow.func_110124_au());
                    TimeCommand.EndableTimeCommand command = (TimeCommand.EndableTimeCommand)TimerUtil.forId(arrow.func_145782_y());
                    if (command != null) {
                        command.setEnd(true);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void arrowConstructing(final EntityJoinWorldEvent e) {
        AbstractArrowEntity arrow;
        if (!e.getWorld().field_72995_K && e.getEntity() instanceof AbstractArrowEntity && UpgradeUtil.isExtraBowsArrow(e.getEntity()) && (arrow = (AbstractArrowEntity)e.getEntity()).func_234616_v_() instanceof PlayerEntity) {
            ItemStack bow = ((PlayerEntity)arrow.func_234616_v_()).func_184614_ca();
            if (!(bow.func_77973_b() instanceof BasicBow)) {
                return;
            }
            final UpgradeList list = UpgradeUtil.getUpgradesFromStack(bow);
            ArrowUtil.ARROWS_TO_UPGRADES.put(arrow.func_110124_au(), list);
            final TimeCommand.EndableTimeCommand command = new TimeCommand.EndableTimeCommand(0, arrow.func_145782_y());
            command.setExecute(new Runnable(){
                boolean prevWater = false;

                @Override
                public void run() {
                    if (arrow.func_70090_H() && !this.prevWater) {
                        list.handleModifierHittingEvent(ArrowModifierUpgrade.EventType.WATER_HIT, new BlockPos(arrow.func_213303_ch()), null, e.getWorld(), (PlayerEntity)arrow.func_234616_v_(), arrow);
                    }
                    if (!arrow.getPersistentData().func_74767_n("alreadyHit")) {
                        list.handleOnUpdatedEvent(arrow, arrow.field_70170_p);
                    } else {
                        command.setEnd(true);
                    }
                    this.prevWater = arrow.func_70090_H();
                }
            });
            TimerUtil.addTimeCommand(command);
            list.handleModifierEvent(ArrowModifierUpgrade.EventType.ENTITY_INIT, arrow, (PlayerEntity)arrow.func_234616_v_(), bow);
        }
    }
}

