/*
 * Decompiled with CFR 0.152.
 */
package me.marnic.extrabows.common.main;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import me.marnic.extrabows.api.item.ConfigLoad;
import me.marnic.extrabows.api.upgrade.Upgrades;
import me.marnic.extrabows.common.config.ExtraBowsConfig;
import me.marnic.extrabows.common.events.ExtraBowsEventHandler;
import me.marnic.extrabows.common.items.BowSettings;
import me.marnic.extrabows.common.main.ExtraBowsObjects;
import me.marnic.extrabows.common.packet.ExtraBowsPacketHandler;
import me.marnic.extrabows.common.recipes.BasicBowRecipe;
import me.marnic.extrabows.common.recipes.BasicBowShapelessRecipe;
import me.marnic.extrabows.common.registry.ExtraBowsRegistry;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.logging.log4j.core.util.ReflectionUtil;

@Mod(value="extrabows")
public class ExtraBows {
    public ExtraBows() {
        MinecraftForge.EVENT_BUS.register((Object)new ExtraBowsEventHandler());
        ExtraBowsObjects.initTab();
        Upgrades.init();
        ExtraBowsObjects.init();
        ExtraBowsPacketHandler.init();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ExtraBowsConfig.SPEC);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private static void registerRecipe(IRecipe recipe, HashMap<ResourceLocation, IRecipe> whereToRegister) {
        whereToRegister.put(recipe.func_199560_c(), recipe);
    }

    public void doClientStuff(FMLClientSetupEvent event) {
        for (ConfigLoad item : ExtraBowsRegistry.CONFIG_LOAD) {
            item.initConfigOptions();
        }
    }

    @SubscribeEvent
    public void serverStarting(FMLServerStartingEvent e) {
        HashMap<ResourceLocation, IRecipe> bowRecipes = new HashMap<ResourceLocation, IRecipe>();
        e.getServer().func_199529_aN().func_199510_b().stream().filter(r -> r.func_199560_c().func_110624_b().equalsIgnoreCase("extrabows") && r.func_199560_c().func_110623_a().contains("bow")).forEach(r -> bowRecipes.put(r.func_199560_c(), (IRecipe)r));
        try {
            Field field = this.getFieldForTypeInClass(Map.class, RecipeManager.class);
            ReflectionUtil.makeAccessible((Field)field);
            Map recipes = (Map)ReflectionUtil.getFieldValue((Field)field, (Object)e.getServer().func_199529_aN());
            HashMap recipeMut = new HashMap(recipes);
            HashMap craftingRecipesMut = new HashMap((Map)recipeMut.get(IRecipeType.field_222149_a));
            bowRecipes.forEach((k, v) -> {
                BasicBowRecipe basicBowRecipe;
                if (k.func_110623_a().contains("stone_bow")) {
                    basicBowRecipe = new BasicBowRecipe(k.func_110623_a(), (NonNullList<Ingredient>)v.func_192400_c(), new ItemStack((IItemProvider)ExtraBowsObjects.STONE_BOW), BowSettings.STONE);
                    ExtraBows.registerRecipe((IRecipe)basicBowRecipe, craftingRecipesMut);
                    ExtraBows.registerRecipe((IRecipe)new BasicBowShapelessRecipe(basicBowRecipe, ExtraBowsObjects.STONE_UPGRADE_KIT), craftingRecipesMut);
                }
                if (k.func_110623_a().contains("golden_bow")) {
                    basicBowRecipe = new BasicBowRecipe(k.func_110623_a(), (NonNullList<Ingredient>)v.func_192400_c(), new ItemStack((IItemProvider)ExtraBowsObjects.GOLD_BOW), BowSettings.GOLD);
                    ExtraBows.registerRecipe((IRecipe)basicBowRecipe, craftingRecipesMut);
                    ExtraBows.registerRecipe((IRecipe)new BasicBowShapelessRecipe(basicBowRecipe, ExtraBowsObjects.GOLD_UPGRADE_KIT), craftingRecipesMut);
                }
                if (k.func_110623_a().contains("iron_bow")) {
                    basicBowRecipe = new BasicBowRecipe(k.func_110623_a(), (NonNullList<Ingredient>)v.func_192400_c(), new ItemStack((IItemProvider)ExtraBowsObjects.IRON_BOW), BowSettings.IRON);
                    ExtraBows.registerRecipe((IRecipe)basicBowRecipe, craftingRecipesMut);
                    ExtraBows.registerRecipe((IRecipe)new BasicBowShapelessRecipe(basicBowRecipe, ExtraBowsObjects.IRON_UPGRADE_KIT), craftingRecipesMut);
                }
                if (k.func_110623_a().contains("diamond_bow")) {
                    basicBowRecipe = new BasicBowRecipe(k.func_110623_a(), (NonNullList<Ingredient>)v.func_192400_c(), new ItemStack((IItemProvider)ExtraBowsObjects.DIAMOND_BOW), BowSettings.DIAMOND);
                    ExtraBows.registerRecipe((IRecipe)basicBowRecipe, craftingRecipesMut);
                    ExtraBows.registerRecipe((IRecipe)new BasicBowShapelessRecipe(basicBowRecipe, ExtraBowsObjects.DIAMOND_UPGRADE_KIT), craftingRecipesMut);
                }
                if (k.func_110623_a().contains("emerald_bow")) {
                    basicBowRecipe = new BasicBowRecipe(k.func_110623_a(), (NonNullList<Ingredient>)v.func_192400_c(), new ItemStack((IItemProvider)ExtraBowsObjects.EMERALD_BOW), BowSettings.EMERALD);
                    ExtraBows.registerRecipe((IRecipe)basicBowRecipe, craftingRecipesMut);
                    ExtraBows.registerRecipe((IRecipe)new BasicBowShapelessRecipe(basicBowRecipe, ExtraBowsObjects.EMERALD_UPGRADE_KIT), craftingRecipesMut);
                }
            });
            recipeMut.put(IRecipeType.field_222149_a, craftingRecipesMut);
            ReflectionUtil.setFieldValue((Field)field, (Object)e.getServer().func_199529_aN(), (Object)new ImmutableMap.Builder().putAll(recipeMut).build());
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    private Field getFieldForTypeInClass(Class type, Class loc) {
        for (Field f : FieldUtils.getAllFields((Class)loc)) {
            if (!f.getType().equals(type)) continue;
            return f;
        }
        return null;
    }
}

