/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.main.Config;
import com.golems.util.WeightedItem;
import java.util.List;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EntityBookshelfGolem
extends GolemBase {
    public static final String ALLOW_SPECIAL = "Allow Special: Potion Effects";
    private Potion[] goodEffects = new Potion[]{MobEffects.field_76426_n, MobEffects.field_76428_l, MobEffects.field_76420_g, MobEffects.field_76444_x, MobEffects.field_188425_z, MobEffects.field_76432_h, MobEffects.field_76429_m, MobEffects.field_76441_p, MobEffects.field_76424_c, MobEffects.field_76430_j};

    public EntityBookshelfGolem(World world) {
        super(world, Config.BOOKSHELF.getBaseAttack(), Blocks.field_150342_X);
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityBookshelfGolem.makeGolemTexture("books");
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (Config.BOOKSHELF.getBoolean(ALLOW_SPECIAL) && this.func_70651_bq().isEmpty() && this.field_70146_Z.nextInt(40) == 0) {
            Potion potion = this.goodEffects[this.field_70146_Z.nextInt(this.goodEffects.length)];
            int len = potion.func_76403_b() ? 1 : 200 + 100 * (1 + this.field_70146_Z.nextInt(5));
            this.func_70690_d(new PotionEffect(potion, len, this.field_70146_Z.nextInt(2)));
        }
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Config.BOOKSHELF.getMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.29);
    }

    @Override
    public void addGolemDrops(List<WeightedItem> dropList, boolean recentlyHit, int lootingLevel) {
        int size = 4 + this.field_70146_Z.nextInt(6 + lootingLevel);
        this.addDrop(dropList, new ItemStack(Items.field_151122_aG, size), 100);
        this.addDrop(dropList, Blocks.field_150344_f, 0, 3, 12, 75);
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187897_gY;
    }
}

