/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.main.Config;
import com.golems.util.WeightedItem;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EntityLapisGolem
extends GolemBase {
    public static final String ALLOW_SPECIAL = "Allow Special: Potion Effects";
    private Potion[] badEffects = new Potion[]{MobEffects.field_76440_q, MobEffects.field_76421_d, MobEffects.field_76436_u, MobEffects.field_76433_i, MobEffects.field_76437_t, MobEffects.field_82731_v, MobEffects.field_189112_A, MobEffects.field_188423_x};

    public EntityLapisGolem(World world) {
        super(world, Config.LAPIS.getBaseAttack(), Blocks.field_150368_y);
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityLapisGolem.makeGolemTexture("lapis");
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn) && entityIn instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)entityIn;
            if (Config.LAPIS.getBoolean(ALLOW_SPECIAL)) {
                Potion potionID = entity.func_70662_br() ? MobEffects.field_76432_h : this.badEffects[this.field_70146_Z.nextInt(this.badEffects.length)];
                int len = potionID.func_76403_b() ? 1 : 20 * (3 + this.field_70146_Z.nextInt(6));
                int amp = potionID.func_76403_b() ? this.field_70146_Z.nextInt(2) : this.field_70146_Z.nextInt(3);
                entity.func_70690_d(new PotionEffect(potionID, len, amp));
            }
            return true;
        }
        return false;
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Config.LAPIS.getMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.28);
    }

    @Override
    public void addGolemDrops(List<WeightedItem> dropList, boolean recentlyHit, int lootingLevel) {
        int size = 8 + this.field_70146_Z.nextInt(10) + lootingLevel * 4;
        this.addDrop(dropList, new ItemStack(Items.field_151100_aR, size, EnumDyeColor.BLUE.func_176767_b()), 100);
        this.addDrop(dropList, Items.field_151043_k, 0, 1, 1 + lootingLevel, 8 + lootingLevel * 30);
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187902_gb;
    }
}

