/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.entity.GolemMultiTextured;
import com.golems.entity.ai.EntityAIPlaceRandomBlocksStrictly;
import com.golems.main.Config;
import com.golems.util.WeightedItem;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EntityMushroomGolem
extends GolemMultiTextured {
    public static final String ALLOW_SPECIAL = "Allow Special: Plant Mushrooms";
    public static final String FREQUENCY = "Mushroom Frequency";
    public static final String shroomPrefix = "shroom";
    public static final String[] shroomTypes = new String[]{"red", "brown"};
    public final IBlockState[] mushrooms = new IBlockState[]{Blocks.field_150338_P.func_176223_P(), Blocks.field_150337_Q.func_176223_P()};
    public final Block[] soils = new Block[]{Blocks.field_150346_d, Blocks.field_150349_c, Blocks.field_150391_bh};

    public EntityMushroomGolem(World world) {
        super(world, Config.MUSHROOM.getBaseAttack(), new ItemStack(Blocks.field_150419_aX), shroomPrefix, shroomTypes);
        this.setCanSwim(true);
        int freq = Config.MUSHROOM.getInt(FREQUENCY);
        boolean allowed = Config.MUSHROOM.getBoolean(ALLOW_SPECIAL);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPlaceRandomBlocksStrictly((GolemBase)this, freq, this.mushrooms, this.soils, allowed));
    }

    @Override
    public String getModId() {
        return "golems";
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Config.MUSHROOM.getMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
    }

    @Override
    public void addGolemDrops(List<WeightedItem> dropList, boolean recentlyHit, int lootingLevel) {
        int size = 4 + this.field_70146_Z.nextInt(6 + lootingLevel * 2);
        BlockBush shroom = this.field_70146_Z.nextBoolean() ? Blocks.field_150337_Q : Blocks.field_150338_P;
        this.addDrop(dropList, new ItemStack((Block)shroom, size), 100);
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187579_bV;
    }
}

