/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.blocks.BlockPowerProvider;
import com.golems.entity.GolemBase;
import com.golems.events.RedstoneGolemPowerEvent;
import com.golems.main.Config;
import com.golems.main.GolemItems;
import com.golems.util.WeightedItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityRedstoneGolem
extends GolemBase {
    public static final String ALLOW_SPECIAL = "Allow Special: Redstone Power";
    public static final String POWER = "Redstone Power Level";
    private int powerLevel;
    protected boolean CAN_POWER;
    protected int tickDelay;

    public EntityRedstoneGolem(World world) {
        this(world, Config.REDSTONE.getBaseAttack(), Blocks.field_150451_bX, Config.REDSTONE.getInt(POWER), Config.REDSTONE.getBoolean(ALLOW_SPECIAL));
    }

    public EntityRedstoneGolem(World world, float attack, Block pick, int defPower, boolean CONFIG_ALLOWS_POWERING) {
        super(world, attack, pick);
        this.powerLevel = defPower;
        this.CAN_POWER = CONFIG_ALLOWS_POWERING;
        this.tickDelay = 2;
    }

    public EntityRedstoneGolem(World world, float attack, int defPower, boolean CONFIG_ALLOWS_POWERING) {
        this(world, attack, GolemItems.golemHead, defPower, CONFIG_ALLOWS_POWERING);
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityRedstoneGolem.makeGolemTexture("redstone");
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Config.REDSTONE.getMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.CAN_POWER && (this.tickDelay <= 1 || this.field_70173_aa % this.tickDelay == 0)) {
            this.placePowerNearby();
        }
    }

    protected int placePowerNearby() {
        ArrayList powerPos = new ArrayList(4);
        int numPlaced = 0;
        for (int k = -1; k < 3; ++k) {
            BlockPos at = this.func_180425_c().func_177981_b(k);
            if (this.field_70170_p.func_180495_p(at).func_177230_c() instanceof BlockPowerProvider || !this.field_70170_p.func_175623_d(at)) continue;
            RedstoneGolemPowerEvent event = new RedstoneGolemPowerEvent(this, at, this.getPowerOutput(at));
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.getResult() == Event.Result.DENY || !event.placePower()) continue;
            ++numPlaced;
        }
        return numPlaced;
    }

    public int getPowerOutput(BlockPos toPlaceAt) {
        return this.powerLevel;
    }

    @Override
    public void addGolemDrops(List<WeightedItem> dropList, boolean recentlyHit, int lootingLevel) {
        int size = 8 + this.field_70146_Z.nextInt(14 + lootingLevel * 4);
        this.addDrop(dropList, new ItemStack(Items.field_151137_ax, size > 36 ? 36 : size), 100);
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187902_gb;
    }
}

