/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.main.Config;
import com.golems.util.WeightedItem;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EntitySlimeGolem
extends GolemBase {
    public static final String ALLOW_SPECIAL = "Allow Special: Extra Knockback";
    public static final String KNOCKBACK = "Knockback Factor";

    public EntitySlimeGolem(World world) {
        super(world, Config.SLIME.getBaseAttack(), Blocks.field_180399_cE);
        this.setCanSwim(true);
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntitySlimeGolem.makeGolemTexture("slime");
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (Config.SLIME.getBoolean(ALLOW_SPECIAL)) {
                this.knockbackTarget(entity, Config.SLIME.getFloat(KNOCKBACK));
            }
            return true;
        }
        return false;
    }

    protected void func_70665_d(DamageSource source, float amount) {
        if (!this.func_180431_b(source)) {
            super.func_70665_d(source, amount);
            if (source.func_76364_f() != null && Config.SLIME.getBoolean(ALLOW_SPECIAL)) {
                this.knockbackTarget(source.func_76364_f(), Config.SLIME.getFloat(KNOCKBACK) * 0.325f);
            }
        }
    }

    protected void knockbackTarget(Entity entity, double KNOCKBACK_FACTOR) {
        double dX = Math.signum(entity.field_70165_t - this.field_70165_t) * KNOCKBACK_FACTOR;
        double dZ = Math.signum(entity.field_70161_v - this.field_70161_v) * KNOCKBACK_FACTOR;
        entity.func_70024_g(dX, KNOCKBACK_FACTOR / 4.0, dZ);
        entity.field_70133_I = true;
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Config.SLIME.getMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.29);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.5);
    }

    @Override
    public void addGolemDrops(List<WeightedItem> dropList, boolean recentlyHit, int lootingLevel) {
        int size = 11 + this.field_70146_Z.nextInt(16 + lootingLevel * 4);
        this.addDrop(dropList, new ItemStack(Items.field_151123_aH, size), 100);
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187888_ft;
    }
}

