/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemMultiTextured;
import com.golems.main.Config;
import com.golems.util.WeightedItem;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EntityWoodenGolem
extends GolemMultiTextured {
    public static final String woodPrefix = "wooden";
    public static final String[] woodTypes = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "big_oak"};

    public EntityWoodenGolem(World world) {
        super(world, Config.WOOD.getBaseAttack(), new ItemStack(Blocks.field_150364_r), woodPrefix, woodTypes);
        this.setCanSwim(true);
    }

    @Override
    public ItemStack getCreativeReturn() {
        Block block = Blocks.field_150364_r;
        int damage = this.getTextureNum() % woodTypes.length;
        if (this.getTextureNum() > 3) {
            block = Blocks.field_150363_s;
            damage %= 2;
        }
        return new ItemStack(block, 1, damage);
    }

    @Override
    public String getModId() {
        return "golems";
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Config.WOOD.getMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
    }

    @Override
    public void addGolemDrops(List<WeightedItem> dropList, boolean recentlyHit, int lootingLevel) {
        int size = 6 + this.field_70146_Z.nextInt(4 + lootingLevel * 4);
        int meta = this.getTextureNum() % woodTypes.length;
        this.addDrop(dropList, new ItemStack(Blocks.field_150344_f, size > 16 ? 16 : size, meta), 100);
        this.addDrop(dropList, Items.field_151055_y, 0, 1, 4, 10 + lootingLevel * 4);
        this.addDrop(dropList, Blocks.field_150345_g, 0, 1, 2, 4 + lootingLevel * 4);
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187897_gY;
    }
}

