/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.ai.EntityAIDefendAgainstMonsters;
import com.golems.main.GolemItems;
import com.golems.util.WeightedItem;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class GolemBase
extends EntityCreature
implements IAnimals {
    protected int attackTimer;
    protected boolean isPlayerCreated;
    protected ResourceLocation textureLoc;
    protected ItemStack creativeReturn;
    Village villageObj;
    protected boolean hasHome = false;
    private int homeCheckTimer = 70;
    protected double knockbackY = 0.4f;
    protected float criticalModifier = 2.25f;
    protected int criticalChance = 5;
    protected boolean takesFallDamage = false;
    protected boolean canDrown = false;
    protected boolean isLeashable = true;
    protected EntityAIBase swimmingAI = new EntityAISwimming((EntityLiving)this);

    private GolemBase(World world) {
        super(world);
        this.func_70105_a(1.4f, 2.9f);
        this.setCanTakeFallDamage(false);
        this.setCanSwim(false);
    }

    public GolemBase(World world, float attack, ItemStack pickBlock) {
        this(world);
        this.setCreativeReturn(pickBlock);
        this.setBaseAttackDamage(attack);
        this.field_70728_aV = 4 + this.field_70146_Z.nextInt((int)attack + 2);
    }

    public GolemBase(World world, float attack, Block pickBlock) {
        this(world, attack, new ItemStack(pickBlock, 1, 0));
    }

    public GolemBase(World world, float attack) {
        this(world, attack, GolemItems.golemHead);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, this.getBaseMoveSpeed() * 4.0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, this.getBaseMoveSpeed() * 3.75, 32.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, this.getBaseMoveSpeed() * 2.25, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, this.getBaseMoveSpeed() * 4.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, this.getBaseMoveSpeed() * 2.25));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIDefendAgainstMonsters(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 10, false, true, (Predicate)new Predicate<EntityLiving>(){

            public boolean apply(EntityLiving e) {
                return e != null && IMob.field_175450_e.apply((Object)e) && !(e instanceof EntityCreeper);
            }
        }));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.setTextureType(this.applyTexture());
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.22);
        this.applyAttributes();
    }

    protected void func_70619_bc() {
        if (--this.homeCheckTimer <= 0) {
            this.homeCheckTimer = 70 + this.field_70146_Z.nextInt(50);
            this.villageObj = this.field_70170_p.func_175714_ae().func_176056_a(new BlockPos((Entity)this), 32);
            if (this.villageObj == null) {
                this.func_110177_bN();
            } else {
                BlockPos blockpos = this.villageObj.func_180608_a();
                this.func_175449_a(blockpos, (int)((float)this.villageObj.func_75568_b() * 0.8f));
            }
        }
        super.func_70619_bc();
    }

    protected int func_70682_h(int i) {
        return this.canDrown ? super.func_70682_h(i) : i;
    }

    public boolean func_184652_a(EntityPlayer player) {
        return this.isLeashable && super.func_184652_a(player);
    }

    protected void func_82167_n(Entity entityIn) {
        if (entityIn instanceof IMob && !(entityIn instanceof EntityCreeper) && this.func_70681_au().nextInt(20) == 0) {
            this.func_70624_b((EntityLivingBase)entityIn);
        }
        super.func_82167_n(entityIn);
    }

    public void func_70636_d() {
        int k;
        int j;
        int i;
        IBlockState iblockstate;
        super.func_70636_d();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 2.500000277905201E-7 && this.field_70146_Z.nextInt(5) == 0 && (iblockstate = this.field_70170_p.func_180495_p(new BlockPos(i = MathHelper.func_76128_c((double)this.field_70165_t), j = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)), k = MathHelper.func_76128_c((double)this.field_70161_v)))).func_185904_a() != Material.field_151579_a) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
        }
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        return this.isPlayerCreated() && EntityPlayer.class.isAssignableFrom(cls) ? false : (cls == EntityCreeper.class ? false : super.func_70686_a(cls));
    }

    public boolean func_70652_k(Entity entity) {
        float VARIANCE = 0.8f;
        float currentAttack = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        float damage = currentAttack + (float)(this.field_70146_Z.nextDouble() - 0.5) * 0.8f * currentAttack;
        if (this.field_70146_Z.nextInt(100) < this.criticalChance) {
            damage *= this.criticalModifier;
        }
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        boolean flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), damage);
        if (flag) {
            entity.field_70181_x += this.knockbackY;
            this.func_174815_a((EntityLivingBase)this, entity);
        }
        this.func_184185_a(this.getThrowSound(), 1.0f, 0.9f + this.field_70146_Z.nextFloat() * 0.2f);
        return flag;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte b) {
        if (b == 4) {
            this.attackTimer = 10;
            this.func_184185_a(this.getThrowSound(), 1.0f, 0.9f + this.field_70146_Z.nextFloat() * 0.2f);
        } else {
            super.func_70103_a(b);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (this.canTakeFallDamage()) {
            super.func_180430_e(distance, damageMultiplier);
        }
    }

    public int func_82143_as() {
        return this.canTakeFallDamage() ? super.func_82143_as() : 64;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(this.getWalkingSound(), 0.76f, 0.9f + this.field_70146_Z.nextFloat() * 0.2f);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public int func_70627_aG() {
        return 24000;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return this.creativeReturn;
    }

    public void func_70645_a(DamageSource src) {
        if (!this.isPlayerCreated() && this.field_70717_bb != null && this.villageObj != null) {
            this.villageObj.func_82688_a(this.field_70717_bb.func_70005_c_(), -5);
        }
        super.func_70645_a(src);
    }

    protected void func_70628_a(boolean recentlyHit, int lootingLevel) {
        ArrayList<WeightedItem> drops = new ArrayList<WeightedItem>();
        this.addDrop(drops, (Block)(this.field_70146_Z.nextBoolean() ? Blocks.field_150327_N : Blocks.field_150328_O), 0, 1, 2, 65);
        this.addDrop(drops, Items.field_151137_ax, 0, 1, 1, 20 + lootingLevel * 10);
        this.addGolemDrops(drops, recentlyHit, lootingLevel);
        for (WeightedItem w : drops) {
            if (w == null || !w.shouldDrop(this.field_70146_Z)) continue;
            ItemStack drop = w.makeStack(this.field_70146_Z);
            this.func_70099_a(drop, 0.0f);
        }
    }

    protected boolean addDrop(List<WeightedItem> dropList, ItemStack stack, int percentChance) {
        return dropList.add(new WeightedItem(stack, percentChance));
    }

    protected boolean addDrop(List<WeightedItem> dropList, Item item, int meta, int min, int max, int percentChance) {
        return dropList.add(new WeightedItem(item, meta, min, max, percentChance));
    }

    protected boolean addDrop(List<WeightedItem> dropList, Block block, int meta, int min, int max, int percentChance) {
        return dropList.add(new WeightedItem(Item.func_150898_a((Block)block), meta, min, max, percentChance));
    }

    protected boolean removeFromList(List<WeightedItem> list, Item in, int meta) {
        boolean flag = false;
        for (WeightedItem w : list) {
            if (w == null || w.item != in || meta != Short.MAX_VALUE && w.meta != meta) continue;
            list.remove(w);
            flag = true;
        }
        return flag;
    }

    public void setTextureType(ResourceLocation texturelocation) {
        this.textureLoc = texturelocation;
    }

    public ResourceLocation getTextureType() {
        return this.textureLoc;
    }

    public void setCreativeReturn(Block blockToReturn) {
        this.setCreativeReturn(new ItemStack(blockToReturn, 1));
    }

    public void setCreativeReturn(ItemStack blockToReturn) {
        this.creativeReturn = blockToReturn;
    }

    public ItemStack getCreativeReturn() {
        return this.creativeReturn;
    }

    private void setBaseAttackDamage(float f) {
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)f);
    }

    public float getBaseAttackDamage() {
        return (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b();
    }

    public double getBaseMoveSpeed() {
        return this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b();
    }

    public Village getVillage() {
        return this.villageObj;
    }

    public void setCanTakeFallDamage(boolean toSet) {
        this.takesFallDamage = toSet;
    }

    public boolean canTakeFallDamage() {
        return this.takesFallDamage;
    }

    public void setCanSwim(boolean canSwim) {
        ((PathNavigateGround)this.func_70661_as()).func_179693_d(canSwim);
        if (canSwim) {
            this.field_70714_bg.func_75776_a(0, this.swimmingAI);
        } else {
            this.field_70714_bg.func_85156_a(this.swimmingAI);
        }
    }

    public void setPlayerCreated(boolean bool) {
        this.isPlayerCreated = bool;
    }

    public boolean isPlayerCreated() {
        return this.isPlayerCreated;
    }

    public boolean doesInteractChangeTexture() {
        return false;
    }

    public static ResourceLocation makeGolemTexture(String texture) {
        return GolemBase.makeGolemTexture("golems", texture);
    }

    public static ResourceLocation makeGolemTexture(String MODID, String texture) {
        return new ResourceLocation(MODID + ":textures/entity/golem_" + texture + ".png");
    }

    protected SoundEvent func_184639_G() {
        return this.getGolemSound();
    }

    protected SoundEvent getWalkingSound() {
        return this.getGolemSound();
    }

    public SoundEvent getThrowSound() {
        return this.getGolemSound();
    }

    protected SoundEvent func_184601_bQ() {
        return this.getGolemSound();
    }

    protected SoundEvent func_184615_bR() {
        return this.getGolemSound();
    }

    protected abstract void applyAttributes();

    protected abstract ResourceLocation applyTexture();

    public abstract void addGolemDrops(List<WeightedItem> var1, boolean var2, int var3);

    public abstract SoundEvent getGolemSound();
}

